/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.idea;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import org.antlr.works.idea.IdeaAction;
import org.antlr.works.idea.IdeaManagerDelegate;
import org.antlr.works.idea.IdeaOverlay;
import org.antlr.works.idea.IdeaProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaManager {
    protected List<IdeaProvider> providers = new ArrayList<IdeaProvider>();
    protected Timer timer = new Timer(1000, new TimerActionListener());
    protected IdeaOverlay overlay;
    protected IdeaManagerDelegate delegate;
    protected boolean enabled = true;
    protected int lastPosition;

    public IdeaManager() {
        this.timer.setRepeats(false);
    }

    public void setDelegate(IdeaManagerDelegate ideaManagerDelegate) {
        this.delegate = ideaManagerDelegate;
    }

    public void setOverlay(IdeaOverlay ideaOverlay) {
        this.overlay = ideaOverlay;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!this.enabled) {
            this.hide();
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void addProvider(IdeaProvider ideaProvider) {
        this.providers.add(ideaProvider);
    }

    public void close() {
        this.overlay.close();
        this.timer.stop();
    }

    public void hide() {
        this.timer.stop();
        this.overlay.hide();
    }

    public void displayAnyIdeasAvailable(int n) {
        if (!this.enabled) {
            return;
        }
        List<IdeaAction> list = this.generateIdeaActions(n);
        if (list == null || list.isEmpty()) {
            this.overlay.hide();
        } else {
            this.lastPosition = n;
            this.overlay.setIdeas(list);
            this.timer.restart();
        }
    }

    public List<IdeaAction> generateIdeaActions(int n) {
        ArrayList<IdeaAction> arrayList = new ArrayList<IdeaAction>();
        for (IdeaProvider ideaProvider : this.providers) {
            List<IdeaAction> list = ideaProvider.ideaProviderGetActions(n);
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    protected class TimerActionListener
    implements ActionListener {
        protected TimerActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<IdeaAction> list = IdeaManager.this.generateIdeaActions(IdeaManager.this.lastPosition);
            if (list.size() == 0) {
                return;
            }
            IdeaManager.this.overlay.setIdeas(list);
            if (IdeaManager.this.delegate != null && !IdeaManager.this.delegate.ideaManagerWillDisplayIdea()) {
                return;
            }
            IdeaManager.this.overlay.display();
        }
    }
}

