/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.decisiondfa;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.NFAState;
import org.antlr.tool.Grammar;
import org.antlr.tool.Rule;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.grammar.decisiondfa.DecisionDFAItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionDFAEngine {
    private CEditorGrammar editor;
    private Set<Integer> usesSemPreds = new HashSet<Integer>();
    private Set<Integer> usesSynPreds = new HashSet<Integer>();
    private Map<Integer, List<Integer>> decisionDFA = new HashMap<Integer, List<Integer>>();
    private Grammar discoveredLexerGrammar;
    private Grammar discoveredParserGrammar;

    public DecisionDFAEngine(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void close() {
        this.editor = null;
    }

    public void reset() {
        this.decisionDFA.clear();
    }

    public int getDecisionDFACount() {
        return this.decisionDFA.size();
    }

    public Grammar getDiscoveredLexerGrammar() {
        return this.discoveredLexerGrammar;
    }

    public Grammar getDiscoveredParserGrammar() {
        return this.discoveredParserGrammar;
    }

    public void discoverAllDecisions() throws Exception {
        this.discover(0, this.editor.getTextEditor().getText().length());
    }

    private void discover(int n, int n2) throws Exception {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = n; i < n2; ++i) {
            hashSet.add(this.editor.getTextEditor().getLineIndexAtTextPosition(i));
        }
        EngineGrammar engineGrammar = this.editor.getEngineGrammar();
        engineGrammar.analyze();
        this.discoveredLexerGrammar = engineGrammar.getLexerGrammar();
        this.discoveredParserGrammar = engineGrammar.getParserGrammar();
        this.decisionDFA.clear();
        this.usesSynPreds.clear();
        this.usesSemPreds.clear();
        this.discover(this.discoveredLexerGrammar, hashSet, this.usesSemPreds, this.usesSynPreds);
        this.discover(this.discoveredParserGrammar, hashSet, this.usesSemPreds, this.usesSynPreds);
    }

    private void discover(Grammar grammar, Set<Integer> set, Set<Integer> set2, Set<Integer> set3) {
        if (grammar == null) {
            return;
        }
        if (grammar.decisionsWhoseDFAsUsesSemPreds != null) {
            for (DFA object : grammar.decisionsWhoseDFAsUsesSemPreds) {
                set2.add(object.getDecisionNumber());
            }
        }
        if (grammar.decisionsWhoseDFAsUsesSynPreds != null) {
            for (DFA dFA : grammar.decisionsWhoseDFAsUsesSynPreds) {
                set3.add(dFA.getDecisionNumber());
            }
        }
        for (Integer n : set) {
            this.addPositions(n, grammar.getLookaheadDFAColumnsForLineInFile(n));
        }
    }

    public void addPositions(Integer n, List<Integer> list) {
        if (list.isEmpty()) {
            return;
        }
        this.decisionDFA.put(n, list);
    }

    public boolean isDecisionPointAroundLocation(int n, int n2) {
        List<Integer> list = this.decisionDFA.get(n + 1);
        return list != null && (list.contains(n2 - 1) || list.contains(n2));
    }

    public List<DecisionDFAItem> getDecisionDFAItems() {
        ArrayList<DecisionDFAItem> arrayList = new ArrayList<DecisionDFAItem>();
        for (int n : this.decisionDFA.keySet()) {
            for (int n2 : this.decisionDFA.get(n)) {
                Object object;
                Object object2;
                DFA dFA = this.getDFAAtPosition(n, n2);
                if (dFA == null) {
                    System.err.println("DFA is null for line " + n + " and column " + n2);
                    continue;
                }
                Grammar grammar = this.discoveredLexerGrammar;
                if (grammar != null) {
                    object2 = grammar.getRule("Tokens");
                    object = (NFAState)((Rule)object2).startState.transition((int)0).target;
                    if (object == null) {
                        System.err.println("NFAState s is null for rule " + ((Rule)object2).name);
                        continue;
                    }
                    if (dFA.getDecisionNumber() == ((NFAState)object).getDecisionNumber()) continue;
                }
                object2 = new Color(0, 128, 64);
                object = "DFA decision " + dFA.getDecisionNumber();
                String string = "";
                if (this.usesSemPreds.contains(dFA.getDecisionNumber())) {
                    string = string + "uses semantic predicate";
                    object2 = new Color(255, 220, 0);
                } else if (this.usesSynPreds.contains(dFA.getDecisionNumber())) {
                    string = string + "uses syntactic predicate";
                    object2 = new Color(255, 220, 0);
                }
                if (dFA.isCyclic()) {
                    if (string.length() > 0) {
                        string = string + ", ";
                    }
                    string = string + "cyclic";
                }
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + dFA.getNumberOfStates() + " states";
                Point point = this.editor.textEditor.getLineTextPositionsAtLineIndex(n - 1);
                DecisionDFAItem decisionDFAItem = new DecisionDFAItem(this.editor);
                decisionDFAItem.setAttributes(null, point.x + n2 - 1, point.x + n2, n - 1, (Color)object2, (String)object + " (" + string + ")");
                decisionDFAItem.shape = 3;
                arrayList.add(decisionDFAItem);
            }
        }
        return arrayList;
    }

    public DFA getDFAAtPosition(int n, int n2) {
        DFA dFA = null;
        if (this.discoveredParserGrammar != null) {
            dFA = this.discoveredParserGrammar.getLookaheadDFAFromPositionInFile(n, n2);
        }
        if (dFA == null && this.discoveredLexerGrammar != null) {
            dFA = this.discoveredLexerGrammar.getLookaheadDFAFromPositionInFile(n, n2);
        }
        return dFA;
    }

    public void refreshMenu() {
        this.editor.getXJFrame().getMainMenuBar().refreshMenuState(this.editor.editorMenu.menuGrammar);
    }

    public void refresh() {
        this.editor.textEditor.damage();
        this.editor.textEditor.repaint();
    }
}

