/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.decisiondfa;

import java.util.Collections;
import java.util.List;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.tool.DOTGenerator;
import org.antlr.tool.Grammar;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.grammar.GrammarDOTTab;
import org.antlr.works.grammar.decisiondfa.DecisionDFAEngine;

public class DecisionDFA
extends GrammarDOTTab {
    protected int line;
    protected int column;
    protected int decisionNumber;

    public DecisionDFA(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar);
    }

    protected boolean willLaunch() {
        return this.checkForCurrentRule();
    }

    public void willRun() {
        this.line = this.editor.getTextEditor().getCurrentLinePosition();
        this.column = this.editor.getTextEditor().getCurrentColumnPosition();
    }

    public String getDOTString() throws Exception {
        DecisionDFAEngine decisionDFAEngine = this.editor.decisionDFAEngine;
        Grammar grammar = decisionDFAEngine.getDiscoveredParserGrammar();
        int n = this.getDecisionColumn(grammar);
        if (n == -1) {
            grammar = decisionDFAEngine.getDiscoveredLexerGrammar();
            n = this.getDecisionColumn(grammar);
        }
        if (n == -1) {
            throw new Exception("No decision in the current line");
        }
        CodeGenerator codeGenerator = new CodeGenerator(new Tool(), grammar, (String)decisionDFAEngine.getDiscoveredParserGrammar().getOption("language"));
        DFA dFA = grammar.getLookaheadDFAFromPositionInFile(this.line, n);
        this.decisionNumber = dFA.getDecisionNumber();
        DOTGenerator dOTGenerator = new DOTGenerator(grammar);
        grammar.setCodeGenerator(codeGenerator);
        dOTGenerator.setArrowheadType("none");
        dOTGenerator.setRankdir("LR");
        return dOTGenerator.getDOT(dFA.startState);
    }

    public int getDecisionColumn(Grammar grammar) {
        List list = grammar.getLookaheadDFAColumnsForLineInFile(this.line);
        Collections.sort(list);
        int n = -1;
        for (int i = list.size() - 1; i >= 0; --i) {
            Integer n2 = (Integer)list.get(i);
            if (n2 <= this.column) {
                n = n2;
                break;
            }
            if (i != 0) continue;
            n = n2;
        }
        return n;
    }

    public String getTabName() {
        return "Decision " + this.decisionNumber + " of \"" + this.rule.name + "\"";
    }
}

