/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar;

import java.util.ArrayList;
import java.util.List;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.grammar.GrammarDOTTab;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class RulesDependency
extends GrammarDOTTab {
    protected List<String> visitedRules = new ArrayList<String>();
    protected List<String> visitedRefs = new ArrayList<String>();
    protected StringBuffer dependency;
    protected boolean includeLexerRefs;

    public RulesDependency(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar);
    }

    protected boolean willLaunch() {
        if (!this.checkForCurrentRule()) {
            return false;
        }
        ElementRule elementRule = this.editor.getCurrentRule();
        List<ElementReference> list = this.editor.rules.getReferencesInRule(elementRule);
        if (list == null || list.isEmpty()) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "The selected rule doesn't contain any references");
            return false;
        }
        this.includeLexerRefs = true;
        if (!elementRule.lexer && this.editor.getEngineGrammar().getType() == 0) {
            this.includeLexerRefs = XJAlert.displayAlertYESNO(this.editor.getWindowContainer(), "Rule Dependency Graph", "Do you want to include lexer references ?") == 0;
        }
        return true;
    }

    public String getDOTString() throws Exception {
        ElementRule elementRule = this.editor.getCurrentRule();
        this.visitedRules.clear();
        this.visitedRefs.clear();
        this.dependency = new StringBuffer();
        this.dependency.append("digraph {\n");
        this.buildGraph(elementRule);
        this.dependency.append("}");
        return this.dependency.toString();
    }

    protected void buildGraph(ElementRule elementRule) {
        if (elementRule == null) {
            return;
        }
        this.visitedRules.add(elementRule.name);
        List<ElementReference> list = this.editor.rules.getReferencesInRule(elementRule);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ElementReference elementReference : list) {
            String string = elementReference.token.getAttribute();
            String string2 = elementRule.name + " -> " + string;
            if (this.visitedRefs.contains(string2) || ATEToken.isLexerName(elementReference.token.getAttribute()) && !this.includeLexerRefs) continue;
            this.visitedRefs.add(string2);
            this.dependency.append(string2);
            this.dependency.append(";\n");
            if (this.visitedRules.contains(string)) continue;
            this.buildGraph(this.editor.rules.getRuleWithName(string));
        }
    }

    public String getTabName() {
        return "Dependency of \"" + this.rule.name + "\"";
    }
}

