/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.antlr.Tool;
import org.antlr.analysis.NFAState;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarNonDeterminismMessage;
import org.antlr.tool.GrammarUnreachableAltsMessage;
import org.antlr.tool.Message;
import org.antlr.tool.NonRegularDecisionMessage;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.grammar.EngineGrammarDelegate;
import org.antlr.works.grammar.EngineGrammarError;
import org.antlr.works.grammar.EngineGrammarResult;
import org.antlr.works.syntax.element.ElementGrammarName;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.ErrorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineGrammar {
    private Grammar parserGrammar;
    private Grammar lexerGrammar;
    private List<EngineGrammarError> errors;
    private boolean needsToCreateGrammar;
    private boolean needsToAnalyzeGrammar;
    private EngineGrammarResult createGrammarResult = new EngineGrammarResult();
    private EngineGrammarResult analyzeResult = new EngineGrammarResult();
    private CEditorGrammar editor;
    private EngineGrammarDelegate delegate;

    public EngineGrammar(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
        this.errors = new ArrayList<EngineGrammarError>();
        this.markDirty();
    }

    public void close() {
        this.delegate = null;
        this.editor = null;
        this.errors = null;
    }

    public EngineGrammarDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(EngineGrammarDelegate engineGrammarDelegate) {
        this.delegate = engineGrammarDelegate;
    }

    public void markDirty() {
        this.needsToCreateGrammar = true;
        this.needsToAnalyzeGrammar = true;
    }

    public Grammar getParserGrammar() {
        return this.parserGrammar;
    }

    public Grammar getLexerGrammar() {
        return this.lexerGrammar;
    }

    public NFAState getRuleStartState(String string) throws Exception {
        this.createGrammars();
        Grammar grammar = ATEToken.isLexerName(string) ? this.getLexerGrammar() : this.getParserGrammar();
        return grammar == null ? null : grammar.getRuleStartState(string);
    }

    public Grammar getGrammarForRule(String string) throws Exception {
        this.createGrammars();
        if (ATEToken.isLexerName(string)) {
            return this.getLexerGrammar();
        }
        return this.getParserGrammar();
    }

    public List<EngineGrammarError> getErrors() {
        return this.errors;
    }

    public boolean isTreeParserGrammar() {
        return this.getType() == 3;
    }

    public boolean hasGrammar() {
        switch (this.getType()) {
            case 0: {
                return this.parserGrammar != null;
            }
            case 1: 
            case 3: {
                return this.parserGrammar != null;
            }
            case 2: {
                return this.lexerGrammar != null;
            }
        }
        return false;
    }

    public Grammar getANTLRGrammar() {
        switch (this.getType()) {
            case 0: {
                return this.parserGrammar;
            }
            case 1: 
            case 3: {
                return this.parserGrammar;
            }
            case 2: {
                return this.lexerGrammar;
            }
        }
        return null;
    }

    public Tool getANTLRTool() {
        return this.delegate.getANTLRTool();
    }

    public String getName() {
        ElementGrammarName elementGrammarName = this.editor.parserEngine.getName();
        if (elementGrammarName == null) {
            return null;
        }
        return elementGrammarName.getName();
    }

    public int getType() {
        ElementGrammarName elementGrammarName = this.editor.parserEngine.getName();
        if (elementGrammarName == null) {
            return 0;
        }
        return elementGrammarName.getType();
    }

    public String getFileName() {
        String string = this.delegate.getFileName();
        return string == null ? "<notsaved>" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGrammars() throws Exception {
        if (!this.needsToCreateGrammar) {
            return;
        }
        ErrorListener errorListener = ErrorListener.getThreadInstance();
        ErrorManager.setErrorListener(errorListener);
        this.parserGrammar = null;
        this.lexerGrammar = null;
        try {
            switch (this.getType()) {
                case 0: {
                    this.createCombinedGrammar();
                    break;
                }
                case 1: 
                case 3: {
                    this.createParserGrammar();
                    break;
                }
                case 2: {
                    this.createLexerGrammar();
                }
            }
            this.needsToCreateGrammar = false;
        }
        finally {
            this.createGrammarResult.setErrors(errorListener.errors);
            this.createGrammarResult.setWarnings(errorListener.warnings);
            errorListener.clear();
        }
    }

    private Grammar createNewGrammar(String string, String string2) throws TokenStreamException, RecognitionException {
        Grammar grammar = new Grammar();
        grammar.setTool(this.getANTLRTool());
        grammar.setFileName(string);
        grammar.setGrammarContent(string2);
        return grammar;
    }

    private void createCombinedGrammar() throws Exception {
        this.createParserGrammar();
        this.lexerGrammar = this.createLexerGrammarFromCombinedGrammar(this.parserGrammar);
    }

    private Grammar createLexerGrammarFromCombinedGrammar(Grammar grammar) throws Exception {
        String string = grammar.getLexerGrammar();
        if (string == null) {
            return null;
        }
        Grammar grammar2 = new Grammar();
        grammar2.setTool(this.getANTLRTool());
        grammar2.setFileName("<internally-generated-lexer>");
        grammar2.importTokenVocabulary(grammar);
        grammar2.setGrammarContent(string);
        grammar2.createNFAs();
        return grammar2;
    }

    private void createParserGrammar() throws TokenStreamException, RecognitionException {
        this.parserGrammar = this.createNewGrammar(this.getFileName(), this.delegate.getText());
        this.parserGrammar.createNFAs();
    }

    private void createLexerGrammar() throws TokenStreamException, RecognitionException {
        this.lexerGrammar = this.createNewGrammar(this.getFileName(), this.editor.getText());
        this.lexerGrammar.createNFAs();
    }

    public void printLeftRecursionToConsole(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Aborting because the following rules are mutually left-recursive:");
        for (Object e : list) {
            Set set = (Set)e;
            stringBuffer.append("\n    ");
            stringBuffer.append(set);
        }
        this.editor.getConsole().println(stringBuffer.toString(), 2);
    }

    public void markLeftRecursiveRules(List list) {
        for (Object e : list) {
            Set set = (Set)e;
            for (Object e2 : set) {
                String string = (String)e2;
                ElementRule elementRule = this.editor.rules.getRuleWithName(string);
                if (elementRule == null) continue;
                elementRule.setLeftRecursiveRulesSet(set);
            }
        }
    }

    public EngineGrammarResult analyze() throws Exception {
        if (!this.needsToAnalyzeGrammar) {
            return this.analyzeCompleted(null);
        }
        ErrorListener errorListener = ErrorListener.getThreadInstance();
        ErrorManager.setErrorListener(errorListener);
        this.createGrammars();
        Grammar grammar = this.getANTLRGrammar();
        if (grammar == null) {
            return this.analyzeCompleted(errorListener);
        }
        List list = grammar.checkAllRulesForLeftRecursion();
        if (!list.isEmpty()) {
            this.printLeftRecursionToConsole(list);
            this.markLeftRecursiveRules(list);
        }
        if (ErrorManager.doNotAttemptAnalysis()) {
            return this.analyzeCompleted(errorListener);
        }
        try {
            grammar.createLookaheadDFAs();
            if (this.getType() == 0 && this.lexerGrammar != null) {
                this.lexerGrammar.createLookaheadDFAs();
            }
            this.buildNonDeterministicErrors(errorListener);
            this.markRulesWithWarningsOrErrors();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.analyzeCompleted(errorListener);
    }

    public EngineGrammarResult analyzeCompleted(ErrorListener errorListener) throws InvocationTargetException, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.editor.engineGrammarDidAnalyze();
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    EngineGrammar.this.editor.engineGrammarDidAnalyze();
                }
            });
        }
        if (errorListener != null) {
            this.needsToAnalyzeGrammar = false;
            this.analyzeResult.setErrors(errorListener.errors);
            this.analyzeResult.setWarnings(errorListener.warnings);
            errorListener.clear();
        }
        return this.getCompleteResult();
    }

    private EngineGrammarResult getCompleteResult() {
        EngineGrammarResult engineGrammarResult = new EngineGrammarResult();
        engineGrammarResult.errors.clear();
        engineGrammarResult.errors.addAll(this.createGrammarResult.errors);
        engineGrammarResult.errors.addAll(this.analyzeResult.errors);
        engineGrammarResult.warnings.clear();
        engineGrammarResult.warnings.addAll(this.createGrammarResult.warnings);
        engineGrammarResult.warnings.addAll(this.analyzeResult.warnings);
        this.createGrammarResult.errors.clear();
        this.analyzeResult.errors.clear();
        return engineGrammarResult;
    }

    public void cancel() {
        Grammar grammar = this.getANTLRGrammar();
        if (grammar != null) {
            grammar.externallyAbortNFAToDFAConversion();
        }
    }

    protected void buildNonDeterministicErrors(ErrorListener errorListener) {
        this.errors.clear();
        for (Message message : errorListener.warnings) {
            this.buildError(message);
        }
        for (Message message : errorListener.errors) {
            this.buildError(message);
        }
    }

    protected void buildError(Object object) {
        if (object instanceof GrammarUnreachableAltsMessage) {
            this.errors.add(this.buildUnreachableAltsError((GrammarUnreachableAltsMessage)object));
        } else if (object instanceof GrammarNonDeterminismMessage) {
            this.errors.add(this.buildNonDeterministicError((GrammarNonDeterminismMessage)object));
        } else if (object instanceof NonRegularDecisionMessage) {
            this.errors.add(this.buildNonRegularDecisionError((NonRegularDecisionMessage)object));
        }
    }

    protected EngineGrammarError buildNonDeterministicError(GrammarNonDeterminismMessage grammarNonDeterminismMessage) {
        EngineGrammarError engineGrammarError = new EngineGrammarError();
        engineGrammarError.setLine(grammarNonDeterminismMessage.probe.dfa.getDecisionASTNode().getLine() - 1);
        List list = grammarNonDeterminismMessage.probe.getSampleNonDeterministicInputSequence(grammarNonDeterminismMessage.problemState);
        engineGrammarError.setLabels(list);
        String string = grammarNonDeterminismMessage.probe.getInputSequenceDisplay(list);
        engineGrammarError.setMessageText("Decision can match input such as \"" + string + "\" using multiple alternatives");
        engineGrammarError.setMessage(grammarNonDeterminismMessage);
        return engineGrammarError;
    }

    protected EngineGrammarError buildUnreachableAltsError(GrammarUnreachableAltsMessage grammarUnreachableAltsMessage) {
        EngineGrammarError engineGrammarError = new EngineGrammarError();
        engineGrammarError.setLine(grammarUnreachableAltsMessage.probe.dfa.getDecisionASTNode().getLine() - 1);
        engineGrammarError.setMessageText("The following alternatives are unreachable: " + grammarUnreachableAltsMessage.alts);
        engineGrammarError.setMessage(grammarUnreachableAltsMessage);
        return engineGrammarError;
    }

    protected EngineGrammarError buildNonRegularDecisionError(NonRegularDecisionMessage nonRegularDecisionMessage) {
        EngineGrammarError engineGrammarError = new EngineGrammarError();
        engineGrammarError.setLine(nonRegularDecisionMessage.probe.dfa.getDecisionASTNode().getLine() - 1);
        engineGrammarError.setMessageText(nonRegularDecisionMessage.toString());
        engineGrammarError.setMessage(nonRegularDecisionMessage);
        return engineGrammarError;
    }

    protected void markRulesWithWarningsOrErrors() throws Exception {
        this.editor.visual.clearCacheGraphs();
        for (ElementRule elementRule : this.editor.getParserEngine().getRules()) {
            this.updateRuleWithErrors(elementRule, this.fetchErrorsForRule(elementRule));
        }
        this.editor.rules.refreshRules();
    }

    protected void updateRuleWithErrors(ElementRule elementRule, List<EngineGrammarError> list) throws Exception {
        elementRule.setErrors(list);
        elementRule.setNeedsToBuildErrors(true);
    }

    protected List<EngineGrammarError> fetchErrorsForRule(ElementRule elementRule) {
        ArrayList<EngineGrammarError> arrayList = new ArrayList<EngineGrammarError>();
        for (EngineGrammarError engineGrammarError : this.getErrors()) {
            if (engineGrammarError.line < elementRule.start.startLineNumber || engineGrammarError.line > elementRule.end.startLineNumber) continue;
            arrayList.add(engineGrammarError);
        }
        return arrayList;
    }

    public void computeRuleErrors(ElementRule elementRule) {
        List<EngineGrammarError> list = elementRule.getErrors();
        for (EngineGrammarError engineGrammarError : list) {
            Message message = engineGrammarError.getMessage();
            if (message instanceof GrammarUnreachableAltsMessage) {
                this.computeRuleError(elementRule, engineGrammarError, (GrammarUnreachableAltsMessage)message);
                continue;
            }
            if (message instanceof GrammarNonDeterminismMessage) {
                this.computeRuleError(elementRule, engineGrammarError, (GrammarNonDeterminismMessage)message);
                continue;
            }
            if (!(message instanceof NonRegularDecisionMessage)) continue;
            this.computeRuleError(elementRule, engineGrammarError, (NonRegularDecisionMessage)message);
        }
        try {
            this.editor.visual.createGraphsForRule(elementRule);
        }
        catch (Exception exception) {
            // empty catch block
        }
        elementRule.setNeedsToBuildErrors(false);
    }

    public void computeRuleError(ElementRule elementRule, EngineGrammarError engineGrammarError, GrammarNonDeterminismMessage grammarNonDeterminismMessage) {
        List list = grammarNonDeterminismMessage.probe.getNonDeterministicAltsForState(grammarNonDeterminismMessage.problemState);
        Set set = grammarNonDeterminismMessage.probe.getDisabledAlternatives(grammarNonDeterminismMessage.problemState);
        int n = 0;
        for (Object e : list) {
            Integer n2 = (Integer)e;
            NFAState nFAState = grammarNonDeterminismMessage.probe.dfa.getNFADecisionStartState();
            int n3 = nFAState.translateDisplayAltToWalkAlt(grammarNonDeterminismMessage.probe.dfa, n2);
            if (n == 0) {
                n = n3;
            }
            List list2 = grammarNonDeterminismMessage.probe.getNFAPathStatesForAlt(n, n3, engineGrammarError.getLabels());
            engineGrammarError.addPath(list2, set.contains(n2));
            engineGrammarError.addStates(list2);
            for (Object e2 : list2) {
                NFAState nFAState2 = (NFAState)e2;
                engineGrammarError.addRule(nFAState2.getEnclosingRule());
            }
        }
    }

    public void computeRuleError(ElementRule elementRule, EngineGrammarError engineGrammarError, GrammarUnreachableAltsMessage grammarUnreachableAltsMessage) {
        NFAState nFAState = grammarUnreachableAltsMessage.probe.dfa.getNFADecisionStartState();
        for (Object e : grammarUnreachableAltsMessage.alts) {
            engineGrammarError.addUnreachableAlt(nFAState, (Integer)e);
            engineGrammarError.addStates(nFAState);
            engineGrammarError.addRule(nFAState.getEnclosingRule());
        }
    }

    public void computeRuleError(ElementRule elementRule, EngineGrammarError engineGrammarError, NonRegularDecisionMessage nonRegularDecisionMessage) {
        NFAState nFAState = nonRegularDecisionMessage.probe.dfa.getNFADecisionStartState();
        for (Object e : nonRegularDecisionMessage.altsWithRecursion) {
            engineGrammarError.addUnreachableAlt(nFAState, (Integer)e);
            engineGrammarError.addStates(nFAState);
            engineGrammarError.addRule(nFAState.getEnclosingRule());
        }
    }
}

