/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.generate;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.antlr.works.editor.EditorProvider;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.foundation.XJSystem;

public class DialogGenerate
extends XJDialog {
    private JPanel dialogPane;
    private JPanel contentPane;
    private JLabel label1;
    private JTextField outputPathField;
    private JButton browseButton;
    private JCheckBox debugInfoButton;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public DialogGenerate(Container container, EditorProvider editorProvider) {
        super(container, true);
        this.initComponents();
        this.setSize(612, 145);
        if (XJSystem.isMacOS()) {
            CellConstraints cellConstraints = new CellConstraints();
            this.buttonBar.remove(this.cancelButton);
            this.buttonBar.remove(this.okButton);
            this.buttonBar.add((Component)this.cancelButton, cellConstraints.xy(2, 1));
            this.buttonBar.add((Component)this.okButton, cellConstraints.xy(4, 1));
        }
        this.setDefaultButton(this.okButton);
        this.setOKButton(this.okButton);
        this.setCancelButton(this.cancelButton);
        this.outputPathField.setText(editorProvider.getOutputPath());
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJFileChooser.shared().displayChooseDirectory(DialogGenerate.this.getJavaComponent())) {
                    DialogGenerate.this.outputPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                }
            }
        });
    }

    public void dialogWillCloseOK() {
        AWPrefs.setOutputPath(this.getOutputPath());
    }

    public void setDebugOnly() {
        this.debugInfoButton.setSelected(true);
        this.debugInfoButton.setVisible(false);
    }

    public boolean generateDebugInformation() {
        return this.debugInfoButton.isSelected();
    }

    public String getOutputPath() {
        return this.outputPathField.getText();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPane = new JPanel();
        this.label1 = new JLabel();
        this.outputPathField = new JTextField();
        this.browseButton = new JButton();
        this.debugInfoButton = new JCheckBox();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        this.setTitle("Generate");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPane.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;200dlu):grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label1.setText("Output path:");
        this.label1.setHorizontalAlignment(4);
        this.contentPane.add((Component)this.label1, cellConstraints.xy(1, 1));
        this.contentPane.add((Component)this.outputPathField, cellConstraints.xy(3, 1));
        this.browseButton.setText("Browse...");
        this.contentPane.add((Component)this.browseButton, cellConstraints.xy(5, 1));
        this.debugInfoButton.setText("Debug information");
        this.contentPane.add((Component)this.debugInfoButton, cellConstraints.xy(3, 3));
        this.dialogPane.add((Component)this.contentPane, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")));
        this.okButton.setText("OK");
        this.buttonBar.add((Component)this.okButton, cellConstraints.xy(2, 1));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, cellConstraints.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        container.add((Component)this.dialogPane, "Center");
        this.pack();
    }
}

