/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.generate;

import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.antlr.Tool;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.works.editor.EditorProvider;
import org.antlr.works.generate.CodeGenerateDelegate;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerate
implements Runnable {
    protected boolean debug = true;
    protected EditorProvider provider;
    protected CodeGenerateDelegate delegate;
    protected long dateOfModificationOnDisk = 0L;
    protected String lastError;
    public static final String LEXER_SUFFIX = "Lexer";
    public static final String PARSER_SUFFIX = "Parser";
    public static final String TREEPARSER_SUFFIX = "";
    protected String generateError = null;
    protected XJDialogProgress progress;

    public CodeGenerate(EditorProvider editorProvider, CodeGenerateDelegate codeGenerateDelegate) {
        this.provider = editorProvider;
        this.delegate = codeGenerateDelegate;
    }

    public void close() {
        this.provider = null;
        this.delegate = null;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public String getOutputPath() {
        return this.provider.getOutputPath();
    }

    public String getGrammarLanguage() {
        try {
            EngineGrammar engineGrammar = this.provider.getEngineGrammar();
            engineGrammar.createGrammars();
            Grammar grammar = engineGrammar.getParserGrammar();
            if (grammar == null) {
                grammar = engineGrammar.getLexerGrammar();
            }
            if (grammar != null) {
                return (String)grammar.getOption("language");
            }
            return null;
        }
        catch (Exception exception) {
            this.provider.getConsole().print(exception);
            return null;
        }
    }

    public String getGrammarName() {
        return this.provider.getEngineGrammar().getName();
    }

    public String getLastError() {
        return this.lastError;
    }

    public boolean generate() {
        boolean bl;
        ErrorListener errorListener = ErrorListener.getThreadInstance();
        ErrorManager.setErrorListener(errorListener);
        String[] stringArray = this.debug ? new String[]{"-debug", "-o", this.getOutputPath(), "-lib", this.provider.getFileFolder(), this.provider.getFilePath()} : new String[]{"-o", this.getOutputPath(), "-lib", this.provider.getFileFolder(), this.provider.getFilePath()};
        Tool tool = new Tool(Utils.concat(stringArray, AWPrefs.getANTLR3Options()));
        tool.process();
        boolean bl2 = bl = !errorListener.hasErrors();
        if (bl) {
            this.dateOfModificationOnDisk = this.provider.getDocument().getDateOfModificationOnDisk();
        }
        this.lastError = errorListener.getFirstErrorMessage();
        errorListener.clear();
        return bl;
    }

    public String getGeneratedClassName(int n) throws Exception {
        String string = null;
        EngineGrammar engineGrammar = this.provider.getEngineGrammar();
        engineGrammar.createGrammars();
        if (n == 2) {
            Grammar grammar = engineGrammar.getLexerGrammar();
            if (grammar == null) {
                return null;
            }
            string = grammar.name + LEXER_SUFFIX;
        } else if (n == 1) {
            Grammar grammar = engineGrammar.getParserGrammar();
            if (grammar == null) {
                return null;
            }
            string = engineGrammar.getType() == 3 ? grammar.name + TREEPARSER_SUFFIX : grammar.name + PARSER_SUFFIX;
        } else if (n == 3) {
            Grammar grammar = engineGrammar.getParserGrammar();
            if (grammar == null) {
                return null;
            }
            if (engineGrammar.getType() != 3) {
                return null;
            }
            string = grammar.name + TREEPARSER_SUFFIX;
        }
        return string;
    }

    public List<String> getGeneratedTextFileNames() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getGeneratedTextFileName(2);
        if (string != null) {
            arrayList.add(string);
        }
        if ((string = this.getGeneratedTextFileName(1)) != null) {
            arrayList.add(string);
        }
        if ((string = this.getGeneratedTextFileName(3)) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getGeneratedTextFileName(int n) throws Exception {
        String string = this.getGeneratedClassName(n);
        if (string == null) {
            return null;
        }
        return XJUtils.concatPath(this.getOutputPath(), string + ".java");
    }

    public boolean isGeneratedTextFileExisting(int n) {
        try {
            String string = this.getGeneratedTextFileName(n);
            if (string == null) {
                return true;
            }
            return new File(string).exists();
        }
        catch (Exception exception) {
            this.provider.getConsole().print(exception);
            return false;
        }
    }

    public boolean isFileModifiedSinceLastGeneration() {
        return this.dateOfModificationOnDisk != this.provider.getDocument().getDateOfModificationOnDisk();
    }

    public boolean supportsLexer() {
        int n = this.provider.getEngineGrammar().getType();
        return n == 0 || n == 2;
    }

    public boolean supportsParser() {
        int n = this.provider.getEngineGrammar().getType();
        return n == 0 || n == 1 || n == 3;
    }

    public String getGeneratedText(int n) throws Exception {
        return XJUtils.getStringFromFile(this.getGeneratedTextFileName(n));
    }

    public void generateInThread(Container container) {
        this.progress = new XJDialogProgress(container);
        this.progress.setInfo("Generating...");
        this.progress.setCancellable(false);
        this.progress.setIndeterminate(true);
        this.progress.display();
        new Thread(this).start();
    }

    public void generateInThreadDidTerminate() {
        this.progress.close();
        if (this.generateError != null) {
            XJAlert.display(this.provider.getWindowContainer(), "Error", "Cannot generate the grammar because:\n" + this.generateError);
        } else if (this.delegate == null || this.delegate.codeGenerateDisplaySuccess()) {
            XJAlert.display(this.provider.getWindowContainer(), "Success", "The grammar has been successfully generated in path:\n" + this.getOutputPath());
        } else {
            this.delegate.codeGenerateDidComplete();
        }
    }

    @Override
    public void run() {
        this.generateError = null;
        this.provider.getConsole().setMode(1);
        try {
            if (!this.generate()) {
                this.generateError = this.getLastError();
            }
        }
        catch (Exception exception) {
            this.generateError = exception.toString();
            this.provider.getConsole().print(exception);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CodeGenerate.this.generateInThreadDidTerminate();
            }
        });
    }
}

