/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.generate;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.syntax.java.ATEJavaSyntaxEngine;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

public class CodeDisplay
extends EditorTab {
    protected ATEPanel textEditor;
    protected String title;

    public CodeDisplay(XJFrameInterface xJFrameInterface) {
        this.textEditor = new ATEPanel(xJFrameInterface);
        this.textEditor.setParserEngine(new ATEJavaSyntaxEngine());
        this.textEditor.setSyntaxColoring(true);
        this.textEditor.setAnalysisColumnVisible(false);
        this.textEditor.setFoldingEnabled(AWPrefs.getFoldingEnabled());
        this.textEditor.setLineNumberEnabled(AWPrefs.getLineNumberEnabled());
        this.textEditor.setHighlightCursorLine(AWPrefs.getHighlightCursorEnabled());
        this.textEditor.setEditable(false);
        this.applyFont();
    }

    public void applyFont() {
        this.textEditor.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.textEditor.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
    }

    public void setText(String string) {
        this.textEditor.loadText(string);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Container getContainer() {
        return this.textEditor;
    }

    public String getTabName() {
        return this.title;
    }

    public Component getTabComponent() {
        return this.getContainer();
    }
}

