/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.syntax.element.ElementRule;

public class Usages
extends EditorTab {
    protected JPanel panel;
    protected JScrollPane treeScrollPane;
    protected JTree tree;
    protected DefaultTreeModel model;
    protected DefaultMutableTreeNode root;
    protected DefaultMutableTreeNode node;
    protected String lastRule;
    protected CEditorGrammar editor;
    protected ATEToken token;

    public Usages(CEditorGrammar cEditorGrammar, ATEToken aTEToken) {
        this.editor = cEditorGrammar;
        this.token = aTEToken;
        this.panel = new JPanel(new BorderLayout());
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                int n = Usages.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = Usages.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() != 1 && mouseEvent.getClickCount() == 2 && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof UsageMatch) {
                    Usages.this.selectMatch((UsageMatch)defaultMutableTreeNode.getUserObject());
                }
            }
        });
        this.treeScrollPane = new JScrollPane(this.tree);
        this.treeScrollPane.setWheelScrollingEnabled(true);
        this.panel.add((Component)this.treeScrollPane, "Center");
        this.root = new DefaultMutableTreeNode();
        this.model = new DefaultTreeModel(this.root);
        this.lastRule = null;
        this.tree.setModel(this.model);
    }

    public Container getContainer() {
        return this.panel;
    }

    public void addMatch(ElementRule elementRule, ATEToken aTEToken) {
        if (this.lastRule == null || !this.lastRule.equals(elementRule.name)) {
            this.node = new DefaultMutableTreeNode();
            this.node.setUserObject(elementRule.name);
            this.root.add(this.node);
            this.lastRule = elementRule.name;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.setUserObject(new UsageMatch(elementRule, aTEToken));
        this.node.add(defaultMutableTreeNode);
        this.model.reload();
    }

    public void selectMatch(UsageMatch usageMatch) {
        this.editor.selectTextRange(usageMatch.token.getStartIndex(), usageMatch.token.getEndIndex());
    }

    public String getTabName() {
        return "Usages of \"" + this.token.getAttribute() + "\"";
    }

    public Component getTabComponent() {
        return this.getContainer();
    }

    public static class UsageMatch {
        public ElementRule rule;
        public ATEToken token;
        public String contextualText;

        public UsageMatch(ElementRule elementRule, ATEToken aTEToken) {
            this.rule = elementRule;
            this.token = aTEToken;
            this.createContextString();
        }

        public void createContextString() {
            int n;
            String string = this.token.getText();
            for (n = this.token.getStartIndex(); n > 0 && string.charAt(n) != '\n' && string.charAt(n) != '\r'; --n) {
            }
            int n2 = this.token.getEndIndex();
            while (n < string.length() && string.charAt(n2) != '\n' && string.charAt(n2) != '\r') {
                ++n2;
            }
            this.contextualText = string.substring(n, n2);
        }

        public String toString() {
            return this.token.getAttribute() + " @ (" + this.token.startLineNumber + ", " + (this.token.getStartIndex() - this.token.getStartLineIndex()) + ") " + this.contextualText + "        ";
        }
    }
}

