/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.find;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.antlr.works.IDE;
import org.antlr.works.find.FindAndReplace;
import org.antlr.xjlib.appkit.frame.XJPanel;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class FindAndReplaceDialog
extends XJPanel {
    private FindAndReplace delegate;
    private JLabel label1;
    private JTextField findField;
    private JLabel label2;
    private JTextField replaceField;
    private JCheckBox ignoreCaseButton;
    private JCheckBox regexButton;
    private JComboBox optionsCombo;
    private JButton replaceAllButton;
    private JButton replaceButton;
    private JButton replaceAndFindButton;
    private JButton previousButton;
    private JButton nextButton;

    public FindAndReplaceDialog(FindAndReplace findAndReplace) {
        this.delegate = findAndReplace;
        this.initComponents();
        this.setSize(570, 180);
        this.setTitle("Find");
        this.awake();
        this.center();
        this.getRootPane().setDefaultButton(this.nextButton);
        this.addEscapeHandling();
        this.createActions();
        this.ignoreCaseButton.setSelected(true);
        findAndReplace.setIgnoreCase(true);
    }

    public void setFindText(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.findField.setText(string);
    }

    public void addEscapeHandling() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.setVisible(false);
            }
        };
        this.getRootPane().registerKeyboardAction(abstractAction, "CancelAction", keyStroke, 2);
    }

    public void createActions() {
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.delegate.setFindString(FindAndReplaceDialog.this.findField.getText());
                FindAndReplaceDialog.this.alertEndOfDocument(this, FindAndReplaceDialog.this.delegate.next());
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.delegate.setFindString(FindAndReplaceDialog.this.findField.getText());
                FindAndReplaceDialog.this.alertBeginningOfDocument(this, FindAndReplaceDialog.this.delegate.prev());
            }
        });
        this.replaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.delegate.setReplaceString(FindAndReplaceDialog.this.replaceField.getText());
                FindAndReplaceDialog.this.delegate.replace();
            }
        });
        this.replaceAndFindButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.delegate.setFindString(FindAndReplaceDialog.this.findField.getText());
                FindAndReplaceDialog.this.delegate.setReplaceString(FindAndReplaceDialog.this.replaceField.getText());
                FindAndReplaceDialog.this.delegate.replace();
                FindAndReplaceDialog.this.alertEndOfDocument(this, FindAndReplaceDialog.this.delegate.next());
            }
        });
        this.replaceAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.delegate.setFindString(FindAndReplaceDialog.this.findField.getText());
                FindAndReplaceDialog.this.delegate.setReplaceString(FindAndReplaceDialog.this.replaceField.getText());
                FindAndReplaceDialog.this.delegate.replaceAll();
            }
        });
        this.ignoreCaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.delegate.setIgnoreCase(FindAndReplaceDialog.this.ignoreCaseButton.isSelected());
            }
        });
        this.regexButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.delegate.setRegex(FindAndReplaceDialog.this.regexButton.isSelected());
            }
        });
        this.optionsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.this.delegate.setOptions(FindAndReplaceDialog.this.optionsCombo.getSelectedIndex());
            }
        });
    }

    private void alertEndOfDocument(ActionListener actionListener, boolean bl) {
        if (bl) {
            return;
        }
        if (XJAlert.displayAlert(this.getJavaContainer(), "End of Document", "The end of the document has been reached.", "Continue", "OK", 0, 1) == 0) {
            this.delegate.setPositionToTop();
            actionListener.actionPerformed(null);
        }
    }

    private void alertBeginningOfDocument(ActionListener actionListener, boolean bl) {
        if (bl) {
            return;
        }
        if (XJAlert.displayAlert(this.getJavaContainer(), "Beginning of Document", "The beginning of the document has been reached.", "Continue", "OK", 0, 1) == 0) {
            this.delegate.setPositionToBottom();
            actionListener.actionPerformed(null);
        }
    }

    public boolean shouldDisplayMainMenuBar() {
        return super.shouldDisplayMainMenuBar() && !IDE.isPlugin();
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.findField = new JTextField();
        this.label2 = new JLabel();
        this.replaceField = new JTextField();
        this.ignoreCaseButton = new JCheckBox();
        this.regexButton = new JCheckBox();
        this.optionsCombo = new JComboBox();
        this.replaceAllButton = new JButton();
        this.replaceButton = new JButton();
        this.replaceAndFindButton = new JButton();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.DLUX5), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.DLUX5)}, new RowSpec[]{new RowSpec(Sizes.DLUY5), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.DLUY5)}));
        this.label1.setText("Find:");
        container.add((Component)this.label1, cellConstraints.xy(3, 3));
        container.add((Component)this.findField, cellConstraints.xywh(5, 3, 9, 1));
        this.label2.setText("Replace by:");
        container.add((Component)this.label2, cellConstraints.xy(3, 5));
        container.add((Component)this.replaceField, cellConstraints.xywh(5, 5, 9, 1));
        this.ignoreCaseButton.setText("Ignore case");
        container.add((Component)this.ignoreCaseButton, cellConstraints.xy(5, 7));
        this.regexButton.setText("Regular expression");
        container.add((Component)this.regexButton, cellConstraints.xy(7, 7));
        this.optionsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Contains", "Starts with", "Whole words", "Ends with"}));
        container.add((Component)this.optionsCombo, cellConstraints.xywh(11, 7, 3, 1));
        this.replaceAllButton.setText("Replace All");
        container.add((Component)this.replaceAllButton, cellConstraints.xy(3, 11));
        this.replaceButton.setText("Replace");
        container.add((Component)this.replaceButton, cellConstraints.xy(5, 11));
        this.replaceAndFindButton.setText("Replace & Find");
        container.add((Component)this.replaceAndFindButton, cellConstraints.xy(7, 11));
        this.previousButton.setText("Previous");
        container.add((Component)this.previousButton, cellConstraints.xy(11, 11));
        this.nextButton.setText("Next");
        container.add((Component)this.nextButton, cellConstraints.xy(13, 11));
        this.pack();
    }
}

