/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.find;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.find.FindAndReplaceDialog;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.frame.XJFrameDelegate;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class FindAndReplace
implements XJFrameDelegate {
    public static final String BEGIN_QUOTE = "\\Q";
    public static final String END_QUOTE = "\\E";
    public CEditorGrammar editor;
    public String findString;
    public String replaceString;
    public int flags;
    public String prefix = "";
    public String suffix = "";
    public String prefixRegex = "\\Q";
    public String suffixRegex = "\\E";
    public FindAndReplaceDialog dialog;

    public FindAndReplace(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void close() {
        this.editor = null;
    }

    public void find() {
        this.display();
    }

    public String getCompilableString() {
        return this.prefix + this.prefixRegex + this.findString + this.suffixRegex + this.suffix;
    }

    public Pattern getCompiledPattern() {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(this.getCompilableString(), this.flags);
        }
        catch (Exception exception) {
            XJAlert.display(this.dialog.getJavaContainer(), "Regex Find", "Pattern error:\n" + exception.toString());
        }
        return pattern;
    }

    public void setPositionToTop() {
        this.editor.getTextPane().setSelectionStart(0);
        this.editor.getTextPane().setSelectionEnd(0);
    }

    public void setPositionToBottom() {
        this.editor.getTextPane().setSelectionStart(this.editor.getText().length() - 1);
        this.editor.getTextPane().setSelectionEnd(this.editor.getText().length() - 1);
    }

    public boolean matching() {
        Pattern pattern = this.getCompiledPattern();
        if (pattern == null) {
            return false;
        }
        String string = this.editor.getText();
        Matcher matcher = pattern.matcher(string);
        if (matcher.find(0)) {
            this.editor.selectTextRange(matcher.start(), matcher.end());
            return true;
        }
        return false;
    }

    public boolean next() {
        if (this.findString == null || this.findString.length() == 0) {
            return false;
        }
        int n = this.editor.getTextPane().getSelectionEnd();
        String string = this.editor.getText();
        Pattern pattern = this.getCompiledPattern();
        if (pattern == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(string);
        if (matcher.find(n)) {
            this.editor.selectTextRange(matcher.start(), matcher.end());
            return true;
        }
        return false;
    }

    public boolean prev() {
        if (this.findString == null || this.findString.length() == 0) {
            return false;
        }
        int n = this.editor.getTextPane().getSelectionStart();
        String string = this.editor.getText();
        Pattern pattern = this.getCompiledPattern();
        if (pattern == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(string.substring(0, n));
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (matcher.find(n3)) {
            n2 = matcher.start();
            n3 = matcher.end();
            bl = true;
        }
        if (bl) {
            this.editor.selectTextRange(n2, n3);
            return true;
        }
        return false;
    }

    public void replace() {
        String string = this.editor.textEditor.getSelectedText();
        if (string != null && string.length() > 0) {
            this.editor.textEditor.replaceSelectedText(this.replaceString);
        }
    }

    public void replaceAll() {
        Pattern pattern = this.getCompiledPattern();
        if (pattern == null) {
            return;
        }
        Matcher matcher = pattern.matcher(this.editor.getText());
        String string = matcher.replaceAll(this.replaceString);
        int n = this.editor.getCaretPosition();
        this.editor.setText(string);
        this.editor.getTextEditor().setCaretPosition(n, false, false);
    }

    public void display() {
        if (this.dialog == null) {
            this.dialog = new FindAndReplaceDialog(this);
        }
        this.dialog.setDelegate(this);
        this.dialog.setFindText(this.editor.textEditor.getSelectedText());
        this.dialog.show();
    }

    public void setFindString(String string) {
        this.findString = string;
    }

    public void setReplaceString(String string) {
        this.replaceString = string;
    }

    public void setIgnoreCase(boolean bl) {
        this.flags = bl ? 2 : 0;
    }

    public void setRegex(boolean bl) {
        if (bl) {
            this.prefixRegex = "";
            this.suffixRegex = "";
        } else {
            this.prefixRegex = BEGIN_QUOTE;
            this.suffixRegex = END_QUOTE;
        }
    }

    public void setOptions(int n) {
        this.prefix = "";
        this.suffix = "";
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.prefix = "\\b";
                break;
            }
            case 2: {
                this.prefix = "\\b";
                this.suffix = "\\b";
                break;
            }
            case 3: {
                this.suffix = "\\b";
            }
        }
    }

    public void frameDidClose(XJFrame xJFrame) {
        this.dialog = null;
    }
}

