/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.engine;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.antlr.works.IDE;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.Console;
import org.antlr.works.utils.StreamWatcher;
import org.antlr.works.utils.StreamWatcherDelegate;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;

public class EngineRuntime {
    public static Map<Thread, Process> processPerThread = new HashMap<Thread, Process>();

    public static void setProcess(Process process) {
        processPerThread.put(Thread.currentThread(), process);
    }

    public static void removeProcess() {
        processPerThread.remove(Thread.currentThread());
    }

    public static Process getProcess(Thread thread) {
        return processPerThread.get(thread);
    }

    public static Process getProcess() {
        return processPerThread.get(Thread.currentThread());
    }

    public static String getClassPath(String string) {
        String string2;
        File file;
        String string3 = IDE.getApplicationPath();
        String string4 = System.getProperty("org.antlr.works.debug.plugin");
        if (string4 != null && Boolean.parseBoolean(string4) && (file = new File(string2 = XJUtils.getPathByDeletingLastComponent(string3) + File.separatorChar + "lib")).isDirectory()) {
            for (File file2 : file.listFiles()) {
                String string5 = file2.getAbsolutePath();
                if (!string5.endsWith(".jar")) continue;
                string3 = string3 + File.pathSeparatorChar + string5;
            }
        }
        string2 = string;
        if (string3 != null) {
            string2 = string2 + File.pathSeparatorChar + Utils.unquotePath(string3);
        }
        if (AWPrefs.getUseSystemClassPath()) {
            string2 = string2 + File.pathSeparatorChar + Utils.unquotePath(System.getProperty("java.class.path"));
        }
        if (AWPrefs.getUseCustomClassPath()) {
            string2 = string2 + File.pathSeparatorChar + Utils.unquotePath(AWPrefs.getCustomClassPath());
        }
        string2 = string2 + File.pathSeparatorChar + ".";
        if (XJSystem.isWindows()) {
            return Utils.quotePath(string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runANTLR(Console console, String string, String string2, String string3, StreamWatcherDelegate streamWatcherDelegate) {
        String string4 = null;
        StreamWatcher streamWatcher = null;
        int n = 0;
        try {
            String[] stringArray = new String[]{"java", "-cp", EngineRuntime.getClassPath(string3), "org.antlr.Tool", "-o", Utils.quotePath(string3), "-lib", Utils.quotePath(string2), string};
            IDE.debugVerbose(console, EngineRuntime.class, "Run ANTLR: " + Utils.toString(stringArray));
            Process object = Runtime.getRuntime().exec(stringArray);
            EngineRuntime.setProcess(object);
            streamWatcher = new StreamWatcher(object.getErrorStream(), "ANTLR[error]", streamWatcherDelegate);
            streamWatcher.start();
            new StreamWatcher(object.getInputStream(), "ANTLR[stdout]", streamWatcherDelegate).start();
            n = object.waitFor();
        }
        catch (Exception exception) {
            string4 = "Failed to run ANTLR with exception:\n" + exception.toString();
        }
        finally {
            EngineRuntime.removeProcess();
        }
        if (n != 0) {
            string4 = "Failed to run ANTLR with result:\n" + n;
        }
        if (string4 == null && streamWatcher != null) {
            for (String string5 : streamWatcher.getLines()) {
                if (string5.startsWith("ANTLR Parser Generator") || string5.startsWith("no such locale file")) continue;
                string4 = string5;
                break;
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runJava(Console console, String string, String[] stringArray, StreamWatcherDelegate streamWatcherDelegate) {
        String string2 = null;
        int n = 0;
        try {
            String[] stringArray2 = new String[3 + stringArray.length];
            stringArray2[0] = "java";
            stringArray2[1] = "-cp";
            stringArray2[2] = EngineRuntime.getClassPath(string);
            System.arraycopy(stringArray, 0, stringArray2, 3, stringArray.length);
            IDE.debugVerbose(console, EngineRuntime.class, "Run Java: " + Utils.toString(stringArray2));
            Process process = Runtime.getRuntime().exec(stringArray2, null, new File(string));
            EngineRuntime.setProcess(process);
            new StreamWatcher(process.getErrorStream(), "Java[error]", streamWatcherDelegate).start();
            new StreamWatcher(process.getInputStream(), "Java[stdout]", streamWatcherDelegate).start();
            n = process.waitFor();
        }
        catch (Exception exception) {
            string2 = "Failed to run Java with exception:\n" + exception.toString();
        }
        finally {
            EngineRuntime.removeProcess();
        }
        if (n != 0) {
            string2 = "Failed to run Java with result:\n" + n;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compileFiles(Console console, String[] stringArray, String string, StreamWatcherDelegate streamWatcherDelegate) {
        String string2 = null;
        int n = 0;
        try {
            String string3 = AWPrefs.getCompiler();
            String string4 = EngineRuntime.getClassPath(string);
            if (string3.equalsIgnoreCase("javac")) {
                String[] stringArray2 = new String[5 + stringArray.length];
                stringArray2[0] = AWPrefs.getJavaCCustomPath() ? XJUtils.concatPath(AWPrefs.getJavaCPath(), "javac") : "javac";
                stringArray2[1] = "-classpath";
                stringArray2[2] = string4;
                stringArray2[3] = "-d";
                stringArray2[4] = Utils.quotePath(string);
                System.arraycopy(stringArray, 0, stringArray2, 5, stringArray.length);
                IDE.debugVerbose(console, EngineRuntime.class, "Compile: " + Utils.toString(stringArray2));
                Process process = Runtime.getRuntime().exec(stringArray2);
                EngineRuntime.setProcess(process);
                new StreamWatcher(process.getErrorStream(), "Compiler[error]", streamWatcherDelegate).start();
                new StreamWatcher(process.getInputStream(), "Compiler[stdout]", streamWatcherDelegate).start();
                n = process.waitFor();
            } else if (string3.equalsIgnoreCase("jikes")) {
                String string5 = XJUtils.concatPath(AWPrefs.getJikesPath(), "jikes");
                String[] stringArray3 = new String[5 + stringArray.length];
                stringArray3[0] = string5;
                stringArray3[1] = "-classpath";
                stringArray3[2] = string4;
                stringArray3[3] = "-d";
                stringArray3[4] = Utils.quotePath(string);
                System.arraycopy(stringArray, 0, stringArray3, 5, stringArray.length);
                IDE.debugVerbose(console, EngineRuntime.class, "Compile: " + Utils.toString(stringArray3));
                Process process = Runtime.getRuntime().exec(stringArray3);
                EngineRuntime.setProcess(process);
                new StreamWatcher(process.getErrorStream(), "Compiler[error]", streamWatcherDelegate).start();
                new StreamWatcher(process.getInputStream(), "Compiler[stdout]", streamWatcherDelegate).start();
                n = process.waitFor();
            } else if (string3.equalsIgnoreCase("integrated")) {
                String[] stringArray4 = new String[2 + stringArray.length];
                stringArray4[0] = "-d";
                stringArray4[1] = string;
                System.arraycopy(stringArray, 0, stringArray4, 2, stringArray.length);
                Class<?> clazz = Class.forName("com.sun.tools.javac.Main");
                Class[] classArray = new Class[]{String[].class};
                Method method = clazz.getMethod("compile", classArray);
                Object[] objectArray = new Object[]{stringArray4};
                Object object = method.invoke(clazz.newInstance(), objectArray);
                n = (Integer)object;
            }
        }
        catch (Error error) {
            string2 = "Compiler error:\n" + error.toString();
            error.printStackTrace();
        }
        catch (Exception exception) {
            string2 = "Compiler exception:\n" + exception.toString();
            exception.printStackTrace();
        }
        finally {
            EngineRuntime.removeProcess();
        }
        if (n != 0) {
            string2 = "Compiler failed with result code " + n;
        }
        return string2;
    }
}

