/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.swing.Toolbar;
import org.antlr.works.utils.IconManager;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class EditorToolbar
implements XJNotificationObserver {
    public Toolbar toolbar;
    public JButton debug;
    public JButton debugAgain;
    public JButton backward;
    public JButton forward;
    public JToggleButton sort;
    public JToggleButton sd;
    public JToggleButton coloring;
    public JToggleButton ideas;
    public JButton find;
    public CEditorGrammar editor;

    public EditorToolbar(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
        this.createInterface();
        this.addActions();
        this.debugAgain.setEnabled(false);
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STARTED");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STOPPED");
    }

    public void close() {
        this.editor = null;
        AWPrefs.getPreferences().unbindFromPreferences(this.sort, "PREF_TOOLBAR_SORT");
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public JComponent getToolbar() {
        return this.toolbar;
    }

    public void notificationFire(Object object, String string) {
        if (string.equals("NOTIF_DEBUG_STARTED")) {
            this.find.setEnabled(false);
            this.debug.setEnabled(false);
            this.debugAgain.setEnabled(false);
        } else if (string.equals("NOTIF_DEBUG_STOPPED")) {
            this.find.setEnabled(true);
            this.debug.setEnabled(true);
            this.debugAgain.setEnabled(this.editor.debugger.canDebugAgain());
        }
    }

    public void createInterface() {
        this.toolbar = Toolbar.createHorizontalToolbar();
        this.sd = (JToggleButton)this.createNewButton(IconManager.shared().getIconSyntaxDiagram(), "Toggle Syntax diagram", true);
        this.toolbar.addElement(this.sd);
        this.coloring = (JToggleButton)this.createNewButton(IconManager.shared().getIconColoring(), "Toggle Syntax coloring", true);
        this.toolbar.addElement(this.coloring);
        this.ideas = (JToggleButton)this.createNewButton(IconManager.shared().getIconIdea(), "Toggle Syntax ideas", true);
        this.toolbar.addElement(this.ideas);
        this.toolbar.addGroupSeparator();
        this.sort = (JToggleButton)this.createNewButton(IconManager.shared().getIconSort(), "Toggle Sort rules", true);
        this.toolbar.addElement(this.sort);
        this.find = (JButton)this.createNewButton(IconManager.shared().getIconFind(), "Find text", false);
        this.toolbar.addElement(this.find);
        this.toolbar.addGroupSeparator();
        this.backward = (JButton)this.createNewButton(IconManager.shared().getIconBackward(), "Back", false);
        this.toolbar.addElement(this.backward);
        this.forward = (JButton)this.createNewButton(IconManager.shared().getIconForward(), "Forward", false);
        this.toolbar.addElement(this.forward);
        this.toolbar.addGroupSeparator();
        this.debug = (JButton)this.createNewButton(IconManager.shared().getIconDebug(), "Debug", false);
        this.toolbar.addElement(this.debug);
        this.debugAgain = (JButton)this.createNewButton(IconManager.shared().getIconDebugAgain(), "Debug Again", false);
        this.toolbar.addElement(this.debugAgain);
        AWPrefs.getPreferences().bindToPreferences(this.sort, "PREF_TOOLBAR_SORT", false);
    }

    public void awake() {
        this.editor.rules.setSorted(AWPrefs.getPreferences().getBoolean("PREF_TOOLBAR_SORT", false));
        this.sd.setSelected(true);
        this.coloring.setSelected(true);
        this.ideas.setSelected(true);
    }

    public void addActions() {
        this.backward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.menuGoTo.goToBackward();
            }
        });
        this.forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.menuGoTo.goToForward();
            }
        });
        this.sort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.toggleRulesSorting();
            }
        });
        this.sd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.toggleSyntaxDiagram();
            }
        });
        this.coloring.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.toggleSyntaxColoring();
            }
        });
        this.ideas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.toggleIdeas();
            }
        });
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.menuFind.find();
            }
        });
        this.debug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.menuDebugger.debug();
            }
        });
        this.debugAgain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorToolbar.this.editor.menuDebugger.debugAgain();
            }
        });
    }

    public AbstractButton createNewButton(ImageIcon imageIcon, String string, boolean bl) {
        AbstractButton abstractButton = bl ? new JToggleButton(imageIcon) : new JButton(imageIcon);
        abstractButton.setToolTipText(string);
        Dimension dimension = new Dimension(32, 32);
        abstractButton.setMinimumSize(dimension);
        abstractButton.setMaximumSize(dimension);
        abstractButton.setPreferredSize(dimension);
        abstractButton.setFocusable(false);
        return abstractButton;
    }
}

