/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorInspectorItem;
import org.antlr.works.tips.TipsManager;
import org.antlr.works.tips.TipsOverlay;
import org.antlr.works.tips.TipsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorTips
implements TipsProvider {
    public TipsManager tipsManager;
    public CEditorGrammar editor;

    public EditorTips(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void awake() {
        this.tipsManager = new TipsManager();
        this.tipsManager.setOverlay(new TipsOverlay(this.editor.getXJFrame(), this.editor.getTextPane()));
        this.tipsManager.addProvider(this);
    }

    public void toggleEnabled() {
        this.tipsManager.setEnabled(!this.tipsManager.enabled());
    }

    public void hide() {
        this.tipsManager.hide();
    }

    public void close() {
        this.editor = null;
        this.tipsManager.close();
    }

    public void display(Point point, Point point2) {
        if (this.editor.getTokens() == null) {
            return;
        }
        int n = this.editor.getTextPane().viewToModel(point);
        Point point3 = null;
        try {
            Rectangle rectangle;
            Rectangle rectangle2;
            ATEToken aTEToken = this.editor.getTokenAtPosition(n, false);
            if (aTEToken != null && (rectangle2 = this.editor.getTextPane().modelToView(aTEToken.getStartIndex())).union(rectangle = this.editor.getTextPane().modelToView(aTEToken.getEndIndex())).contains(point)) {
                point3 = SwingUtilities.convertPoint(this.editor.getTextPane(), new Point(point.x + 2, rectangle.y - 5), this.editor.getXJFrame().getJavaContainer());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.tipsManager.displayAnyTipsAvailable(n, point3);
    }

    @Override
    public List<String> tipsProviderGetTips(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<EditorInspectorItem> list = this.editor.editorInspector.getAllItemsAtIndex(n);
        for (EditorInspectorItem editorInspectorItem : list) {
            arrayList.add(editorInspectorItem.description);
        }
        return arrayList;
    }
}

