/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.antlr.works.ate.swing.ATEKeyBindings;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.syntax.GrammarSyntaxEngine;
import org.antlr.works.syntax.element.ElementAction;
import org.antlr.works.syntax.element.ElementGroup;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.IconManager;
import org.antlr.xjlib.appkit.swing.XJTree;
import org.antlr.xjlib.appkit.swing.XJTreeDelegate;
import org.antlr.xjlib.foundation.XJSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorRules
implements XJTreeDelegate {
    protected CEditorGrammar editor;
    protected boolean programmaticallySelectingRule = false;
    protected boolean selectNextRule = false;
    protected XJTree rulesTree;
    protected DefaultMutableTreeNode rulesTreeRootNode;
    protected DefaultTreeModel rulesTreeModel;
    protected List<String> rulesTreeExpandedNodes;
    protected RuleTreeUserObject selectedObject;
    protected boolean sort;
    private TreeSelectionListener tsl;
    private MouseListener ml;
    public static final Color HIGHLIGHTED_COLOR = new Color(0.0f, 0.5f, 1.0f, 0.4f);

    public EditorRules(CEditorGrammar cEditorGrammar, XJTree xJTree) {
        this.editor = cEditorGrammar;
        this.rulesTree = xJTree;
        xJTree.setDelegate(this);
        xJTree.setEnableDragAndDrop();
        this.rulesTreeRootNode = new DefaultMutableTreeNode(new RuleTreeUserObject((ElementRule)null));
        this.rulesTreeModel = new DefaultTreeModel(this.rulesTreeRootNode);
        this.rulesTreeExpandedNodes = new ArrayList<String>();
        xJTree.setModel(this.rulesTreeModel);
        this.ml = new RuleTreeMouseListener();
        xJTree.addMouseListener(this.ml);
        this.tsl = new RuleTreeSelectionListener();
        xJTree.addTreeSelectionListener(this.tsl);
        xJTree.setRootVisible(false);
        xJTree.setShowsRootHandles(true);
        xJTree.setCellRenderer(new RulesTableRenderer());
        xJTree.setRowHeight(17);
        xJTree.getSelectionModel().setSelectionMode(4);
    }

    public void close() {
        this.editor = null;
        this.rulesTree.removeMouseListener(this.ml);
        this.rulesTree.removeTreeSelectionListener(this.tsl);
        this.rulesTree.setCellRenderer(null);
        this.rulesTree.setDelegate(null);
        this.rulesTree = null;
    }

    public void setKeyBindings(ATEKeyBindings aTEKeyBindings) {
        aTEKeyBindings.addKeyBinding("RULE_MOVE_UP", KeyStroke.getKeyStroke(38, 2), new RuleMoveUpAction());
        aTEKeyBindings.addKeyBinding("RULE_MOVE_DOWN", KeyStroke.getKeyStroke(40, 2), new RuleMoveDownAction());
    }

    public GrammarSyntaxEngine getParserEngine() {
        return this.editor.getParserEngine();
    }

    public boolean isSorted() {
        return this.sort;
    }

    public void setSorted(boolean bl) {
        this.sort = bl;
    }

    public void toggleSorting() {
        this.sort = !this.sort;
        this.rebuildTree();
    }

    public void ignoreSelectedRules(boolean bl) {
        for (ElementRule elementRule : this.getSelectedRules()) {
            elementRule.ignored = bl;
        }
        this.rulesTree.repaint();
        this.editor.rulesDidChange();
    }

    public void findTokensToIgnore(boolean bl) {
        List<ElementRule> list = this.getRules();
        if (list == null || list.isEmpty()) {
            return;
        }
        EditorRules.findTokensToIgnore(list, bl);
        this.rulesTree.repaint();
    }

    public static void findTokensToIgnore(List<ElementRule> list, boolean bl) {
        for (ElementRule elementRule : list) {
            List<ElementAction> list2;
            if (bl) {
                elementRule.ignored = false;
            }
            if ((list2 = elementRule.getActions()) == null || list2.isEmpty()) continue;
            block1: for (ElementAction elementAction : list2) {
                List<ATEToken> list3 = elementAction.getTokens();
                for (int i = 0; i < list3.size(); ++i) {
                    ATEToken aTEToken = list3.get(i);
                    if ((aTEToken.type == 5 || aTEToken.type == 100) && aTEToken.getAttribute().equals("channel") && i + 3 < list3.size()) {
                        ATEToken aTEToken2 = list3.get(i + 1);
                        ATEToken aTEToken3 = list3.get(i + 2);
                        if (aTEToken2.type != 6 || !aTEToken2.getAttribute().equals("=") || aTEToken3.type != 5 || !aTEToken3.getAttribute().equals("HIDDEN")) continue;
                        elementRule.ignored = true;
                        continue block1;
                    }
                    if (aTEToken.type != 5 || !aTEToken.getAttribute().equals("skip") || list3.size() != 5 || i != 1) continue;
                    elementRule.ignored = true;
                    continue block1;
                }
            }
        }
    }

    public boolean getFirstSelectedRuleIgnoredFlag() {
        List<ElementRule> list = this.getSelectedRules();
        if (list == null || list.isEmpty()) {
            return false;
        }
        return list.get((int)0).ignored;
    }

    public void refreshRules() {
        this.saveExpandedNodes();
        this.rulesTreeModel.reload();
        this.restoreExpandedNodes();
        this.selectRuleInTreeAtPosition(this.editor.getCaretPosition());
    }

    public ElementGroup getSelectedGroup() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.rulesTree.getSelectionPath().getLastPathComponent();
        RuleTreeUserObject ruleTreeUserObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
        if (ruleTreeUserObject.group != null) {
            return ruleTreeUserObject.group;
        }
        return null;
    }

    public ElementGroup findOpenGroupClosestToLocation(int n) {
        List<ElementGroup> list = this.getParserEngine().getGroups();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ElementGroup elementGroup = null;
        for (ElementGroup elementGroup2 : list) {
            if (!elementGroup2.openGroup) continue;
            ATEToken aTEToken = elementGroup2.token;
            if (aTEToken.getStartIndex() > n) break;
            elementGroup = elementGroup2;
        }
        return elementGroup;
    }

    public ElementGroup findClosingGroupForGroup(ElementGroup elementGroup) {
        List<ElementGroup> list = this.getParserEngine().getGroups();
        if (list == null || list.isEmpty()) {
            return null;
        }
        int n = list.indexOf(elementGroup) + 1;
        if (n == -1) {
            return null;
        }
        int n2 = 0;
        while (n < list.size()) {
            ElementGroup elementGroup2 = list.get(n);
            if (elementGroup2.openGroup) {
                ++n2;
            } else {
                if (n2 == 0) {
                    return elementGroup2;
                }
                --n2;
            }
            ++n;
        }
        return null;
    }

    public List<ElementRule> getRules() {
        return this.getParserEngine().getRules();
    }

    public List<ElementRule> getSortedRules() {
        return this.getSortedRules(this.getRules());
    }

    public List<ElementRule> getSortedRules(List<ElementRule> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ElementRule> arrayList = new ArrayList<ElementRule>(list);
        Collections.sort(arrayList);
        if (!arrayList.isEmpty()) {
            ElementRule elementRule = (ElementRule)arrayList.get(0);
            if (elementRule.lexer) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ElementRule elementRule2 = (ElementRule)arrayList.get(0);
                    if (!elementRule2.lexer) break;
                    arrayList.add(elementRule2);
                    arrayList.remove(0);
                }
            }
        }
        return arrayList;
    }

    public List<ElementRule> getSelectedRules() {
        ArrayList<ElementRule> arrayList = new ArrayList<ElementRule>();
        for (Object object : this.rulesTree.getSelectedNodes()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            RuleTreeUserObject ruleTreeUserObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
            if (ruleTreeUserObject.rule == null) continue;
            arrayList.add(ruleTreeUserObject.rule);
        }
        return arrayList;
    }

    public ElementRule getLastRule() {
        List<ElementRule> list = this.getParserEngine().getRules();
        if (list != null && !list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public ElementRule getLastParserRule() {
        List<ElementRule> list = this.getParserEngine().getRules();
        for (int i = list.size() - 1; i > 0; --i) {
            ElementRule elementRule = list.get(i);
            if (elementRule.lexer) continue;
            return elementRule;
        }
        return null;
    }

    public ElementRule getLastLexerRule() {
        List<ElementRule> list = this.getParserEngine().getRules();
        for (int i = list.size() - 1; i > 0; --i) {
            ElementRule elementRule = list.get(i);
            if (!elementRule.lexer) continue;
            return elementRule;
        }
        return null;
    }

    public ElementRule getRuleWithName(String string) {
        List<ElementRule> list = this.getParserEngine().getRules();
        for (ElementRule elementRule : list) {
            if (!elementRule.name.equals(string)) continue;
            return elementRule;
        }
        return null;
    }

    public List<String> getRulesStartingWith(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getParserEngine().getRules() == null) {
            return arrayList;
        }
        List<ElementRule> list = this.getParserEngine().getRules();
        for (ElementRule elementRule : list) {
            String string2 = elementRule.name.toLowerCase();
            if (!string2.startsWith(string) || arrayList.contains(elementRule.name)) continue;
            arrayList.add(elementRule.name);
        }
        return arrayList;
    }

    public List<ElementReference> getReferencesInRule(ElementRule elementRule) {
        if (this.getParserEngine().getRules() == null) {
            return null;
        }
        ArrayList<ElementReference> arrayList = new ArrayList<ElementReference>();
        for (ElementReference elementReference : this.getParserEngine().getReferences()) {
            if (elementReference.rule != elementRule) continue;
            arrayList.add(elementReference);
        }
        return arrayList;
    }

    public ElementRule getEnclosingRuleAtPosition(int n) {
        if (this.getParserEngine().getRules() == null) {
            return null;
        }
        for (ElementRule elementRule : this.getParserEngine().getRules()) {
            if (!elementRule.containsIndex(n)) continue;
            return elementRule;
        }
        return null;
    }

    public ElementRule selectRuleInTreeAtPosition(int n) {
        if (this.programmaticallySelectingRule || this.getParserEngine().getRules() == null) {
            return null;
        }
        this.programmaticallySelectingRule = true;
        ElementRule elementRule = this.getEnclosingRuleAtPosition(n);
        this.selectRuleInTree(elementRule);
        this.programmaticallySelectingRule = false;
        return elementRule;
    }

    public ElementRule selectRuleNameInTree(String string) {
        if (this.programmaticallySelectingRule || this.getParserEngine().getRules() == null) {
            return null;
        }
        ElementRule elementRule = null;
        this.programmaticallySelectingRule = true;
        for (ElementRule elementRule2 : this.getParserEngine().getRules()) {
            if (!elementRule2.name.equals(string)) continue;
            this.selectRuleInTree(elementRule2);
            elementRule = elementRule2;
            break;
        }
        this.programmaticallySelectingRule = false;
        return elementRule;
    }

    public ElementRule getRuleAtIndex(int n) {
        if (this.getParserEngine().getRules() == null) {
            return null;
        }
        for (ElementRule elementRule : this.getParserEngine().getRules()) {
            if (n < elementRule.getStartIndex() || n > elementRule.getEndIndex()) continue;
            return elementRule;
        }
        return null;
    }

    public boolean isRuleAtIndex(int n) {
        return this.getRuleAtIndex(n) != null;
    }

    public void selectNextRule() {
        ElementRule elementRule = this.getEnclosingRuleAtPosition(this.editor.getCaretPosition());
        int n = this.getParserEngine().getRules().indexOf(elementRule) + 1;
        elementRule = this.getParserEngine().getRuleAtIndex(n);
        if (elementRule != null) {
            this.editor.setCaretPosition(elementRule.getStartIndex());
            this.editor.rulesCaretPositionDidChange();
        }
    }

    public void selectRuleInTree(ElementRule elementRule) {
        if (elementRule == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = this.rulesTreeRootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            RuleTreeUserObject ruleTreeUserObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
            if (ruleTreeUserObject == null || ruleTreeUserObject.rule != elementRule) continue;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.rulesTree.setSelectionPath(treePath);
            this.rulesTree.scrollPathToVisible(treePath);
            break;
        }
    }

    public void goToRule(ElementRule elementRule) {
        this.editor.goToHistoryRememberCurrentPosition();
        this.editor.setCaretPosition(elementRule.start.getStartIndex());
    }

    public void rebuildTree() {
        this.saveExpandedNodes();
        this.rememberSelectedTreeItem();
        this.rulesTreeRootNode.removeAllChildren();
        List<ElementRule> list = this.getParserEngine().getRules();
        List<ElementGroup> list2 = this.getParserEngine().getGroups();
        if (list == null || list2 == null) {
            return;
        }
        if (list2.isEmpty()) {
            this.buildTree(this.rulesTreeRootNode, list, 0, list.size() - 1);
        } else {
            Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
            stack.add(this.rulesTreeRootNode);
            int n = 0;
            for (ElementGroup elementGroup : list2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)stack.peek();
                if (elementGroup.ruleIndex >= 0) {
                    this.buildTree(defaultMutableTreeNode, list, n, elementGroup.ruleIndex);
                    n = elementGroup.ruleIndex + 1;
                }
                if (elementGroup.openGroup) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new RuleTreeUserObject(elementGroup));
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    stack.push(defaultMutableTreeNode2);
                    continue;
                }
                if (stack.size() <= 1) continue;
                stack.pop();
            }
            if (n < list.size()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)stack.peek();
                this.buildTree(defaultMutableTreeNode, list, n, list.size() - 1);
            }
        }
        this.rulesTreeModel.reload();
        this.restoreSelectedTreeItem();
        this.restoreExpandedNodes();
    }

    public void rememberSelectedTreeItem() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.rulesTree.getSelectedNode();
        this.selectedObject = null;
        if (defaultMutableTreeNode != null) {
            this.selectedObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
        }
    }

    public void restoreSelectedTreeItem() {
        if (this.selectedObject == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNodeWithRuleName(this.selectedObject.rule.name);
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.programmaticallySelectingRule = true;
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.rulesTree.setSelectionPath(treePath);
        this.rulesTree.scrollPathToVisible(treePath);
        this.programmaticallySelectingRule = false;
    }

    public void saveExpandedNodes() {
        this.rulesTreeExpandedNodes.clear();
        Enumeration<TreeNode> enumeration = this.rulesTreeRootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.isLeaf() || defaultMutableTreeNode.isRoot() || !this.rulesTree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) continue;
            RuleTreeUserObject ruleTreeUserObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
            this.rulesTreeExpandedNodes.add(ruleTreeUserObject.group.name);
        }
    }

    public void restoreExpandedNodes() {
        for (String string : this.rulesTreeExpandedNodes) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.findNodeWithGroupName(string);
            if (defaultMutableTreeNode == null) continue;
            this.rulesTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public DefaultMutableTreeNode findNodeWithGroupName(String string) {
        Enumeration<TreeNode> enumeration = this.rulesTreeRootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            RuleTreeUserObject ruleTreeUserObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
            if (ruleTreeUserObject.group == null || !ruleTreeUserObject.group.name.equalsIgnoreCase(string)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    public DefaultMutableTreeNode findNodeWithRuleName(String string) {
        Enumeration<TreeNode> enumeration = this.rulesTreeRootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            RuleTreeUserObject ruleTreeUserObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
            if (ruleTreeUserObject.rule == null || !ruleTreeUserObject.rule.name.equalsIgnoreCase(string)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    protected void buildTree(DefaultMutableTreeNode defaultMutableTreeNode, List<ElementRule> list, int n, int n2) {
        List<ElementRule> list2 = list.subList(n, n2 + 1);
        if (this.sort && !list2.isEmpty()) {
            list2 = this.getSortedRules(list2);
            Collections.sort(list2);
            ElementRule elementRule = list2.get(0);
            if (elementRule.lexer) {
                for (int i = 0; i < list2.size(); ++i) {
                    ElementRule elementRule2 = list2.get(0);
                    if (!elementRule2.lexer) break;
                    list2.add(elementRule2);
                    list2.remove(0);
                }
            }
        }
        for (ElementRule elementRule : list2) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new RuleTreeUserObject(elementRule)));
        }
    }

    public void parserDidParse() {
        this.rebuildTree();
        if (this.selectNextRule) {
            this.selectNextRule = false;
            this.selectNextRule();
        } else {
            this.selectRuleInTreeAtPosition(this.editor.getCaretPosition());
        }
    }

    public boolean moveRule(ElementRule elementRule, ElementRule elementRule2, boolean bl) {
        if (elementRule == null || elementRule2 == null) {
            return false;
        }
        String string = this.editor.getText().substring(elementRule.getStartIndex(), elementRule.getEndIndex() + 1);
        try {
            Document document = this.editor.getTextPane().getDocument();
            int n = elementRule.getStartIndex();
            int n2 = bl ? elementRule2.getStartIndex() : elementRule2.getEndIndex();
            int n3 = elementRule.getLength() + 1;
            if (n + n3 > document.getLength()) {
                --n3;
            }
            if (elementRule.getStartIndex() > elementRule2.getStartIndex()) {
                document.remove(n, n3);
                document.insertString(n2, "\n" + string, null);
                this.editor.setCaretPosition(n2);
            } else {
                document.insertString(n2, "\n" + string, null);
                document.remove(n, n3);
                this.editor.setCaretPosition(n2 - n3);
            }
            return true;
        }
        catch (BadLocationException badLocationException) {
            this.editor.console.print(badLocationException);
            return false;
        }
    }

    public void selectRuleFromUserAction() {
        if (this.programmaticallySelectingRule) {
            return;
        }
        if (this.rulesTree.getSelectionCount() != 1) {
            return;
        }
        TreePath[] treePathArray = this.rulesTree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        ArrayList<ElementRule> arrayList = new ArrayList<ElementRule>();
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            RuleTreeUserObject ruleTreeUserObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
            if (ruleTreeUserObject.rule == null) continue;
            arrayList.add(ruleTreeUserObject.rule);
        }
        if (!arrayList.isEmpty()) {
            this.goToRule((ElementRule)arrayList.get(0));
            this.rulesTree.requestFocusInWindow();
        }
    }

    @Override
    public Cursor xjTreeDragSourceDefaultCursor(XJTree xJTree) {
        return DragSource.DefaultMoveDrop;
    }

    @Override
    public int xjTreeDragAndDropConstants(XJTree xJTree) {
        return 2;
    }

    @Override
    public boolean xjTreeDrop(XJTree xJTree, Object object, Object object2, int n) {
        StatisticsAW.shared().recordEvent(134);
        ElementRule elementRule = ((RuleTreeUserObject)object).rule;
        ElementRule elementRule2 = ((RuleTreeUserObject)object2).rule;
        return this.moveRule(elementRule, elementRule2, n == 0);
    }

    public static class RuleTreeUserObject
    implements Transferable {
        public ElementRule rule;
        public ElementGroup group;

        public RuleTreeUserObject(ElementRule elementRule) {
            this.rule = elementRule;
        }

        public RuleTreeUserObject(ElementGroup elementGroup) {
            this.group = elementGroup;
        }

        public String toString() {
            if (this.group != null) {
                return this.group.name;
            }
            if (this.rule != null) {
                return this.rule.name;
            }
            return "";
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return null;
        }
    }

    public class RuleTreeMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            EditorRules.this.selectRuleFromUserAction();
            this.checkForPopupTrigger(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkForPopupTrigger(mouseEvent);
        }

        public void checkForPopupTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                EditorRules.this.rulesTree.modifySelectionIfNecessary(mouseEvent);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object object : EditorRules.this.rulesTree.getSelectedNodes()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    arrayList.add(defaultMutableTreeNode.getUserObject());
                }
                JPopupMenu jPopupMenu = EditorRules.this.editor.rulesGetContextualMenu(arrayList);
                if (jPopupMenu != null) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    public class RuleTreeSelectionListener
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            EditorRules.this.selectRuleFromUserAction();
        }
    }

    public static class RulesTableRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (XJSystem.isWindows()) {
                this.setBackgroundSelectionColor(HIGHLIGHTED_COLOR);
            }
            this.setIcon(null);
            this.setToolTipText("");
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            RuleTreeUserObject ruleTreeUserObject = (RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
            if (ruleTreeUserObject.rule != null) {
                if (ruleTreeUserObject.rule.lexer) {
                    this.setIcon(IconManager.shared().getIconLexer());
                } else {
                    this.setIcon(IconManager.shared().getIconParser());
                }
            }
            this.setFont(this.getFont().deriveFont(0));
            this.setForeground(Color.black);
            if (ruleTreeUserObject.rule != null) {
                if (ruleTreeUserObject.rule.hasErrors()) {
                    this.setForeground(Color.red);
                    this.setToolTipText(ruleTreeUserObject.rule.getErrorMessageHTML());
                }
                if (ruleTreeUserObject.rule.ignored) {
                    this.setFont(this.getFont().deriveFont(2));
                }
            }
            return component;
        }
    }

    public class RuleMoveDownAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ElementRule elementRule = EditorRules.this.getEnclosingRuleAtPosition(EditorRules.this.editor.getCaretPosition());
            int n = EditorRules.this.getParserEngine().getRules().indexOf(elementRule) + 1;
            ElementRule elementRule2 = EditorRules.this.getParserEngine().getRuleAtIndex(n);
            if (elementRule2 != null) {
                EditorRules.this.moveRule(elementRule2, elementRule, true);
                EditorRules.this.selectNextRule = true;
            }
        }
    }

    public class RuleMoveUpAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ElementRule elementRule = EditorRules.this.getEnclosingRuleAtPosition(EditorRules.this.editor.getCaretPosition());
            int n = EditorRules.this.getParserEngine().getRules().indexOf(elementRule) - 1;
            if (n >= 0) {
                ElementRule elementRule2 = EditorRules.this.getParserEngine().getRuleAtIndex(n);
                EditorRules.this.moveRule(elementRule, elementRule2, true);
            }
        }
    }
}

