/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorPersistentObject;

public class EditorPersistence {
    private static final String KEY_RULES = "rules";
    private static final String KEY_ACTIONS = "actions";
    private Map<String, Map<Object, EditorPersistentObject>> persistence = new HashMap<String, Map<Object, EditorPersistentObject>>();
    private boolean stored = false;
    private CEditorGrammar editor;

    public EditorPersistence(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void close() {
        this.editor = null;
    }

    public void store() {
        if (this.stored) {
            return;
        }
        this.stored = true;
        this.store(this.editor.parserEngine.getRules(), KEY_RULES);
        this.store(this.editor.parserEngine.getActions(), KEY_ACTIONS);
    }

    public void restore() {
        if (this.stored) {
            this.stored = false;
            this.restore(this.editor.parserEngine.getRules(), KEY_RULES);
            this.restore(this.editor.parserEngine.getActions(), KEY_ACTIONS);
        }
    }

    public void store(List list, String string) {
        Map<Object, EditorPersistentObject> map = this.persistence.get(string);
        if (map == null) {
            map = new HashMap<Object, EditorPersistentObject>();
            this.persistence.put(string, map);
        }
        map.clear();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            EditorPersistentObject editorPersistentObject = (EditorPersistentObject)e;
            map.put(editorPersistentObject.getPersistentID(), editorPersistentObject);
        }
    }

    public void restore(List list, String string) {
        Map<Object, EditorPersistentObject> map = this.persistence.get(string);
        if (map == null) {
            return;
        }
        if (list == null) {
            return;
        }
        for (Object e : list) {
            EditorPersistentObject editorPersistentObject = (EditorPersistentObject)e;
            EditorPersistentObject editorPersistentObject2 = map.get(editorPersistentObject.getPersistentID());
            if (editorPersistentObject2 == null) continue;
            editorPersistentObject.persistentAssign(editorPersistentObject2);
        }
    }
}

