/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.antlr.works.IDE;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;

public class EditorMenu
implements XJMenuItemDelegate {
    public static final int MI_PRINT = 5;
    public static final int MI_TOGGLE_SYNTAX_COLORING = 6;
    public static final int MI_TOGGLE_SYNTAX_DIAGRAM = 7;
    public static final int MI_TOGGLE_NFA_OPTIMIZATION = 9;
    public static final int MI_TOGGLE_AUTOINDENT = 10;
    public static final int MI_EXPAND_COLLAPSE_RULE = 20;
    public static final int MI_EXPAND_COLLAPSE_ACTION = 21;
    public static final int MI_FIND = 30;
    public static final int MI_FIND_NEXT = 31;
    public static final int MI_FIND_PREV = 32;
    public static final int MI_FIND_TOKEN = 33;
    public static final int MI_FIND_USAGE = 34;
    public static final int MI_GOTO_RULE = 40;
    public static final int MI_GOTO_DECLARATION = 41;
    public static final int MI_GOTO_LINE = 42;
    public static final int MI_GOTO_CHARACTER = 43;
    public static final int MI_GOTO_BACK = 44;
    public static final int MI_GOTO_FORWARD = 45;
    public static final int MI_PREV_BREAKPOINT = 46;
    public static final int MI_NEXT_BREAKPOINT = 47;
    public static final int MI_HIGHLIGHT_DECISION_DFA = 50;
    public static final int MI_SHOW_DECISION_DFA = 51;
    public static final int MI_SHOW_DEPENDENCY = 52;
    public static final int MI_SHOW_TOKENS_SD = 53;
    public static final int MI_SHOW_TOKENS_DFA = 54;
    public static final int MI_INSERT_TEMPLATE = 55;
    public static final int MI_GROUP_RULE = 56;
    public static final int MI_UNGROUP_RULE = 57;
    public static final int MI_IGNORE_RULE = 58;
    public static final int MI_CHECK_GRAMMAR = 59;
    public static final int MI_RENAME = 61;
    public static final int MI_REPLACE_LITERAL_WITH_TOKEN_LABEL = 62;
    public static final int MI_LITERAL_TO_SINGLEQUOTE = 63;
    public static final int MI_LITERAL_TO_DOUBLEQUOTE = 64;
    public static final int MI_LITERAL_TO_CSTYLEQUOTE = 65;
    public static final int MI_REMOVE_LEFT_RECURSION = 66;
    public static final int MI_REMOVE_ALL_LEFT_RECURSION = 67;
    public static final int MI_EXTRACT_RULE = 68;
    public static final int MI_INLINE_RULE = 69;
    public static final int MI_GENERATE_CODE = 70;
    public static final int MI_SHOW_GENERATED_PARSER_CODE = 71;
    public static final int MI_SHOW_GENERATED_LEXER_CODE = 72;
    public static final int MI_SHOW_RULE_GENCODE = 73;
    public static final int MI_RUN_INTERPRETER = 80;
    public static final int MI_DEBUG = 81;
    public static final int MI_DEBUG_AGAIN = 82;
    public static final int MI_DEBUG_REMOTE = 83;
    public static final int MI_DEBUG_SHOW_INPUT_TOKENS = 86;
    public static final int MI_P4_EDIT = 90;
    public static final int MI_P4_ADD = 91;
    public static final int MI_P4_DELETE = 92;
    public static final int MI_P4_REVERT = 93;
    public static final int MI_P4_SUBMIT = 94;
    public static final int MI_P4_SYNC = 95;
    public static final int MI_SUBMIT_STATS = 100;
    public static final int MI_SEND_FEEDBACK = 101;
    public static final int MI_CHECK_UPDATES = 102;
    public static final int MI_EXPORT_AS_IMAGE = 110;
    public static final int MI_EXPORT_AS_EPS = 111;
    public static final int MI_EXPORT_ALL_AS_IMAGE = 112;
    public static final int MI_EXPORT_ALL_AS_EPS = 113;
    public static final int MI_EXPORT_AS_DOT = 114;
    public static final int MI_EXPORT_EVENT = 115;
    public static final int MI_PRIVATE_UNREGISTER = 200;
    public static final int MI_SERIALIZE_SD = 201;
    protected CEditorGrammar editor = null;
    protected XJMenuItem ignoreRuleMenuItem;
    public XJMenu menuGrammar;
    protected static ResourceBundle resourceBundle = IDE.getMenusResourceBundle();

    public EditorMenu(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void close() {
        this.editor = null;
    }

    public boolean isDebuggerRunning() {
        return this.editor.debugger.isRunning();
    }

    public void customizeFileMenu(XJMenu xJMenu) {
        xJMenu.insertItemAfter(new XJMenuItem(resourceBundle.getString("menu.item.print"), 80, 5, this), 10004);
        xJMenu.insertSeparatorAfter(10004);
        XJMenu xJMenu2 = new XJMenu();
        xJMenu2.setTitle(resourceBundle.getString("menu.title.exportEvents"));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.asText"), 115, this));
        xJMenu.insertItemAfter(xJMenu2, 10004);
        xJMenu2 = new XJMenu();
        xJMenu2.setTitle(resourceBundle.getString("menu.title.exportAllRules"));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsEPS"), 113, this));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsBitmap"), 112, this));
        xJMenu.insertItemAfter(xJMenu2, 10004);
        xJMenu2 = new XJMenu();
        xJMenu2.setTitle(resourceBundle.getString("menu.title.export"));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsEPS"), 111, this));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsBitmap"), 110, this));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsDot"), 114, this));
        xJMenu.insertItemAfter(xJMenu2, 10004);
        xJMenu.insertSeparatorAfter(10004);
    }

    public void customizeMenuBar(XJMainMenuBar xJMainMenuBar) {
        this.createFindMenu(xJMainMenuBar);
        this.createGoToMenu(xJMainMenuBar);
        this.createGrammarMenu(xJMainMenuBar);
        this.createRefactorMenu(xJMainMenuBar);
        this.createGenerateMenu(xJMainMenuBar);
        this.createRunMenu(xJMainMenuBar);
        if (!IDE.isPlugin()) {
            this.createSCMMenu(xJMainMenuBar);
        }
        this.createPrivateMenu(xJMainMenuBar);
    }

    private void createPrivateMenu(XJMainMenuBar xJMainMenuBar) {
        if (AWPrefs.getPrivateMenu()) {
            XJMenu xJMenu = new XJMenu();
            xJMenu.setTitle("*");
            xJMenu.addItem(new XJMenuItem("Unregister user", 200, this));
            xJMenu.addItem(new XJMenuItem("Serialize Syntax Diagrams...", 201, this));
            xJMainMenuBar.addCustomMenu(xJMenu);
        }
    }

    private void createSCMMenu(XJMainMenuBar xJMainMenuBar) {
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle(resourceBundle.getString("menu.title.scm"));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.scmOpenForEdit"), 90, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.scmMarkForAdd"), 91, this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.scmMarkForDelete"), 92, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.scmRevert"), 93, this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.scmSubmit"), 94, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.scmSync"), 95, this));
        xJMainMenuBar.addCustomMenu(xJMenu);
    }

    private void createRunMenu(XJMainMenuBar xJMainMenuBar) {
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle(resourceBundle.getString("menu.title.debugger"));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.debug"), 68, 81, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.debugAgain"), 68, XJMenuItem.getKeyModifier() | 1, 82, (XJMenuItemDelegate)this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.debugRemote"), 83, this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showInputTokens"), 86, this));
        xJMainMenuBar.addCustomMenu(xJMenu);
    }

    private void createGenerateMenu(XJMainMenuBar xJMainMenuBar) {
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle(resourceBundle.getString("menu.title.generate"));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.generateCode"), 71, XJMenuItem.getKeyModifier() | 1, 70, (XJMenuItemDelegate)this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showParserCode"), 71, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showLexerCode"), 72, this));
        xJMenu.addSeparator();
        xJMenu.addItem(this.createMenuItem(73));
        xJMainMenuBar.addCustomMenu(xJMenu);
    }

    private void createGoToMenu(XJMainMenuBar xJMainMenuBar) {
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle(resourceBundle.getString("menu.title.goto"));
        xJMenu.addItem(this.createMenuItem(40));
        xJMenu.addItem(this.createMenuItem(41));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoLine"), 71, 42, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoCharacter"), 43, this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoBack"), 37, XJMenuItem.getKeyModifier() | 8, 44, (XJMenuItemDelegate)this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoForward"), 39, XJMenuItem.getKeyModifier() | 8, 45, (XJMenuItemDelegate)this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoPreviousBreakpoint"), 46, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoNextBreakpoint"), 47, this));
        xJMainMenuBar.addCustomMenu(xJMenu);
    }

    private void createRefactorMenu(XJMainMenuBar xJMainMenuBar) {
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle(resourceBundle.getString("menu.title.refactor"));
        xJMenu.addItem(this.createMenuItem(61));
        xJMenu.addItem(this.createMenuItem(62));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.removeLeftRecursion"), 66, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.removeAllLeftRecursion"), 67, this));
        xJMenu.addSeparator();
        xJMenu.addItem(this.createMenuItem(68));
        xJMenu.addItem(this.createMenuItem(69));
        xJMenu.addSeparator();
        XJMenu xJMenu2 = new XJMenu();
        xJMenu2.setTitle(resourceBundle.getString("menu.title.convertLiterals"));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.convertToSingleQuote"), 63, this));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.convertToDoubleQuote"), 64, this));
        xJMenu2.addItem(new XJMenuItem(resourceBundle.getString("menu.item.convertToCStyleQuote"), 65, this));
        xJMenu.addItem(xJMenu2);
        xJMainMenuBar.addCustomMenu(xJMenu);
    }

    private void createGrammarMenu(XJMainMenuBar xJMainMenuBar) {
        this.menuGrammar = new XJMenu();
        this.menuGrammar.setTitle(resourceBundle.getString("menu.title.grammar"));
        this.menuGrammar.addItem(new XJMenuItemCheck(resourceBundle.getString("menu.item.highlightDecisionDFA"), 50, this, false));
        this.menuGrammar.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showRuleDependencyGraph"), 52, this));
        this.menuGrammar.addSeparator();
        this.menuGrammar.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showTokensSyntaxDiagram"), 53, this));
        this.menuGrammar.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showTokensDFA"), 54, this));
        this.menuGrammar.addSeparator();
        this.menuGrammar.addItem(new XJMenuItem(resourceBundle.getString("menu.item.insertRuleFromTemplate"), 84, 55, this));
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle(resourceBundle.getString("menu.title.rules"));
        xJMenu.addItem(this.createMenuItem(56));
        xJMenu.addItem(this.createMenuItem(57));
        xJMenu.addSeparator();
        this.ignoreRuleMenuItem = this.createMenuItem(58);
        xJMenu.addItem(this.ignoreRuleMenuItem);
        this.menuGrammar.addItem(xJMenu);
        this.menuGrammar.addSeparator();
        this.menuGrammar.addItem(new XJMenuItem(resourceBundle.getString("menu.item.checkGrammar"), 82, 59, this));
        xJMainMenuBar.addCustomMenu(this.menuGrammar);
    }

    private void createFindMenu(XJMainMenuBar xJMainMenuBar) {
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle(resourceBundle.getString("menu.title.find"));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.find"), 70, 30, this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.findNext"), 114, 0, 31, (XJMenuItemDelegate)this));
        xJMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.findPrevious"), 114, 1, 32, (XJMenuItemDelegate)this));
        xJMenu.addItem(this.createMenuItem(33));
        xJMenu.addSeparator();
        xJMenu.addItem(this.createMenuItem(34));
        xJMainMenuBar.addCustomMenu(xJMenu);
    }

    public XJMenuItem createMenuItem(int n) {
        return this.createMenuItem(n, false);
    }

    public XJMenuItem createMenuItem(int n, boolean bl) {
        XJMenuItem xJMenuItem = null;
        switch (n) {
            case 33: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.findTextAtCaret"), 114, 33, this);
                break;
            }
            case 34: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.findUsages"), 118, 8, 34, (XJMenuItemDelegate)this);
                break;
            }
            case 51: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.showDecisionDFA"), 51, this);
                break;
            }
            case 52: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.showRuleDependencyGraph"), 52, this);
                break;
            }
            case 40: {
                xJMenuItem = new XJMenuItem(bl ? resourceBundle.getString("contextual.item.gotoRule") : resourceBundle.getString("menu.item.gotoRule"), 66, XJMenuItem.getKeyModifier() | 1, 40, (XJMenuItemDelegate)this);
                break;
            }
            case 41: {
                xJMenuItem = new XJMenuItem(bl ? resourceBundle.getString("contextual.item.goToDeclaration") : resourceBundle.getString("menu.item.gotoDeclaration"), 66, 41, this);
                break;
            }
            case 61: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.rename"), 117, 1, 61, (XJMenuItemDelegate)this);
                break;
            }
            case 62: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.replaceLiteralsWithTokenLabel"), 62, this);
                break;
            }
            case 68: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.extractRule"), 68, this);
                break;
            }
            case 69: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.inlineRule"), 69, this);
                break;
            }
            case 73: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.showRuleCode"), 73, this);
                break;
            }
            case 56: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.group"), 56, this);
                break;
            }
            case 57: {
                xJMenuItem = new XJMenuItem(resourceBundle.getString("menu.item.ungroup"), 57, this);
                break;
            }
            case 58: {
                xJMenuItem = new XJMenuItemCheck(resourceBundle.getString("menu.item.ignoreInInterpreter"), 58, this, true);
                break;
            }
            case 110: {
                xJMenuItem = new XJMenuItem(bl ? resourceBundle.getString("contextual.item.exportAsBitmapImage") : resourceBundle.getString("menu.item.exportAsBitmap"), 110, this);
                break;
            }
            case 111: {
                xJMenuItem = new XJMenuItem(bl ? resourceBundle.getString("contextual.item.exportAsEPS") : resourceBundle.getString("menu.item.exportAsEPS"), 111, this);
                break;
            }
            case 114: {
                xJMenuItem = new XJMenuItem(bl ? resourceBundle.getString("contextual.item.exportAsDot") : resourceBundle.getString("menu.item.exportAsDot"), 114, this);
            }
        }
        return xJMenuItem;
    }

    public JPopupMenu getContextualMenu(int n) {
        boolean bl = this.editor.getCurrentReference() != null;
        boolean bl2 = this.editor.getCurrentToken() != null;
        boolean bl3 = this.editor.getCurrentRule() != null;
        boolean bl4 = this.editor.getTextPane().getSelectionStart() != this.editor.getTextPane().getSelectionEnd();
        boolean bl5 = this.editor.decisionDFAEngine.isDecisionPointAroundLocation(this.editor.getTextEditor().getLineIndexAtTextPosition(n), this.editor.getTextEditor().getColumnPositionAtIndex(n));
        ContextualMenuFactory contextualMenuFactory = new ContextualMenuFactory(this);
        contextualMenuFactory.addItem(40);
        if (bl) {
            contextualMenuFactory.addItem(41);
        }
        contextualMenuFactory.addSeparator();
        if (bl2) {
            contextualMenuFactory.addItem(61);
        }
        if (this.editor.menuRefactor.canReplaceLiteralWithTokenLabel()) {
            contextualMenuFactory.addItem(62);
        }
        if (this.editor.menuRefactor.canExtractRule()) {
            contextualMenuFactory.addItem(68);
        }
        if (this.editor.menuRefactor.canInlineRule()) {
            contextualMenuFactory.addItem(69);
        }
        if (bl2) {
            contextualMenuFactory.addSeparator();
            if (bl4) {
                contextualMenuFactory.addItem(33);
            }
            contextualMenuFactory.addItem(34);
        }
        if (bl3) {
            contextualMenuFactory.addSeparator();
            if (bl5) {
                contextualMenuFactory.addItem(51);
            }
            contextualMenuFactory.addItem(52);
            contextualMenuFactory.addItem(73);
        }
        return contextualMenuFactory.menu;
    }

    public void menuItemState(final XJMenuItem xJMenuItem) {
        EditorTab editorTab = this.editor.getSelectedTab();
        switch (xJMenuItem.getTag()) {
            case 10023: 
            case 10024: {
                if (!this.isDebuggerRunning()) break;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        xJMenuItem.setEnabled(false);
                    }
                });
                break;
            }
            case 10025: 
            case 10027: {
                xJMenuItem.setEnabled(this.editor.isFileWritable());
                break;
            }
            case 20: 
            case 21: 
            case 30: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 80: {
                xJMenuItem.setEnabled(!this.isDebuggerRunning());
                break;
            }
            case 82: {
                xJMenuItem.setEnabled(!this.isDebuggerRunning() && this.editor.debugger.canDebugAgain());
                break;
            }
            case 81: 
            case 83: {
                xJMenuItem.setEnabled(!this.isDebuggerRunning());
                break;
            }
            case 44: {
                xJMenuItem.setEnabled(this.editor.goToHistory.canGoBack());
                break;
            }
            case 45: {
                xJMenuItem.setEnabled(this.editor.goToHistory.canGoForward());
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                if (this.isDebuggerRunning()) {
                    xJMenuItem.setEnabled(false);
                    break;
                }
                xJMenuItem.setEnabled(AWPrefs.getP4Enabled());
                break;
            }
            case 110: {
                xJMenuItem.setEnabled(editorTab.canExportToBitmap());
                break;
            }
            case 111: {
                xJMenuItem.setEnabled(editorTab.canExportToEPS());
                break;
            }
            case 114: {
                xJMenuItem.setEnabled(editorTab.canExportToDOT());
                break;
            }
            case 86: {
                xJMenuItem.setTitle(this.editor.menuDebugger.isInputTokenVisible() ? resourceBundle.getString("menu.item.hideInputTokens") : resourceBundle.getString("menu.item.showInputTokens"));
                break;
            }
            case 50: {
                if (this.editor.decisionDFAEngine.getDecisionDFACount() == 0) {
                    xJMenuItem.setSelected(false);
                    break;
                }
                xJMenuItem.setSelected(true);
            }
        }
    }

    public void handleMenuSelected(XJMenu xJMenu) {
        boolean bl = this.editor.rules.getFirstSelectedRuleIgnoredFlag();
        this.ignoreRuleMenuItem.setSelected(bl);
    }

    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
        this.handleMenuFile(xJMenuItem.getTag());
        this.handleMenuView(xJMenuItem.getTag());
        this.handleMenuFind(xJMenuItem.getTag());
        this.handleMenuGrammar(xJMenuItem);
        this.handleMenuRefactor(xJMenuItem.getTag());
        this.handleMenuGoTo(xJMenuItem.getTag());
        this.handleMenuGenerate(xJMenuItem.getTag());
        this.handleMenuRun(xJMenuItem.getTag());
        this.handleMenuSCM(xJMenuItem.getTag());
        this.handleMenuPrivate(xJMenuItem.getTag());
        this.handleMenuExport(xJMenuItem.getTag());
    }

    public void handleMenuFile(int n) {
        switch (n) {
            case 5: {
                this.editor.print();
            }
        }
    }

    public void handleMenuView(int n) {
        switch (n) {
            case 20: {
                this.editor.menuFolding.expandCollapseRule();
                break;
            }
            case 21: {
                this.editor.menuFolding.expandCollapseAction();
            }
        }
    }

    public void handleMenuFind(int n) {
        switch (n) {
            case 30: {
                this.editor.menuFind.find();
                break;
            }
            case 31: {
                this.editor.menuFind.findNext();
                break;
            }
            case 32: {
                this.editor.menuFind.findPrev();
                break;
            }
            case 33: {
                this.editor.menuFind.findSelection();
                break;
            }
            case 34: {
                this.editor.menuFind.findUsage();
            }
        }
    }

    public void handleMenuGrammar(XJMenuItem xJMenuItem) {
        switch (xJMenuItem.getTag()) {
            case 53: {
                this.editor.menuGrammar.showTokensSD();
                break;
            }
            case 54: {
                this.editor.menuGrammar.showTokensDFA();
                break;
            }
            case 51: {
                this.editor.menuGrammar.showDecisionDFA();
                break;
            }
            case 50: {
                this.editor.menuGrammar.highlightDecisionDFA();
                break;
            }
            case 52: {
                this.editor.menuGrammar.showDependency();
                break;
            }
            case 55: {
                this.editor.menuGrammar.insertRuleFromTemplate();
                break;
            }
            case 56: {
                this.editor.menuGrammar.group();
                break;
            }
            case 57: {
                this.editor.menuGrammar.ungroup();
                break;
            }
            case 58: {
                if (xJMenuItem.isSelected()) {
                    this.editor.menuGrammar.ignore();
                    break;
                }
                this.editor.menuGrammar.consider();
                break;
            }
            case 59: {
                this.editor.menuGrammar.checkGrammar();
            }
        }
    }

    public void handleMenuRefactor(int n) {
        switch (n) {
            case 61: {
                this.editor.menuRefactor.rename();
                break;
            }
            case 62: {
                this.editor.menuRefactor.replaceLiteralWithTokenLabel();
                break;
            }
            case 63: {
                this.editor.menuRefactor.convertLiteralsToSingleQuote();
                break;
            }
            case 64: {
                this.editor.menuRefactor.convertLiteralsToDoubleQuote();
                break;
            }
            case 65: {
                this.editor.menuRefactor.convertLiteralsToCStyleQuote();
                break;
            }
            case 66: {
                this.editor.menuRefactor.removeLeftRecursion();
                break;
            }
            case 67: {
                this.editor.menuRefactor.removeAllLeftRecursion();
                break;
            }
            case 68: {
                this.editor.menuRefactor.extractRule();
                break;
            }
            case 69: {
                this.editor.menuRefactor.inlineRule();
            }
        }
    }

    public void handleMenuGoTo(int n) {
        switch (n) {
            case 40: {
                this.editor.menuGoTo.goToRule();
                break;
            }
            case 41: {
                this.editor.menuGoTo.goToDeclaration();
                break;
            }
            case 42: {
                this.editor.menuGoTo.goToLine();
                break;
            }
            case 43: {
                this.editor.menuGoTo.goToCharacter();
                break;
            }
            case 44: {
                this.editor.menuGoTo.goToBackward();
                break;
            }
            case 45: {
                this.editor.menuGoTo.goToForward();
                break;
            }
            case 46: {
                this.editor.menuGoTo.goToBreakpoint(-1);
                break;
            }
            case 47: {
                this.editor.menuGoTo.goToBreakpoint(1);
            }
        }
    }

    public void handleMenuGenerate(int n) {
        switch (n) {
            case 70: {
                this.editor.menuGenerate.generateCode();
                break;
            }
            case 72: {
                this.editor.menuGenerate.showGeneratedCode(2);
                break;
            }
            case 71: {
                this.editor.menuGenerate.showGeneratedCode(1);
                break;
            }
            case 73: {
                this.editor.menuGenerate.showRuleGeneratedCode();
            }
        }
    }

    public void handleMenuRun(int n) {
        switch (n) {
            case 80: {
                this.editor.menuDebugger.runInterpreter();
                break;
            }
            case 81: {
                this.editor.menuDebugger.debug();
                break;
            }
            case 82: {
                this.editor.menuDebugger.debugAgain();
                break;
            }
            case 83: {
                this.editor.menuDebugger.debugRemote();
                break;
            }
            case 86: {
                this.editor.menuDebugger.toggleInputTokens();
                this.editor.refreshMainMenuBar();
            }
        }
    }

    public void handleMenuSCM(int n) {
        switch (n) {
            case 90: {
                this.editor.menuSCM.editFile();
                break;
            }
            case 91: {
                this.editor.menuSCM.addFile();
                break;
            }
            case 92: {
                this.editor.menuSCM.deleteFile();
                break;
            }
            case 93: {
                this.editor.menuSCM.revertFile();
                break;
            }
            case 94: {
                this.editor.menuSCM.submitFile();
                break;
            }
            case 95: {
                this.editor.menuSCM.sync();
            }
        }
    }

    public void handleMenuPrivate(int n) {
        switch (n) {
            case 200: {
                AWPrefs.removeUserRegistration();
                break;
            }
            case 201: {
                this.editor.visual.serializeSyntaxDiagram();
            }
        }
    }

    public void handleMenuExport(int n) {
        switch (n) {
            case 110: {
                this.editor.menuExport.exportAsImage();
                break;
            }
            case 111: {
                this.editor.menuExport.exportAsEPS();
                break;
            }
            case 114: {
                this.editor.menuExport.exportAsDOT();
                break;
            }
            case 112: {
                this.editor.menuExport.exportAllRulesAsImage();
                break;
            }
            case 113: {
                this.editor.menuExport.exportAllRulesAsEPS();
                break;
            }
            case 115: {
                this.editor.menuExport.exportEventsAsTextFile();
            }
        }
    }
}

