/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.editor.EditorInspectorItem;
import org.antlr.works.editor.InspectorDelegate;
import org.antlr.works.grammar.RefactorEngine;
import org.antlr.works.grammar.decisiondfa.DecisionDFAEngine;
import org.antlr.works.idea.IdeaAction;
import org.antlr.works.syntax.GrammarSyntax;
import org.antlr.works.syntax.element.ElementGrammarName;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.syntax.element.ElementToken;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorInspector {
    private GrammarSyntax syntax;
    private DecisionDFAEngine decisionDFAEngine;
    private InspectorDelegate delegate;

    public EditorInspector(GrammarSyntax grammarSyntax, DecisionDFAEngine decisionDFAEngine, InspectorDelegate inspectorDelegate) {
        this.syntax = grammarSyntax;
        this.decisionDFAEngine = decisionDFAEngine;
        this.delegate = inspectorDelegate;
    }

    public void close() {
        this.syntax = null;
        this.decisionDFAEngine = null;
        this.delegate = null;
    }

    public List<EditorInspectorItem> getErrors() {
        ArrayList<EditorInspectorItem> arrayList = new ArrayList<EditorInspectorItem>();
        this.discoverInvalidGrammarName(arrayList);
        this.discoverInvalidCharLiteralTokens(arrayList);
        this.discoverUndefinedReferences(arrayList);
        this.discoverDuplicateRules(arrayList);
        return arrayList;
    }

    public List<EditorInspectorItem> getWarnings() {
        ArrayList<EditorInspectorItem> arrayList = new ArrayList<EditorInspectorItem>();
        this.discoverLeftRecursionRules(arrayList);
        this.discoverLeftRecursiveRulesSet(arrayList);
        return arrayList;
    }

    public List<EditorInspectorItem> getDecisionDFAs() {
        ArrayList<EditorInspectorItem> arrayList = new ArrayList<EditorInspectorItem>();
        this.discoverDecisionDFAs(arrayList);
        return arrayList;
    }

    protected List<EditorInspectorItem> getAllItemsAtIndex(int n) {
        ArrayList<EditorInspectorItem> arrayList = new ArrayList<EditorInspectorItem>();
        arrayList.addAll(this.getItemsAtIndex(this.getErrors(), n));
        arrayList.addAll(this.getItemsAtIndex(this.getWarnings(), n));
        arrayList.addAll(this.getItemsAtIndex(this.getDecisionDFAs(), n));
        return arrayList;
    }

    protected List<EditorInspectorItem> getItemsAtIndex(List<EditorInspectorItem> list, int n) {
        ArrayList<EditorInspectorItem> arrayList = new ArrayList<EditorInspectorItem>();
        for (EditorInspectorItem editorInspectorItem : list) {
            if (n < editorInspectorItem.startIndex || n > editorInspectorItem.endIndex) continue;
            arrayList.add(editorInspectorItem);
        }
        return arrayList;
    }

    protected void discoverInvalidGrammarName(List<EditorInspectorItem> list) {
        ElementGrammarName elementGrammarName = this.getGrammarName();
        String string = this.getGrammarNameFromFile();
        if (elementGrammarName != null && string != null && !string.equals(elementGrammarName.getName())) {
            ATEToken aTEToken = elementGrammarName.name;
            ItemInvalidGrammarName itemInvalidGrammarName = new ItemInvalidGrammarName();
            itemInvalidGrammarName.setAttributes(aTEToken, aTEToken.getStartIndex(), aTEToken.getEndIndex(), aTEToken.startLineNumber, Color.red, "Invalid grammar name '" + aTEToken.getAttribute() + "'");
            list.add(itemInvalidGrammarName);
        }
    }

    private ElementGrammarName getGrammarName() {
        return this.syntax.getParserEngine().getName();
    }

    private String getGrammarNameFromFile() {
        String string = this.delegate.getFileName();
        if (string == null) {
            return null;
        }
        return XJUtils.getPathByDeletingPathExtension(string);
    }

    protected void discoverInvalidCharLiteralTokens(List<EditorInspectorItem> list) {
        List<ATEToken> list2 = this.syntax.getParserEngine().getTokens();
        if (list2 == null) {
            return;
        }
        for (ATEToken aTEToken : list2) {
            if (aTEToken.type != 2 || RefactorEngine.ignoreScopeForDoubleQuoteLiteral(aTEToken.scope)) continue;
            ItemInvalidCharLiteral itemInvalidCharLiteral = new ItemInvalidCharLiteral();
            itemInvalidCharLiteral.setAttributes(aTEToken, aTEToken.getStartIndex(), aTEToken.getEndIndex(), aTEToken.startLineNumber, Color.red, "Invalid character literal '" + aTEToken.getAttribute() + "' - must use single quote");
            list.add(itemInvalidCharLiteral);
        }
    }

    protected void discoverUndefinedReferences(List<EditorInspectorItem> list) {
        List<ElementReference> list2 = this.syntax.getUndefinedReferences();
        if (list2 == null) {
            return;
        }
        for (ElementReference elementReference : list2) {
            ItemUndefinedReference itemUndefinedReference = new ItemUndefinedReference();
            itemUndefinedReference.setAttributes(elementReference.token, elementReference.token.getStartIndex(), elementReference.token.getEndIndex(), elementReference.token.startLineNumber, Color.red, "Undefined reference \"" + elementReference.token.getAttribute() + "\"");
            list.add(itemUndefinedReference);
        }
    }

    protected void discoverDuplicateRules(List<EditorInspectorItem> list) {
        List<ElementRule> list2 = this.syntax.getDuplicateRules();
        if (list2 == null) {
            return;
        }
        for (ElementRule elementRule : list2) {
            ItemDuplicateRule itemDuplicateRule = new ItemDuplicateRule();
            itemDuplicateRule.setAttributes(elementRule.start, elementRule.start.getStartIndex(), elementRule.start.getEndIndex(), elementRule.start.startLineNumber, Color.red, "Duplicate rule \"" + elementRule.name + "\"");
            list.add(itemDuplicateRule);
        }
    }

    protected void discoverLeftRecursionRules(List<EditorInspectorItem> list) {
        List<ElementRule> list2 = this.syntax.getParserEngine().getRules();
        if (list2 == null) {
            return;
        }
        for (ElementRule elementRule : list2) {
            if (!elementRule.hasLeftRecursion()) continue;
            ItemLeftRecursion itemLeftRecursion = new ItemLeftRecursion();
            itemLeftRecursion.setAttributes(elementRule.start, elementRule.start.getStartIndex(), elementRule.start.getEndIndex(), elementRule.start.startLineNumber, Color.blue, "Rule \"" + elementRule.name + "\" is left-recursive");
            list.add(itemLeftRecursion);
        }
    }

    protected void discoverLeftRecursiveRulesSet(List<EditorInspectorItem> list) {
        List<ElementRule> list2 = this.syntax.getParserEngine().getRules();
        if (list2 == null) {
            return;
        }
        for (ElementRule elementRule : list2) {
            Set set = elementRule.getLeftRecursiveRulesSet();
            if (set == null || set.size() < 2) continue;
            EditorInspectorItem editorInspectorItem = new EditorInspectorItem();
            editorInspectorItem.setAttributes(elementRule.start, elementRule.start.getStartIndex(), elementRule.start.getEndIndex(), elementRule.start.startLineNumber, Color.blue, "Rule \"" + elementRule.name + "\" is mutually left-recursive with other rules (see Console)");
            list.add(editorInspectorItem);
        }
    }

    protected void discoverDecisionDFAs(List<EditorInspectorItem> list) {
        list.addAll(this.decisionDFAEngine.getDecisionDFAItems());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemInvalidGrammarName
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> arrayList = new ArrayList<IdeaAction>();
            arrayList.add(new IdeaAction("Change grammar name to '" + EditorInspector.this.getGrammarNameFromFile() + "'", this, 4, this.token));
            return arrayList;
        }

        @Override
        public void ideaActionFire(IdeaAction ideaAction, int n) {
            switch (n) {
                case 4: {
                    ElementGrammarName elementGrammarName = EditorInspector.this.getGrammarName();
                    ATEToken aTEToken = elementGrammarName.name;
                    EditorInspector.this.delegate.replaceText(aTEToken.start, aTEToken.end, EditorInspector.this.getGrammarNameFromFile());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemInvalidCharLiteral
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> arrayList = new ArrayList<IdeaAction>();
            arrayList.add(new IdeaAction("Convert literals to single quote", this, 3, this.token));
            return arrayList;
        }

        @Override
        public void ideaActionFire(IdeaAction ideaAction, int n) {
            switch (n) {
                case 3: {
                    EditorInspector.this.delegate.convertLiteralsToSingleQuote();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemLeftRecursion
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> arrayList = new ArrayList<IdeaAction>();
            arrayList.add(new IdeaAction("Remove left recursion of rule '" + this.token.getAttribute() + "'", this, 2, this.token));
            return arrayList;
        }

        @Override
        public void ideaActionFire(IdeaAction ideaAction, int n) {
            switch (n) {
                case 2: {
                    EditorInspector.this.delegate.removeLeftRecursion();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemDuplicateRule
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> arrayList = new ArrayList<IdeaAction>();
            arrayList.add(new IdeaAction("Delete rule '" + this.token.getAttribute() + "'", this, 0, this.token));
            return arrayList;
        }

        @Override
        public void ideaActionFire(IdeaAction ideaAction, int n) {
            switch (n) {
                case 0: {
                    EditorInspector.this.delegate.deleteRuleAtCurrentPosition();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemUndefinedReference
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> arrayList = new ArrayList<IdeaAction>();
            arrayList.add(new IdeaAction("Create rule '" + this.token.getAttribute() + "'", this, 1, this.token));
            return arrayList;
        }

        @Override
        public void ideaActionFire(IdeaAction ideaAction, int n) {
            switch (n) {
                case 1: {
                    EditorInspector.this.delegate.createRuleAtIndex(((ElementToken)ideaAction.token).lexer, ideaAction.token.getAttribute(), null);
                }
            }
        }
    }
}

