/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorInspectorItem;
import org.antlr.works.idea.IdeaAction;
import org.antlr.works.idea.IdeaManager;
import org.antlr.works.idea.IdeaManagerDelegate;
import org.antlr.works.idea.IdeaOverlay;
import org.antlr.works.idea.IdeaProvider;
import org.antlr.works.syntax.element.ElementRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorIdeas
implements IdeaManagerDelegate,
IdeaProvider {
    public IdeaManager ideaManager;
    public CEditorGrammar editor;

    public EditorIdeas(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void awake() {
        this.ideaManager = new IdeaManager();
        this.ideaManager.setOverlay(new IdeaOverlay(this.editor, this.editor.getXJFrame(), this.editor.getTextPane()));
        this.ideaManager.addProvider(this);
        this.ideaManager.setDelegate(this);
    }

    public void close() {
        this.editor = null;
        this.ideaManager.close();
    }

    public void hide() {
        this.ideaManager.hide();
    }

    public void toggleEnabled() {
        this.ideaManager.setEnabled(!this.ideaManager.enabled());
    }

    @Override
    public List<IdeaAction> ideaProviderGetActions(int n) {
        ArrayList<IdeaAction> arrayList = new ArrayList<IdeaAction>();
        List<EditorInspectorItem> list = this.editor.editorInspector.getAllItemsAtIndex(n);
        for (EditorInspectorItem editorInspectorItem : list) {
            List<IdeaAction> list2 = editorInspectorItem.getIdeaActions();
            if (list2 == null) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    @Override
    public boolean ideaManagerWillDisplayIdea() {
        return !this.editor.autoCompletionMenu.isVisible();
    }

    public void display(Point point) {
        this.display(this.editor.getTextPane().viewToModel(point));
    }

    public void display(int n) {
        ElementRule elementRule = this.editor.rules.getEnclosingRuleAtPosition(n);
        if (elementRule == null || elementRule.isExpanded()) {
            this.ideaManager.displayAnyIdeasAvailable(n);
        }
    }
}

