/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.util.List;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.folding.ATEFoldingEntityProxy;
import org.antlr.works.ate.folding.ATEFoldingManager;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.syntax.element.ElementAction;
import org.antlr.works.syntax.element.ElementRule;

public class EditorFoldingManager
extends ATEFoldingManager {
    protected static final int TAG_RULES = 0;
    protected static final int TAG_ACTIONS = 1;
    protected CEditorGrammar editor;

    public EditorFoldingManager(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar.textEditor);
        this.editor = cEditorGrammar;
    }

    public void close() {
        super.close();
        this.editor = null;
    }

    public void textPaneWillFold() {
        super.textPaneWillFold();
        this.editor.disableTextPaneUndo();
    }

    public void textPaneDidFold() {
        super.textPaneDidFold();
        this.editor.enableTextPaneUndo();
        this.editor.editorIdeas.hide();
        this.editor.editorTips.hide();
    }

    public ATEFoldingEntityProxy createEntityProxy(ATEFoldingEntity aTEFoldingEntity) {
        int n;
        if (aTEFoldingEntity instanceof ElementRule) {
            n = 0;
        } else if (aTEFoldingEntity instanceof ElementAction) {
            n = 1;
        } else {
            return null;
        }
        return new ATEFoldingEntityProxy(this, aTEFoldingEntity.foldingEntityID(), n);
    }

    public void provideFoldingEntities() {
        List<ElementAction> list;
        List<ElementRule> list2 = this.editor.parserEngine.getRules();
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                ElementRule elementRule = list2.get(i);
                this.addEntity(elementRule);
            }
        }
        if (AWPrefs.getFoldingEnabled() && AWPrefs.getDisplayActionsAnchorsFolding() && (list = this.editor.parserEngine.getActions()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                ElementAction elementAction = list.get(i);
                if (!elementAction.rule.isExpanded()) continue;
                this.addEntity(elementAction);
            }
        }
    }

    public ATEFoldingEntity getEntityForIdentifier(List list, String string) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            ATEFoldingEntity aTEFoldingEntity = (ATEFoldingEntity)list.get(i);
            if (!aTEFoldingEntity.foldingEntityID().equals(string)) continue;
            return aTEFoldingEntity;
        }
        return null;
    }

    public ATEFoldingEntity getEntityForKey(Object object, int n) {
        if (n == 1) {
            return this.getEntityForIdentifier(this.editor.parserEngine.getActions(), (String)object);
        }
        if (n == 0) {
            return this.getEntityForIdentifier(this.editor.parserEngine.getRules(), (String)object);
        }
        return null;
    }
}

