/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.swing.Toolbar;
import org.antlr.works.utils.Console;
import org.antlr.xjlib.foundation.XJUtils;

public class EditorConsole
extends EditorTab
implements Console {
    protected CEditorGrammar editor;
    protected JPanel panel;
    protected JTextArea textArea;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    protected Map<Thread, Integer> modeByThread = new HashMap<Thread, Integer>();
    protected static EditorConsole current = null;

    public static synchronized void setCurrent(EditorConsole editorConsole) {
        current = editorConsole;
    }

    public static synchronized EditorConsole getCurrent() {
        return current;
    }

    public EditorConsole(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
        this.panel = new JPanel(new BorderLayout());
        Toolbar toolbar = Toolbar.createHorizontalToolbar();
        JButton jButton = new JButton("Clear All");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorConsole.this.clear();
            }
        });
        toolbar.addElement(jButton);
        toolbar.add(Box.createHorizontalGlue());
        this.panel.add((Component)this.createTextArea(), "Center");
        this.panel.add((Component)toolbar, "South");
    }

    public void setMode(int n) {
        this.modeByThread.put(Thread.currentThread(), n);
    }

    public void close() {
        this.editor = null;
        if (current == this) {
            current = null;
        }
    }

    public int getMode() {
        Integer n = this.modeByThread.get(Thread.currentThread());
        if (n == null) {
            return 1;
        }
        return n;
    }

    public void makeCurrent() {
        EditorConsole.setCurrent(this);
    }

    public Container getContainer() {
        return this.panel;
    }

    public Container createTextArea() {
        this.textArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setWheelScrollingEnabled(true);
        return jScrollPane;
    }

    public void clear() {
        this.textArea.setText("");
        this.editor.clearConsoleStatus();
    }

    public synchronized void println(String string) {
        this.println(string, 0);
    }

    public synchronized void println(String string, int n) {
        this.print(string + "\n", n);
    }

    public synchronized void print(Throwable throwable) {
        this.println(XJUtils.stackTrace(throwable), 2);
    }

    public synchronized void print(final String string, final int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorConsole.this.print(string, n);
                }
            });
            return;
        }
        String string2 = "[" + this.dateFormat.format(new Date()) + "] " + string;
        this.textArea.setText(this.textArea.getText() + string2);
        this.textArea.setCaretPosition(this.textArea.getText().length());
        System.out.println(string);
        if (this.getMode() == 1) {
            this.editor.consolePrint(string, n);
        }
    }

    public String getTabName() {
        return "Console";
    }

    public Component getTabComponent() {
        return this.getContainer();
    }
}

