/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.ate.analysis.ATEAnalysisItem;
import org.antlr.works.ate.analysis.ATEAnalysisManager;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorInspectorItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorAnalysisManager
extends ATEAnalysisManager {
    protected static final int ANALYSIS_ITEM_ERROR = 0;
    protected static final int ANALYSIS_ITEM_WARNING = 1;
    protected static final int ANALYSIS_ITEM_OTHER = 2;
    protected final Color greenColor = new Color(0.0f, 0.9f, 0.25f, 1.0f);
    protected CEditorGrammar editor;
    protected int numberOfErrors;
    protected int numberOfWarnings;

    public EditorAnalysisManager(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void close() {
        this.editor = null;
    }

    @Override
    public int[] getAvailableTypes() {
        return new int[]{1, 0, 2};
    }

    @Override
    public List<ATEAnalysisItem> getItemsForType(int n) {
        switch (n) {
            case 0: {
                return this.getErrors();
            }
            case 1: {
                return this.getWarnings();
            }
            case 2: {
                return this.getOthers();
            }
        }
        return null;
    }

    @Override
    public int getLinesCount() {
        return this.editor.parserEngine.getMaxLines();
    }

    @Override
    public Color getAnalysisColor() {
        if (this.numberOfErrors == 0 && this.numberOfWarnings == 0) {
            return this.greenColor;
        }
        if (this.numberOfErrors == 0) {
            return Color.yellow;
        }
        return Color.red;
    }

    @Override
    public String getAnalysisDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.numberOfErrors == 0) {
            stringBuffer.append("No error");
        } else {
            stringBuffer.append(this.numberOfErrors);
            if (this.numberOfErrors > 1) {
                stringBuffer.append(" errors found");
            } else {
                stringBuffer.append(" error found");
            }
        }
        if (this.numberOfWarnings > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(this.numberOfWarnings);
            if (this.numberOfWarnings > 1) {
                stringBuffer.append(" warnings found");
            } else {
                stringBuffer.append(" warning found");
            }
        }
        return stringBuffer.toString();
    }

    public List<ATEAnalysisItem> getErrors() {
        ArrayList<ATEAnalysisItem> arrayList = new ArrayList<ATEAnalysisItem>();
        for (EditorInspectorItem editorInspectorItem : this.editor.editorInspector.getErrors()) {
            arrayList.add(new ATEAnalysisItem(0, editorInspectorItem.color, editorInspectorItem.startLineNumber, editorInspectorItem.startIndex, editorInspectorItem.description));
        }
        this.numberOfErrors = arrayList.size();
        return arrayList;
    }

    public List<ATEAnalysisItem> getWarnings() {
        ArrayList<ATEAnalysisItem> arrayList = new ArrayList<ATEAnalysisItem>();
        for (EditorInspectorItem editorInspectorItem : this.editor.editorInspector.getWarnings()) {
            arrayList.add(new ATEAnalysisItem(1, editorInspectorItem.color, editorInspectorItem.startLineNumber, editorInspectorItem.startIndex, editorInspectorItem.description));
        }
        this.numberOfWarnings = arrayList.size();
        return arrayList;
    }

    public List<ATEAnalysisItem> getOthers() {
        ArrayList<ATEAnalysisItem> arrayList = new ArrayList<ATEAnalysisItem>();
        for (EditorInspectorItem editorInspectorItem : this.editor.editorInspector.getDecisionDFAs()) {
            arrayList.add(new ATEAnalysisItem(2, editorInspectorItem.color, editorInspectorItem.startLineNumber, editorInspectorItem.startIndex, editorInspectorItem.description));
        }
        return arrayList;
    }
}

