/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.swing.ATERenderingView;
import org.antlr.works.debugger.Debugger;

public class EditorATERenderingView
extends ATERenderingView {
    protected Debugger debugger;

    public EditorATERenderingView(Element element, ATEPanel aTEPanel, Debugger debugger) {
        super(element, aTEPanel);
        this.debugger = debugger;
        this.displayOp = new EditorDisplayOperation();
    }

    public void close() {
        super.close();
        this.debugger = null;
        this.displayOp = null;
    }

    public class EditorDisplayOperation
    extends ATERenderingView.DisplayOperation {
        public int renderTextPortion(Graphics graphics, int n, int n2, int n3, int n4, int n5, Document document, AttributeSet attributeSet) throws BadLocationException {
            if (EditorATERenderingView.this.debugger == null) {
                return super.renderTextPortion(graphics, n, n2, n3, n4, n5, document, attributeSet);
            }
            int n6 = EditorATERenderingView.this.debugger.getDebuggerCursorIndex();
            if (n6 == -1) {
                return super.renderTextPortion(graphics, n, n2, n3, n4, n5, document, attributeSet);
            }
            int n7 = n4 - n3;
            if (n3 + n7 > n5) {
                n7 = n5 - n3;
            }
            if (n6 >= n3 && n6 < n3 + n7) {
                Segment segment = EditorATERenderingView.this.getLineBuffer();
                document.getText(n6, 1, segment);
                char c = segment.first();
                if (n6 == n3) {
                    this.drawDebuggerCursor(graphics, n, n2, c);
                    return super.renderTextPortion(graphics, n, n2, n3, n4, n5, document, attributeSet);
                }
                n = super.renderTextPortion(graphics, n, n2, n3, n6 - 1, n5, document, attributeSet);
                this.drawDebuggerCursor(graphics, n, n2, c);
                return super.renderTextPortion(graphics, n, n2, n6 - 1, n4, n5, document, attributeSet);
            }
            return super.renderTextPortion(graphics, n, n2, n3, n4, n5, document, attributeSet);
        }

        private void drawDebuggerCursor(Graphics graphics, int n, int n2, char c) {
            EditorATERenderingView.this.saveColor(graphics);
            graphics.setColor(Color.red);
            int n3 = EditorATERenderingView.this.metrics.getHeight();
            graphics.fillRect(n, n2 - n3 + EditorATERenderingView.this.metrics.getDescent(), EditorATERenderingView.this.metrics.charWidth(c), n3);
            EditorATERenderingView.this.restore(graphics);
        }
    }
}

