/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.dialog;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.works.dialog.DialogReportsDelegate;
import org.antlr.works.stats.StatisticsManager;
import org.antlr.works.stats.StatisticsReporter;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJSystem;

public class DialogReports
extends XJDialog {
    public static final int TYPE_GUI = 0;
    public static final int TYPE_GRAMMAR = 1;
    public static final int TYPE_RUNTIME = 2;
    protected StatisticsManager guiManager;
    protected StatisticsManager grammarManager;
    protected StatisticsManager runtimeManager;
    protected DialogReportsDelegate delegate;
    protected XJDialogProgress progress;
    protected DefaultComboBoxModel typeModel = new DefaultComboBoxModel();
    protected boolean usesAWStats = true;
    private JPanel dialogPane;
    private JPanel contentPane;
    private JLabel label1;
    private JComboBox typeCombo;
    private JLabel label22;
    private JCheckBox humanFormatCheck;
    private JSpinner currentSpinner;
    private JLabel label2;
    private JLabel infoLabel;
    private JScrollPane scrollPane1;
    private JTextArea statsTextArea;
    private JPanel buttonBar;
    private JButton submitButton;
    private JButton cancelButton;

    public DialogReports(Container container, boolean bl) {
        super(container, true);
        this.usesAWStats = bl;
        this.initComponents();
        this.setSize(550, 500);
        if (XJSystem.isMacOS()) {
            CellConstraints cellConstraints = new CellConstraints();
            this.buttonBar.remove(this.cancelButton);
            this.buttonBar.remove(this.submitButton);
            this.buttonBar.add((Component)this.cancelButton, cellConstraints.xy(3, 1));
            this.buttonBar.add((Component)this.submitButton, cellConstraints.xy(5, 1));
        }
        this.setDefaultButton(this.submitButton);
        this.setOKButton(this.submitButton);
        this.setCancelButton(this.cancelButton);
        this.buildTypeCombo();
        this.humanFormatCheck.setSelected(true);
        this.statsTextArea.setTabSize(2);
        this.typeCombo.addActionListener(new MyActionListener());
        this.humanFormatCheck.addActionListener(new MyActionListener());
        this.currentSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DialogReports.this.updateInfo(true);
            }
        });
    }

    public void setDelegate(DialogReportsDelegate dialogReportsDelegate) {
        this.delegate = dialogReportsDelegate;
    }

    public void buildTypeCombo() {
        if (this.usesAWStats) {
            this.typeModel.addElement("ANTLRWorks");
        }
        this.typeModel.addElement("ANTLR - grammar");
        this.typeModel.addElement("ANTLR - runtime");
        this.typeCombo.setModel(this.typeModel);
    }

    public void dialogWillDisplay() {
        this.guiManager = new StatisticsManager("antlrworks");
        this.grammarManager = new StatisticsManager("grammar");
        this.runtimeManager = new StatisticsManager("runtime");
        this.updateInfo(false);
    }

    public void dialogWillCloseCancel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DialogReports.this.delegate != null) {
                    DialogReports.this.delegate.reportsCancelled();
                }
            }
        });
    }

    public void dialogWillCloseOK() {
        new SendReport().send();
    }

    protected int getTypeIndex() {
        if (this.usesAWStats) {
            return this.typeCombo.getSelectedIndex();
        }
        return this.typeCombo.getSelectedIndex() + 1;
    }

    protected void updateInfo(boolean bl) {
        StatisticsManager statisticsManager = null;
        boolean bl2 = true;
        switch (this.getTypeIndex()) {
            case 0: {
                bl2 = false;
                statisticsManager = this.guiManager;
                break;
            }
            case 1: {
                bl2 = true;
                statisticsManager = this.grammarManager;
                break;
            }
            case 2: {
                bl2 = true;
                statisticsManager = this.runtimeManager;
            }
        }
        if (!bl) {
            this.setRangeEnabled(bl2, statisticsManager);
        }
        if (statisticsManager != null) {
            this.setText(statisticsManager);
        }
    }

    protected void setRangeEnabled(boolean bl, StatisticsManager statisticsManager) {
        this.currentSpinner.setEnabled(bl);
        this.infoLabel.setEnabled(bl);
        this.currentSpinner.setValue(new Integer(1));
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.currentSpinner.getModel();
        spinnerNumberModel.setMaximum(new Integer(statisticsManager.getStatsCount()));
        if (bl) {
            this.infoLabel.setText("of " + statisticsManager.getStatsCount());
        } else {
            this.infoLabel.setText("");
        }
    }

    protected void setText(StatisticsManager statisticsManager) {
        String string;
        int n = (Integer)this.currentSpinner.getValue() - 1;
        String string2 = string = this.isHumanReadable() ? statisticsManager.getReadableString(n) : statisticsManager.getRawString(n);
        if (string == null) {
            string = "* no statistics available *";
        }
        this.statsTextArea.setText(string);
        this.statsTextArea.setCaretPosition(0);
    }

    protected boolean isHumanReadable() {
        return this.humanFormatCheck.isSelected();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPane = new JPanel();
        this.label1 = new JLabel();
        this.typeCombo = new JComboBox();
        this.label22 = new JLabel();
        this.humanFormatCheck = new JCheckBox();
        this.currentSpinner = new JSpinner();
        this.label2 = new JLabel();
        this.infoLabel = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.statsTextArea = new JTextArea();
        this.buttonBar = new JPanel();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        this.setTitle("Review reports before submission");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setPreferredSize(new Dimension(500, 500));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPane.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;30dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;30dlu):grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, 1.0)}));
        this.label1.setText("View report for:");
        this.label1.setHorizontalAlignment(4);
        this.contentPane.add((Component)this.label1, cellConstraints.xy(1, 1));
        this.typeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"ANTLRWorks", "ANTLR - grammar", "ANTLR - runtime"}));
        this.contentPane.add((Component)this.typeCombo, cellConstraints.xywh(3, 1, 5, 1));
        this.label22.setText("Format:");
        this.label22.setHorizontalAlignment(4);
        this.contentPane.add((Component)this.label22, cellConstraints.xy(1, 3));
        this.humanFormatCheck.setText("Human readable");
        this.humanFormatCheck.setSelected(true);
        this.contentPane.add((Component)this.humanFormatCheck, cellConstraints.xywh(3, 3, 7, 1));
        this.currentSpinner.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        this.contentPane.add((Component)this.currentSpinner, cellConstraints.xywh(3, 5, 2, 1));
        this.label2.setText("Report:");
        this.label2.setHorizontalAlignment(4);
        this.contentPane.add((Component)this.label2, cellConstraints.xy(1, 5));
        this.infoLabel.setText("of 999");
        this.contentPane.add((Component)this.infoLabel, cellConstraints.xywh(7, 5, 3, 1));
        this.statsTextArea.setEditable(false);
        this.statsTextArea.setLineWrap(false);
        this.statsTextArea.setWrapStyleWord(false);
        this.statsTextArea.setTabSize(2);
        this.scrollPane1.setViewportView(this.statsTextArea);
        this.contentPane.add((Component)this.scrollPane1, cellConstraints.xywh(1, 7, 9, 3));
        this.dialogPane.add((Component)this.contentPane, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")));
        this.submitButton.setText("Submit");
        this.buttonBar.add((Component)this.submitButton, cellConstraints.xy(3, 1));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, cellConstraints.xy(5, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        container.add((Component)this.dialogPane, "Center");
        this.pack();
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogReports.this.updateInfo(false);
        }
    }

    protected class SendReport
    implements Runnable,
    XJDialogProgressDelegate {
        public boolean error = false;
        public boolean cancel = false;
        public StatisticsReporter reporter;
        public StatisticsManager[] managers;

        protected SendReport() {
            this.managers = new StatisticsManager[]{DialogReports.this.guiManager, DialogReports.this.grammarManager, DialogReports.this.runtimeManager};
        }

        public void send() {
            DialogReports.this.progress = new XJDialogProgress(DialogReports.this.parent);
            DialogReports.this.progress.setDelegate(this);
            DialogReports.this.progress.setCancellable(true);
            DialogReports.this.progress.setProgressMax(this.managers.length);
            DialogReports.this.progress.setIndeterminate(false);
            DialogReports.this.progress.setInfo("Sending statistics...");
            DialogReports.this.progress.display();
            this.error = false;
            this.cancel = false;
            this.reporter = new StatisticsReporter();
            new Thread(this).start();
        }

        public boolean submit() {
            for (int i = 0; i < this.managers.length; ++i) {
                StatisticsManager statisticsManager = this.managers[i];
                if (statisticsManager == DialogReports.this.guiManager && !DialogReports.this.usesAWStats) continue;
                DialogReports.this.progress.setProgress(i + 1);
                if (!this.reporter.submitStats(statisticsManager)) {
                    return true;
                }
                if (!this.cancel) continue;
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.error = this.submit();
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SendReport.this.finished();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public void finished() {
            String string;
            String string2;
            if (!this.cancel) {
                DialogReports.this.guiManager.reset();
                DialogReports.this.grammarManager.reset();
                DialogReports.this.runtimeManager.reset();
            }
            DialogReports.this.progress.close();
            if (this.cancel) {
                string2 = "Submission cancelled";
                string = "The submission has been cancelled.";
            } else if (this.error) {
                string2 = "Submission failed";
                string = "An error has occurred when sending the statistics:\n" + this.reporter.getError();
            } else {
                string2 = "Thank you";
                string = "The statistics have been successfully transmitted.";
            }
            XJAlert.display(DialogReports.this.getJavaComponent(), string2, string);
            if (DialogReports.this.delegate != null) {
                if (this.cancel) {
                    DialogReports.this.delegate.reportsCancelled();
                } else {
                    DialogReports.this.delegate.reportsSend(!this.error);
                }
            }
        }

        public void dialogDidCancel() {
            this.cancel = true;
            this.reporter.cancel();
        }
    }
}

