/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.awt.Component;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.Token;
import org.antlr.works.awtree.AWTreePanel;
import org.antlr.works.awtree.AWTreePanelDelegate;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.tree.DBParseTreeModel;
import org.antlr.works.debugger.tree.DBParseTreeModelListener;
import org.antlr.works.debugger.tree.DBTreeNode;
import org.antlr.works.swing.DetachablePanel;
import org.antlr.xjlib.appkit.gview.GView;

public class DBParseTreePanel
extends DetachablePanel
implements DBParseTreeModelListener,
AWTreePanelDelegate {
    protected Debugger debugger;
    protected DBParseTreeModel model;
    protected AWTreePanel treePanel;

    public DBParseTreePanel(Debugger debugger) {
        super("Parse Tree", debugger);
        this.debugger = debugger;
        this.model = new DBParseTreeModel(debugger);
        this.model.addListener(this);
        this.treePanel = new AWTreePanel(new DefaultTreeModel(null));
        this.treePanel.setDelegate(this);
        this.mainPanel.add((Component)this.treePanel, "Center");
    }

    public void close() {
        super.close();
        this.treePanel.setDelegate(null);
        this.model.close();
        this.model = null;
        this.debugger = null;
    }

    public DBParseTreeModel getModel() {
        return this.model;
    }

    public void clear() {
        this.model.clear();
        this.treePanel.clear();
    }

    public void updateOnBreakEvent() {
        this.model.fireDataChanged();
    }

    public void selectToken(Token token) {
        DBTreeNode dBTreeNode = (DBTreeNode)this.treePanel.getRoot();
        DBTreeNode dBTreeNode2 = dBTreeNode.findNodeWithToken(token);
        if (dBTreeNode2 != null) {
            this.treePanel.selectNode(dBTreeNode2);
        }
    }

    public void updateParseTree() {
        this.treePanel.refresh();
        this.treePanel.scrollNodeToVisible(this.model.getLastNode());
    }

    public GView getGraphView() {
        return this.treePanel.getGraphView();
    }

    public void modelChanged(DBParseTreeModel dBParseTreeModel) {
        this.treePanel.setRoot(dBParseTreeModel.getRootRule());
        this.updateParseTree();
    }

    public void modelUpdated(DBParseTreeModel dBParseTreeModel) {
        this.updateParseTree();
    }

    public void awTreeDidSelectTreeNode(TreeNode treeNode, boolean bl) {
        DBTreeNode dBTreeNode = (DBTreeNode)treeNode;
        this.debugger.selectToken(dBTreeNode.token, dBTreeNode.line, dBTreeNode.pos);
    }

    public JPopupMenu awTreeGetContextualMenu() {
        return this.debugger.treeGetContextualMenu();
    }
}

