/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.Token;
import org.antlr.tool.Grammar;
import org.antlr.works.awtree.AWTreeModel;
import org.antlr.works.awtree.AWTreeNode;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.tree.DBParseTreeModelListener;
import org.antlr.works.debugger.tree.DBTreeNode;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class DBParseTreeModel
extends AWTreeModel
implements XJNotificationObserver {
    public Stack<ParseTreeNode> rules = new Stack();
    public Stack<Backtrack> backtrackStack = new Stack();
    public Color lookaheadTokenColor;
    public TreeNode lastNode;
    public int line;
    public int pos;
    public Debugger debugger;
    public List<DBParseTreeModelListener> listeners = new ArrayList<DBParseTreeModelListener>();

    public DBParseTreeModel(Debugger debugger) {
        this.debugger = debugger;
        this.initRules();
        this.initColors();
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
    }

    public void close() {
        this.debugger = null;
        this.listeners.clear();
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public void addListener(DBParseTreeModelListener dBParseTreeModelListener) {
        this.listeners.add(dBParseTreeModelListener);
    }

    public void fireDataChanged() {
        for (DBParseTreeModelListener dBParseTreeModelListener : this.listeners) {
            dBParseTreeModelListener.modelChanged(this);
        }
    }

    public void initRules() {
        this.rules.clear();
        this.rules.push(new ParseTreeNode("root"));
    }

    public void initColors() {
        this.lookaheadTokenColor = AWPrefs.getLookaheadTokenColor();
    }

    public void clear() {
        super.clear();
        this.initRules();
        this.backtrackStack.clear();
        this.setLastNode(null);
        this.fireDataChanged();
        this.pos = 0;
        this.line = 0;
    }

    public void setLastNode(TreeNode treeNode) {
        this.lastNode = treeNode;
    }

    public TreeNode getLastNode() {
        return this.lastNode;
    }

    public void setLocation(int n, int n2) {
        this.line = n;
        this.pos = n2;
    }

    public void pushRule(String string) {
        ParseTreeNode parseTreeNode = this.rules.peek();
        ParseTreeNode parseTreeNode2 = new ParseTreeNode(string);
        parseTreeNode2.setPosition(this.line, this.pos);
        this.rules.push(parseTreeNode2);
        this.addNode(parseTreeNode, parseTreeNode2);
        this.addNodeToCurrentBacktrack(parseTreeNode2);
        this.setLastNode(parseTreeNode2);
    }

    public void popRule() {
        this.rules.pop();
    }

    public TreeNode getRootRule() {
        return (TreeNode)this.rules.firstElement();
    }

    public TreeNode peekRule() {
        if (this.rules.isEmpty()) {
            return null;
        }
        return this.rules.peek();
    }

    public void addToken(Token token) {
        ParseTreeNode parseTreeNode = this.rules.peek();
        ParseTreeNode parseTreeNode2 = new ParseTreeNode(token, this.debugger.getGrammar().getANTLRGrammar());
        parseTreeNode2.setPosition(this.line, this.pos);
        this.addNode(parseTreeNode, parseTreeNode2);
        this.addNodeToCurrentBacktrack(parseTreeNode2);
        this.setLastNode(parseTreeNode2);
    }

    public void addException(Exception exception) {
        ParseTreeNode parseTreeNode = this.rules.peek();
        ParseTreeNode parseTreeNode2 = new ParseTreeNode(exception);
        parseTreeNode2.setPosition(this.line, this.pos);
        this.addNode(parseTreeNode, parseTreeNode2);
        this.addNodeToCurrentBacktrack(parseTreeNode2);
        this.setLastNode(parseTreeNode2);
    }

    public void addNodeToCurrentBacktrack(ParseTreeNode parseTreeNode) {
        if (this.backtrackStack.isEmpty()) {
            return;
        }
        Backtrack backtrack = this.backtrackStack.peek();
        backtrack.addNode(parseTreeNode);
    }

    public void beginBacktrack(int n) {
        this.backtrackStack.push(new Backtrack(n, this.lookaheadTokenColor));
    }

    public void endBacktrack(int n, boolean bl) {
        Backtrack backtrack = this.backtrackStack.pop();
        backtrack.end(bl);
        this.setLastNode(backtrack.getLastNode());
    }

    public void notificationFire(Object object, String string) {
        if (string.equals("NOTIF_PREFS_APPLIED")) {
            this.initColors();
        }
    }

    public static class Backtrack {
        public int level;
        public Color lookaheadTokenColor;
        public LinkedList<DBTreeNode> nodes = new LinkedList();

        public Backtrack(int n, Color color) {
            this.level = n;
            this.lookaheadTokenColor = color;
        }

        public void addNode(DBTreeNode dBTreeNode) {
            dBTreeNode.setColor(this.lookaheadTokenColor);
            this.nodes.add(dBTreeNode);
        }

        public void end(boolean bl) {
            Color color = this.getColor(bl);
            for (DBTreeNode dBTreeNode : this.nodes) {
                dBTreeNode.setColor(color);
            }
        }

        public AWTreeNode getLastNode() {
            if (this.nodes.isEmpty()) {
                return null;
            }
            return this.nodes.getLast();
        }

        protected Color getColor(boolean bl) {
            Color color = bl ? Color.green.darker() : Color.red;
            for (int i = 1; i < this.level; ++i) {
                color = color.darker().darker();
            }
            return color;
        }
    }

    public static class ParseTreeNode
    extends DBTreeNode {
        protected String s;
        protected Exception e;

        public ParseTreeNode(String string) {
            this.s = string;
        }

        public ParseTreeNode(Exception exception) {
            this.e = exception;
        }

        public ParseTreeNode(Token token, Grammar grammar) {
            super(token, grammar);
        }

        public String toString() {
            if (this.s != null) {
                return this.s;
            }
            if (this.e != null) {
                return this.e.toString();
            }
            return super.toString();
        }
    }
}

