/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Stack;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.Token;
import org.antlr.works.awtree.AWTreePanel;
import org.antlr.works.awtree.AWTreePanelDelegate;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.tree.DBASTModel;
import org.antlr.works.debugger.tree.DBASTModelListener;
import org.antlr.works.debugger.tree.DBTreeNode;
import org.antlr.works.swing.DetachablePanel;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.swing.XJTable;
import org.antlr.xjlib.appkit.swing.XJTableDelegate;
import org.antlr.xjlib.appkit.swing.XJTableView;

public class DBASTPanel
extends DetachablePanel
implements DBASTModelListener,
XJTableDelegate,
AWTreePanelDelegate {
    public Debugger debugger;
    public XJTableView rulesTableView;
    public XJTableView rootsTableView;
    public AWTreePanel treePanel;
    public DBASTModel model;
    public JSplitPane tablesSplitPane;
    public JSplitPane tableTreeSplitPane;

    public DBASTPanel(Debugger debugger) {
        super("AST", debugger);
        this.debugger = debugger;
        this.model = new DBASTModel(debugger);
        this.model.addListener(this);
        this.rulesTableView = new XJTableView();
        this.rulesTableView.setFocusable(true);
        this.rulesTableView.getTable().setModel(new RulesTableModel());
        this.rulesTableView.getTable().setDelegate(this);
        this.rulesTableView.getTable().setAllowEmptySelection(false);
        this.rulesTableView.getTable().setRememberSelection(true);
        this.rulesTableView.autoresizeColumns();
        this.rootsTableView = new XJTableView();
        this.rootsTableView.getTable().setModel(new RootsTableModel());
        this.rootsTableView.setFocusable(true);
        this.rootsTableView.getTable().setDelegate(this);
        this.rootsTableView.getTable().setAllowEmptySelection(false);
        this.rootsTableView.getTable().setRememberSelection(true);
        this.rootsTableView.autoresizeColumns();
        this.treePanel = new AWTreePanel(new DefaultTreeModel(null));
        this.treePanel.setRootVisible(true);
        this.treePanel.setDelegate(this);
        this.tablesSplitPane = this.createSplitPane();
        this.tableTreeSplitPane = this.createSplitPane();
        this.tablesSplitPane.setLeftComponent(this.rulesTableView);
        this.tablesSplitPane.setRightComponent(this.rootsTableView);
        this.tableTreeSplitPane.setLeftComponent(this.tablesSplitPane);
        this.tableTreeSplitPane.setRightComponent(this.treePanel);
        this.mainPanel.add((Component)this.tableTreeSplitPane, "Center");
    }

    public void close() {
        super.close();
        this.treePanel.setDelegate(null);
        this.debugger = null;
    }

    public JSplitPane createSplitPane() {
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setBorder(null);
        jSplitPane.setOrientation(1);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(true);
        return jSplitPane;
    }

    public void componentShouldLayout(Dimension dimension) {
        this.tableTreeSplitPane.setDividerLocation((int)((double)dimension.width * 0.5));
        this.tablesSplitPane.setDividerLocation((int)((double)dimension.width * 0.3));
    }

    public void clear() {
        this.model.clear();
        this.treePanel.clear();
    }

    public void updateOnBreakEvent() {
        this.model.fireDataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBASTPanel.this.selectLastRule();
                DBASTPanel.this.selectLastRootNode();
            }
        });
    }

    public DBASTModel getModel() {
        return this.model;
    }

    public void modelChanged(DBASTModel dBASTModel) {
        this.rulesModelChanged();
        this.rootsModelChanged();
    }

    public void rulesModelChanged() {
        this.rulesTableView.getTable().reload();
    }

    public void rootsModelChanged() {
        this.rootsTableView.getTable().reload();
        this.updateTreePanel();
    }

    public void updateTreePanel() {
        int n = this.rootsTableView.getTable().getSelectedRow();
        if (n == -1) {
            this.treePanel.setRoot(null);
        } else {
            this.treePanel.setRoot(this.getRootAtIndex(n));
        }
        this.treePanel.refresh();
    }

    public void selectToken(Token token) {
        DBASTModel.Rule rule = this.getSelectedRule();
        if (rule == null) {
            return;
        }
        Stack<DBASTModel.ASTNode> stack = rule.getRoots();
        for (int i = 0; i < stack.size(); ++i) {
            DBASTModel.ASTNode aSTNode = (DBASTModel.ASTNode)stack.get(i);
            DBTreeNode dBTreeNode = aSTNode.findNodeWithToken(token);
            if (dBTreeNode == null) continue;
            this.rootsTableView.getTable().setSelectedRow(i);
            this.treePanel.selectNode(dBTreeNode);
            break;
        }
    }

    public void selectLastRule() {
        this.rulesTableView.getTable().selectLastRow();
    }

    public void selectLastRootNode() {
        this.rootsTableView.getTable().selectLastRow();
    }

    public DBASTModel.Rule getSelectedRule() {
        int n = this.rulesTableView.getTable().getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.model.getRuleAtIndex(n);
    }

    public DBASTModel.ASTNode getRootAtIndex(int n) {
        return this.getSelectedRule().getRootAtIndex(n);
    }

    public GView getGraphView() {
        return this.treePanel.getGraphView();
    }

    public void tableSelectionChanged(XJTable xJTable, int n) {
        if (xJTable == this.rulesTableView.getTable()) {
            this.rootsModelChanged();
        } else if (xJTable == this.rootsTableView.getTable()) {
            this.updateTreePanel();
        }
    }

    public void awTreeDidSelectTreeNode(TreeNode treeNode, boolean bl) {
        DBASTModel.ASTNode aSTNode = (DBASTModel.ASTNode)treeNode;
        System.out.println("n=" + aSTNode);
        this.debugger.selectToken(aSTNode.token, aSTNode.token.getLine(), aSTNode.token.getCharPositionInLine());
    }

    public JPopupMenu awTreeGetContextualMenu() {
        return this.debugger.treeGetContextualMenu();
    }

    public class RootsTableModel
    extends DefaultTableModel {
        public int getRowCount() {
            if (DBASTPanel.this == null) {
                return 0;
            }
            DBASTModel.Rule rule = DBASTPanel.this.getSelectedRule();
            if (rule == null) {
                return 0;
            }
            return rule.roots.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "Root";
        }

        public Object getValueAt(int n, int n2) {
            return "r" + n;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    public class RulesTableModel
    extends DefaultTableModel {
        public int getRowCount() {
            if (DBASTPanel.this == null) {
                return 0;
            }
            if (DBASTPanel.this.model == null) {
                return 0;
            }
            return DBASTPanel.this.model.getRuleCount();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "Rule";
        }

        public Object getValueAt(int n, int n2) {
            return DBASTPanel.this.model.getRuleAtIndex((int)n).name;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

