/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.tree.DBASTModelListener;
import org.antlr.works.debugger.tree.DBTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBASTModel {
    public Stack<Rule> rules = new Stack();
    public Map<Integer, ASTNode> nodesMap = new HashMap<Integer, ASTNode>();
    public List<DBASTModelListener> listeners = new ArrayList<DBASTModelListener>();
    private Debugger debugger;

    public DBASTModel(Debugger debugger) {
        this.debugger = debugger;
    }

    public void close() {
        this.debugger = null;
    }

    public void addListener(DBASTModelListener dBASTModelListener) {
        this.listeners.add(dBASTModelListener);
    }

    public void fireDataChanged() {
        for (DBASTModelListener dBASTModelListener : this.listeners) {
            dBASTModelListener.modelChanged(this);
        }
    }

    public void clear() {
        this.rules.clear();
        this.nodesMap.clear();
        this.fireDataChanged();
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public Rule getRuleAtIndex(int n) {
        if (n < 0 || n >= this.rules.size()) {
            return null;
        }
        return (Rule)this.rules.get(n);
    }

    public int getRootCount() {
        return this.getRoots().size();
    }

    public void pushRule(String string) {
        this.rules.push(new Rule(string, new Stack<ASTNode>()));
    }

    public void popRule() {
        if (this.rules.size() > 1) {
            this.rules.pop();
        }
    }

    public void pushRoot(ASTNode aSTNode) {
        this.getRoots().push(aSTNode);
    }

    public void replaceRoot(ASTNode aSTNode, ASTNode aSTNode2) {
        Stack<ASTNode> stack = this.getRoots();
        int n = stack.indexOf(aSTNode);
        stack.remove(n);
        stack.add(n, aSTNode2);
    }

    public void removeRoot(ASTNode aSTNode) {
        this.getRoots().remove(aSTNode);
    }

    public void nilNode(int n) {
        this.pushRoot(this.createNilTreeNode(n));
    }

    public void errorNode(int n, String string) {
        this.pushRoot(this.createTreeNode(n, new CommonToken(0, string)));
    }

    public void createNode(int n, Token token) {
        this.createTreeNode(n, token);
    }

    public void becomeRoot(int n, int n2) {
        ASTNode aSTNode = this.getTreeNode(n);
        ASTNode aSTNode2 = this.getTreeNode(n2);
        if (aSTNode == null) {
            this.debugger.warning(this, "[becomeRoot] New root node " + n + " not found, ignoring.");
            return;
        }
        if (aSTNode2 == null) {
            this.debugger.warning(this, "[becomeRoot] Old root node " + n2 + " not found, ignoring.");
            return;
        }
        aSTNode2.becomeParent(aSTNode);
        this.replaceRoot(aSTNode2, aSTNode);
    }

    public void addChild(int n, int n2) {
        ASTNode aSTNode = this.getTreeNode(n);
        ASTNode aSTNode2 = this.getTreeNode(n2);
        if (aSTNode == null) {
            this.debugger.warning(this, "[addChild] Root node " + n + " not found, ignoring.");
            return;
        }
        if (aSTNode2 == null) {
            this.debugger.warning(this, "[addChild] Child node " + n2 + " not found, ignoring.");
            return;
        }
        this.removeRoot(aSTNode2);
        aSTNode.addChild(aSTNode2);
    }

    protected ASTNode createNilTreeNode(int n) {
        ASTNode aSTNode = this.createTreeNode(n);
        aSTNode.nil = true;
        return aSTNode;
    }

    protected ASTNode createTreeNode(int n, Token token) {
        ASTNode aSTNode = this.createTreeNode(n);
        aSTNode.token = token;
        return aSTNode;
    }

    protected ASTNode createTreeNode(int n) {
        ASTNode aSTNode = new ASTNode(n);
        this.nodesMap.put(n, aSTNode);
        return aSTNode;
    }

    protected ASTNode getTreeNode(int n) {
        return this.nodesMap.get(n);
    }

    protected Stack<ASTNode> getRoots() {
        if (this.rules.isEmpty()) {
            return null;
        }
        return this.rules.peek().roots;
    }

    public class ASTNode
    extends DBTreeNode {
        public int id;
        public boolean nil = false;
        public ASTNode parentNode = null;

        public ASTNode(int n) {
            this.id = n;
            this.children = new Vector();
        }

        public void addChild(ASTNode aSTNode) {
            if (aSTNode.nil) {
                for (int i = 0; i < aSTNode.children.size(); ++i) {
                    ASTNode aSTNode2 = (ASTNode)aSTNode.children.get(i);
                    aSTNode2.parentNode = this;
                    this.children.add(aSTNode2);
                }
            } else {
                aSTNode.parentNode = this;
                this.children.add(aSTNode);
            }
        }

        public void removeChild(ASTNode aSTNode) {
            this.children.remove(aSTNode);
        }

        public void becomeParent(ASTNode aSTNode) {
            aSTNode.detach();
            if (this.parentNode != null) {
                this.parentNode.replaceChild(this, aSTNode);
            }
            aSTNode.addChild(this);
        }

        public void replaceChild(ASTNode aSTNode, ASTNode aSTNode2) {
            int n = this.children.indexOf(aSTNode);
            this.children.remove(n);
            if (aSTNode2.nil) {
                this.children.addAll(n, aSTNode2.children);
            } else {
                this.children.add(n, aSTNode2);
            }
        }

        public void detach() {
            if (this.parentNode != null) {
                this.parentNode.removeChild(this);
                this.parentNode = null;
            }
        }

        public String toString() {
            if (this.nil) {
                return "nil";
            }
            if (this.token == null) {
                return String.valueOf(this.id);
            }
            return this.token.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Rule {
        public String name;
        public Stack<ASTNode> roots;

        public Rule(String string, Stack<ASTNode> stack) {
            this.name = string;
            this.roots = stack;
        }

        public ASTNode getRootAtIndex(int n) {
            return (ASTNode)this.roots.get(n);
        }

        public Stack<ASTNode> getRoots() {
            return this.roots;
        }
    }
}

