/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tivo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.RemoteDebugEventSocketListener;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.events.DBEventConsumeHiddenToken;
import org.antlr.works.debugger.events.DBEventConsumeToken;
import org.antlr.works.debugger.events.DBEventEnterRule;
import org.antlr.works.debugger.events.DBEventExitRule;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.tivo.DBRecorderEventListener;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.NumberSet;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJUtils;

public class DBRecorder
implements Runnable,
XJDialogProgressDelegate {
    public static final int STATUS_STOPPED = 0;
    public static final int STATUS_STOPPING = 1;
    public static final int STATUS_LAUNCHING = 2;
    public static final int STATUS_RUNNING = 3;
    public static final int STATUS_BREAK = 4;
    public static final int MAX_RETRY = 12;
    protected Debugger debugger;
    protected int status = 0;
    protected boolean cancelled;
    protected String address;
    protected int port;
    protected ArrayList<DBEvent> events;
    protected int position;
    protected NumberSet breakEvents = new NumberSet();
    protected int stoppedOnEvent = -1;
    protected boolean ignoreBreakpoints = false;
    protected StepOver stepOver = new StepOver();
    protected int lastTokenIndexEventNumber;
    protected int currentTokenIndexEventNumber;
    protected int currentTokenIndex;
    protected DBRecorderEventListener eventListener;
    protected RemoteDebugEventSocketListener listener;
    protected XJDialogProgress progress;
    protected boolean debuggerReceivedTerminateEvent;
    protected boolean remoteParserStateWarned = false;

    public DBRecorder(Debugger debugger) {
        this.debugger = debugger;
        this.reset();
    }

    public void close() {
        this.debugger = null;
    }

    public void showProgress() {
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.debugger.getWindowComponent());
        }
        this.progress.setInfo("Connecting...");
        this.progress.setIndeterminate(true);
        this.progress.setDelegate(this);
        this.progress.display();
    }

    public void hideProgress() {
        this.progress.close();
    }

    public synchronized boolean isRunning() {
        return this.status == 3;
    }

    public synchronized boolean isAlive() {
        return this.status == 3 || this.status == 4;
    }

    public synchronized void reset() {
        if (this.events == null) {
            this.events = new ArrayList();
        } else {
            this.events.clear();
        }
        this.position = -1;
        this.currentTokenIndex = -1;
        this.remoteParserStateWarned = false;
    }

    public synchronized DBEvent getEvent() {
        if (this.position < 0 || this.position >= this.events.size()) {
            return null;
        }
        return this.events.get(this.position);
    }

    public synchronized DBEvent getLastEvent() {
        return this.events.get(this.events.size() - 1);
    }

    public synchronized List getCurrentEvents() {
        if (this.events.size() == 0) {
            return (List)this.events.clone();
        }
        int n = this.position + 1;
        if (n >= this.events.size()) {
            n = this.events.size();
        }
        return ((List)this.events.clone()).subList(0, n);
    }

    public void setPositionToEnd() {
        this.position = this.events.size() - 1;
    }

    public void setBreakEvents(Set set) {
        this.breakEvents.replaceAll(set);
    }

    public Set getBreakEvents() {
        return this.breakEvents;
    }

    public void setStoppedOnEvent(int n) {
        this.stoppedOnEvent = n;
    }

    public int getStoppedOnEvent() {
        return this.stoppedOnEvent;
    }

    public void setIgnoreBreakpoints(boolean bl) {
        this.ignoreBreakpoints = bl;
    }

    public boolean ignoreBreakpoints() {
        return this.ignoreBreakpoints;
    }

    public void queryGrammarBreakpoints() {
        this.debugger.queryGrammarBreakpoints();
    }

    public boolean isOnBreakEvent() {
        int n = this.getOnBreakEvent();
        if (n != -1) {
            this.setStoppedOnEvent(n);
            this.setStatus(4);
            return true;
        }
        return false;
    }

    public int getOnBreakEvent() {
        DBEvent dBEvent = this.getEvent();
        if (dBEvent == null) {
            return -1;
        }
        if (this.stepOver.isSteppingOver()) {
            if (this.stepOver.shouldStop(dBEvent)) {
                this.stepOver.endStepOver();
                return dBEvent.getEventType();
            }
            return -1;
        }
        if (dBEvent.getEventType() == 2) {
            return dBEvent.getEventType();
        }
        if (this.breakEvents.contains(0)) {
            return dBEvent.getEventType();
        }
        if (dBEvent.getEventType() == 4 && !this.ignoreBreakpoints() && this.debugger.isBreakpointAtLine(((DBEventLocation)dBEvent).line - 1)) {
            return dBEvent.getEventType();
        }
        if (dBEvent.getEventType() == 5 && !this.ignoreBreakpoints() && this.debugger.isBreakpointAtToken(((DBEventConsumeToken)dBEvent).token)) {
            return dBEvent.getEventType();
        }
        if (dBEvent.getEventType() == 5 && this.breakEvents.contains(5)) {
            return ((DBEventConsumeToken)dBEvent).token.getChannel() == 0 ? dBEvent.getEventType() : -1;
        }
        return this.breakEvents.contains(dBEvent.getEventType()) ? dBEvent.getEventType() : -1;
    }

    public synchronized void setStatus(int n) {
        if (this.status != n) {
            this.status = n;
            this.debugger.recorderStatusDidChange();
        }
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public boolean isAtBeginning() {
        return this.position == 0;
    }

    public boolean isAtEnd() {
        DBEvent dBEvent = this.getEvent();
        if (dBEvent == null) {
            return true;
        }
        return dBEvent.getEventType() == 3;
    }

    public void stepBackward(Set set) {
        this.setIgnoreBreakpoints(false);
        this.stepContinue(set);
        this.stepMove(-1);
        this.playEvents(true);
    }

    public void stepForward(Set set) {
        this.setIgnoreBreakpoints(false);
        this.stepContinue(set);
        if (this.stepMove(1)) {
            this.playEvents(false);
        } else if (this.debuggerReceivedTerminateEvent) {
            this.playEvents(false);
        } else {
            this.threadNotify();
        }
    }

    public void stepOver() {
        this.stepOver.beginStepOver();
        this.fastForward();
    }

    public void stepContinue(Set set) {
        this.setBreakEvents(set);
        this.queryGrammarBreakpoints();
        this.setStatus(3);
    }

    public boolean stepMove(int n) {
        DBEvent dBEvent;
        this.position += n;
        if (this.position < 0) {
            this.position = 0;
            return false;
        }
        if (this.position >= this.events.size()) {
            this.position = this.events.size() - 1;
            return false;
        }
        while ((dBEvent = this.getEvent()) != null && !this.isOnBreakEvent()) {
            this.position += n;
        }
        if (dBEvent == null) {
            this.position -= n;
        }
        return dBEvent != null;
    }

    public void goToStart() {
        this.position = 0;
        this.setIgnoreBreakpoints(false);
        this.playEvents(true);
    }

    public void goToEnd() {
        this.setIgnoreBreakpoints(true);
        this.stepContinue(new NumberSet(3));
        if (this.stepMove(1)) {
            this.playEvents(false);
        } else {
            this.threadNotify();
        }
    }

    public void fastForward() {
        this.stepForward(new NumberSet(3));
    }

    public void connect(String string, int n) {
        this.address = string;
        this.port = n;
        new Thread(this).start();
    }

    public void run() {
        this.eventListener = new DBRecorderEventListener(this);
        this.cancelled = false;
        boolean bl = false;
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        long l2 = AWPrefs.getDebugLaunchTimeout() * 1000;
        while (System.currentTimeMillis() - l < l2 && !this.cancelled) {
            this.listener = null;
            try {
                this.listener = new RemoteDebugEventSocketListener(this.eventListener, this.address, this.port);
            }
            catch (IOException iOException) {
                this.listener = null;
            }
            if (this.listener != null) {
                bl = true;
                break;
            }
            if (System.currentTimeMillis() - l >= 2L && !bl2) {
                this.showProgress();
                bl2 = true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (bl2) {
            this.hideProgress();
        }
        if (this.cancelled) {
            this.setStatus(0);
            this.connectionCancelled();
        } else if (!bl) {
            this.setStatus(0);
            this.connectionFailed();
        } else {
            this.setStatus(2);
            this.debuggerReceivedTerminateEvent = false;
            this.reset();
            this.listener.start();
            this.connectionSuccess();
        }
    }

    public void connectionSuccess() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBRecorder.this.debugger.connectionSuccess();
            }
        });
    }

    public void connectionFailed() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBRecorder.this.debugger.connectionFailed();
            }
        });
    }

    public void connectionCancelled() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBRecorder.this.debugger.connectionCancelled();
            }
        });
    }

    public synchronized void requestStop() {
        this.setStatus(1);
        this.threadNotify();
        if (this.debuggerReceivedTerminateEvent) {
            this.stop();
        }
    }

    public void stop() {
        if (this.debugger == null) {
            return;
        }
        this.setStatus(0);
        this.debugger.recorderDidStop();
    }

    public void checkRemoteParserHeaders() {
        String string;
        String string2 = this.debugger.getGrammar().getFileName();
        if (!string2.equals(string = XJUtils.getLastPathComponent(this.listener.grammarFileName))) {
            String string3 = "Warning: the grammar used by the remote parser is not the same (" + string + ").";
            XJAlert.display(this.debugger.getWindowComponent(), "Grammar Mismatch", string3);
        }
    }

    public boolean checkRemoteParserState() {
        if (this.remoteParserStateWarned) {
            return false;
        }
        if (this.listener.tokenIndexesAreInvalid()) {
            this.remoteParserStateWarned = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = "Invalid token indexes (current index is " + DBRecorder.this.currentTokenIndex + " at event " + DBRecorder.this.currentTokenIndexEventNumber + " while the same index was used at event " + DBRecorder.this.lastTokenIndexEventNumber + "). Make sure that the remote parser implements the getTokenIndex() method of Token. The indexes must be unique for each consumed token.";
                    XJAlert.display(DBRecorder.this.debugger.getWindowComponent(), "Invalid Token Indexes", string);
                }
            });
            return true;
        }
        return false;
    }

    public void recordIndexes(DBEvent dBEvent) {
        DBEvent dBEvent2;
        Token token = null;
        if (dBEvent instanceof DBEventConsumeToken) {
            dBEvent2 = (DBEventConsumeToken)dBEvent;
            token = dBEvent2.token;
        }
        if (dBEvent instanceof DBEventConsumeHiddenToken) {
            dBEvent2 = (DBEventConsumeHiddenToken)dBEvent;
            token = ((DBEventConsumeHiddenToken)dBEvent2).token;
        }
        if (token != null) {
            this.lastTokenIndexEventNumber = this.currentTokenIndexEventNumber;
            this.currentTokenIndexEventNumber = this.events.size() - 1;
            this.currentTokenIndex = token.getTokenIndex();
        }
    }

    public synchronized void listenerEvent(DBEvent dBEvent) {
        this.events.add(dBEvent);
        this.recordIndexes(dBEvent);
        this.setPositionToEnd();
        switch (this.getStatus()) {
            case 2: {
                this.setStatus(3);
                break;
            }
            case 1: {
                if (dBEvent.getEventType() != 3 && !this.debuggerReceivedTerminateEvent) break;
                this.stop();
            }
        }
        if (this.isRunning()) {
            switch (dBEvent.getEventType()) {
                case 3: {
                    this.setStoppedOnEvent(3);
                    this.breaksOnEvent(false);
                    this.debuggerReceivedTerminateEvent = true;
                    break;
                }
                case 2: {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DBRecorder.this.checkRemoteParserHeaders();
                        }
                    });
                    this.setStoppedOnEvent(2);
                    this.breaksOnEvent(true);
                    break;
                }
                default: {
                    if (!this.checkRemoteParserState() && !this.isOnBreakEvent()) break;
                    this.breaksOnEvent(true);
                }
            }
        }
    }

    public synchronized void threadNotify() {
        this.notify();
    }

    public synchronized void threadWait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            this.debugger.getConsole().println("recorderThreadBreaksOnEvent: interrupted", 1);
        }
    }

    public synchronized void breaksOnEvent(boolean bl) {
        this.setStatus(4);
        this.playEvents(false);
        if (bl) {
            this.threadWait();
        }
    }

    protected synchronized void playEvents(boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new PlayEventRunnable(bl));
        } else {
            this.debugger.playEvents(this.getCurrentEvents(), bl);
        }
    }

    public void dialogDidCancel() {
        this.cancelled = true;
    }

    public class PlayEventRunnable
    implements Runnable {
        public boolean reset;

        public PlayEventRunnable(boolean bl) {
            this.reset = bl;
        }

        public void run() {
            DBRecorder.this.playEvents(this.reset);
        }
    }

    public class StepOver {
        public static final int MODE_DISABLED = 0;
        public static final int MODE_WAIT_ENTER_RULE = 1;
        public static final int MODE_WAIT_EXIT_RULE = 2;
        public static final int MODE_WAIT_LOCATION = 3;
        public int mode = 0;
        public int nested;
        public String ruleName;

        public void beginStepOver() {
            this.mode = 1;
        }

        public void endStepOver() {
            this.mode = 0;
        }

        public boolean isSteppingOver() {
            return this.mode != 0;
        }

        public boolean shouldStop(DBEvent dBEvent) {
            switch (this.mode) {
                case 1: {
                    if (!(dBEvent instanceof DBEventEnterRule)) break;
                    DBEventEnterRule dBEventEnterRule = (DBEventEnterRule)dBEvent;
                    this.ruleName = dBEventEnterRule.name;
                    this.mode = 2;
                    this.nested = 0;
                    break;
                }
                case 2: {
                    if (dBEvent instanceof DBEventEnterRule) {
                        DBEventEnterRule dBEventEnterRule = (DBEventEnterRule)dBEvent;
                        if (!dBEventEnterRule.name.equals(this.ruleName)) break;
                        ++this.nested;
                        break;
                    }
                    if (!(dBEvent instanceof DBEventExitRule)) break;
                    DBEventExitRule dBEventExitRule = (DBEventExitRule)dBEvent;
                    if (!dBEventExitRule.name.equals(this.ruleName)) break;
                    if (this.nested == 0) {
                        this.mode = 3;
                        break;
                    }
                    --this.nested;
                    break;
                }
                case 3: {
                    if (!(dBEvent instanceof DBEventLocation)) break;
                    return true;
                }
            }
            return false;
        }
    }
}

