/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tivo;

import java.util.List;
import java.util.Stack;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.events.DBEventAddChild;
import org.antlr.works.debugger.events.DBEventBecomeRoot;
import org.antlr.works.debugger.events.DBEventBeginBacktrack;
import org.antlr.works.debugger.events.DBEventConsumeHiddenToken;
import org.antlr.works.debugger.events.DBEventConsumeToken;
import org.antlr.works.debugger.events.DBEventCreateNode;
import org.antlr.works.debugger.events.DBEventEndBacktrack;
import org.antlr.works.debugger.events.DBEventEnterAlt;
import org.antlr.works.debugger.events.DBEventEnterDecision;
import org.antlr.works.debugger.events.DBEventEnterRule;
import org.antlr.works.debugger.events.DBEventEnterSubRule;
import org.antlr.works.debugger.events.DBEventErrorNode;
import org.antlr.works.debugger.events.DBEventExitDecision;
import org.antlr.works.debugger.events.DBEventExitRule;
import org.antlr.works.debugger.events.DBEventExitSubRule;
import org.antlr.works.debugger.events.DBEventLT;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.events.DBEventMark;
import org.antlr.works.debugger.events.DBEventNilNode;
import org.antlr.works.debugger.events.DBEventRecognitionException;
import org.antlr.works.debugger.events.DBEventRewind;
import org.antlr.works.debugger.events.DBEventSetTokenBoundaries;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.tivo.DBPlayerContextInfo;

public class DBPlayer {
    protected Debugger debugger;
    protected DBInputProcessor processor;
    protected DBPlayerContextInfo contextInfo;
    protected Stack<Integer> markStack;
    protected int resyncing = 0;
    protected int eventPlayedCount = 0;
    protected int lastLocationLine;
    protected int lastLocationPos;

    public DBPlayer(Debugger debugger) {
        this.debugger = debugger;
        this.contextInfo = new DBPlayerContextInfo();
        this.markStack = new Stack();
    }

    public void close() {
        this.debugger = null;
    }

    public void setInputBuffer(DBInputProcessor dBInputProcessor) {
        this.processor = dBInputProcessor;
    }

    public DBPlayerContextInfo getContextInfo() {
        return this.contextInfo;
    }

    public synchronized void resetPlayEvents(boolean bl) {
        this.debugger.resetGUI();
        if (bl) {
            this.processor.reset();
        } else {
            this.processor.rewindAll();
        }
        this.contextInfo.clear();
        this.markStack.clear();
        this.resyncing = 0;
        this.eventPlayedCount = 0;
    }

    public void playEvents(List list, boolean bl) {
        if (bl) {
            this.resetPlayEvents(false);
        }
        for (int i = this.eventPlayedCount; i < list.size(); ++i) {
            DBEvent dBEvent = (DBEvent)list.get(i);
            try {
                this.playEvent(dBEvent);
            }
            catch (Exception exception) {
                this.debugger.getConsole().print(exception);
            }
            this.debugger.addEvent(dBEvent, this.contextInfo);
            if (i != list.size() - 1) continue;
            this.playLocation();
        }
        this.eventPlayedCount = list.size();
    }

    public void playEvent(DBEvent dBEvent) {
        switch (dBEvent.getEventType()) {
            case 8: {
                this.playEnterRule((DBEventEnterRule)dBEvent);
                break;
            }
            case 9: {
                this.playExitRule((DBEventExitRule)dBEvent);
                break;
            }
            case 10: {
                this.playEnterSubrule((DBEventEnterSubRule)dBEvent);
                break;
            }
            case 11: {
                this.playExitSubrule((DBEventExitSubRule)dBEvent);
                break;
            }
            case 12: {
                this.playEnterDecision((DBEventEnterDecision)dBEvent);
                break;
            }
            case 13: {
                this.playExitDecision((DBEventExitDecision)dBEvent);
                break;
            }
            case 14: {
                this.playEnterAlt((DBEventEnterAlt)dBEvent);
                break;
            }
            case 7: {
                this.playLT((DBEventLT)dBEvent);
                break;
            }
            case 5: {
                this.playConsumeToken((DBEventConsumeToken)dBEvent);
                break;
            }
            case 6: {
                this.playConsumeToken((DBEventConsumeHiddenToken)dBEvent);
                break;
            }
            case 4: {
                this.playLocation((DBEventLocation)dBEvent);
                break;
            }
            case 15: {
                this.playMark((DBEventMark)dBEvent);
                break;
            }
            case 16: {
                this.playRewind((DBEventRewind)dBEvent);
                break;
            }
            case 17: {
                this.playBeginBacktrack((DBEventBeginBacktrack)dBEvent);
                break;
            }
            case 18: {
                this.playEndBacktrack((DBEventEndBacktrack)dBEvent);
                break;
            }
            case 26: {
                this.playRecognitionException((DBEventRecognitionException)dBEvent);
                break;
            }
            case 19: {
                this.playBeginResync();
                break;
            }
            case 20: {
                this.playEndResync();
                break;
            }
            case 21: {
                this.playNilNode((DBEventNilNode)dBEvent);
                break;
            }
            case 27: {
                this.playErrorNode((DBEventErrorNode)dBEvent);
                break;
            }
            case 22: {
                this.playCreateNode((DBEventCreateNode)dBEvent);
                break;
            }
            case 23: {
                this.playBecomeRoot((DBEventBecomeRoot)dBEvent);
                break;
            }
            case 24: {
                this.playAddChild((DBEventAddChild)dBEvent);
                break;
            }
            case 25: {
                this.playSetTokenBoundaries((DBEventSetTokenBoundaries)dBEvent);
                break;
            }
        }
    }

    public void playEnterRule(DBEventEnterRule dBEventEnterRule) {
        this.debugger.playerPushRule(dBEventEnterRule.name);
        this.processor.removeAllLT();
    }

    public void playExitRule(DBEventExitRule dBEventExitRule) {
        this.debugger.playerPopRule(dBEventExitRule.name);
        this.processor.removeAllLT();
    }

    public void playEnterSubrule(DBEventEnterSubRule dBEventEnterSubRule) {
        this.contextInfo.enterSubrule(dBEventEnterSubRule.decision);
        this.processor.removeAllLT();
    }

    public void playExitSubrule(DBEventExitSubRule dBEventExitSubRule) {
        this.contextInfo.exitSubrule();
        this.processor.removeAllLT();
    }

    public void playEnterDecision(DBEventEnterDecision dBEventEnterDecision) {
        this.contextInfo.enterDecision(dBEventEnterDecision.decision);
        this.processor.removeAllLT();
    }

    public void playExitDecision(DBEventExitDecision dBEventExitDecision) {
        this.contextInfo.exitDecision();
        this.processor.removeAllLT();
    }

    public void playEnterAlt(DBEventEnterAlt dBEventEnterAlt) {
    }

    public void playLT(DBEventLT dBEventLT) {
        if (dBEventLT.token.getType() == -1) {
            return;
        }
        if (dBEventLT.index < 0) {
            return;
        }
        if (this.contextInfo.getDecision() == -1) {
            return;
        }
        this.processor.LT(dBEventLT.token);
    }

    public void playConsumeToken(DBEventConsumeToken dBEventConsumeToken) {
        this.playConsumeToken(dBEventConsumeToken.token, false);
    }

    public void playConsumeToken(DBEventConsumeHiddenToken dBEventConsumeHiddenToken) {
        this.playConsumeToken(dBEventConsumeHiddenToken.token, true);
    }

    public void playConsumeToken(Token token, boolean bl) {
        if (this.resyncing > 0) {
            this.processor.consumeToken(token, 3);
            return;
        }
        if (this.contextInfo.isBacktracking()) {
            this.debugger.playerConsumeToken(token);
            return;
        }
        if (!this.markStack.isEmpty()) {
            return;
        }
        if (!bl) {
            this.debugger.playerConsumeToken(token);
        }
        this.processor.consumeToken(token, bl ? 2 : 1);
    }

    public void playLocation(DBEventLocation dBEventLocation) {
        this.lastLocationLine = dBEventLocation.line;
        this.lastLocationPos = dBEventLocation.pos;
        this.debugger.playerSetLocation(this.lastLocationLine, this.lastLocationPos);
        this.processor.setLocation(this.lastLocationLine, this.lastLocationPos);
    }

    public void playLocation() {
        this.debugger.resetMarkLocationInGrammar();
        int n = this.debugger.computeAbsoluteGrammarIndex(this.lastLocationLine, this.lastLocationPos);
        if (n < 0) {
            return;
        }
        this.debugger.markLocationInGrammar(n);
    }

    public void playMark(DBEventMark dBEventMark) {
        this.contextInfo.mark(dBEventMark.id);
        this.markStack.push(this.processor.getCurrentTokenIndex());
    }

    public void playRewind(DBEventRewind dBEventRewind) {
        this.processor.rewind(this.markStack.peek());
        if (!dBEventRewind.rewindToLastMark()) {
            this.markStack.pop();
            this.contextInfo.rewind();
        }
    }

    public void playBeginBacktrack(DBEventBeginBacktrack dBEventBeginBacktrack) {
        this.contextInfo.beginBacktrack(dBEventBeginBacktrack.level);
        this.debugger.playerBeginBacktrack(dBEventBeginBacktrack.level);
    }

    public void playEndBacktrack(DBEventEndBacktrack dBEventEndBacktrack) {
        this.contextInfo.endBacktrack();
        this.debugger.playerEndBacktrack(dBEventEndBacktrack.level, dBEventEndBacktrack.successful);
    }

    public void playRecognitionException(DBEventRecognitionException dBEventRecognitionException) {
        this.debugger.playerRecognitionException(dBEventRecognitionException.e);
    }

    public void playBeginResync() {
        ++this.resyncing;
    }

    public void playEndResync() {
        --this.resyncing;
    }

    public void playNilNode(DBEventNilNode dBEventNilNode) {
        this.debugger.playerNilNode(dBEventNilNode.id);
    }

    public void playErrorNode(DBEventErrorNode dBEventErrorNode) {
        this.debugger.playerErrorNode(dBEventErrorNode.id, dBEventErrorNode.text);
    }

    public void playCreateNode(DBEventCreateNode dBEventCreateNode) {
        if (dBEventCreateNode.tokenIndex == -1) {
            this.debugger.playerCreateNode(dBEventCreateNode.id, dBEventCreateNode.text, dBEventCreateNode.type);
        } else {
            DBInputTextTokenInfo dBInputTextTokenInfo = this.processor.getTokenInfoAtTokenIndex(dBEventCreateNode.tokenIndex);
            if (dBInputTextTokenInfo == null) {
                this.debugger.getConsole().println("No token info for token index " + dBEventCreateNode.tokenIndex);
            } else {
                this.debugger.playerCreateNode(dBEventCreateNode.id, dBInputTextTokenInfo.token);
            }
        }
    }

    public void playBecomeRoot(DBEventBecomeRoot dBEventBecomeRoot) {
        this.debugger.playerBecomeRoot(dBEventBecomeRoot.newRootID, dBEventBecomeRoot.oldRootID);
    }

    public void playAddChild(DBEventAddChild dBEventAddChild) {
        this.debugger.playerAddChild(dBEventAddChild.rootID, dBEventAddChild.childID);
    }

    public void playSetTokenBoundaries(DBEventSetTokenBoundaries dBEventSetTokenBoundaries) {
        this.debugger.playerSetTokenBoundaries(dBEventSetTokenBoundaries.id, dBEventSetTokenBoundaries.startIndex, dBEventSetTokenBoundaries.stopIndex);
    }
}

