/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.swing.DetachablePanel;
import org.antlr.xjlib.appkit.swing.XJTable;
import org.antlr.xjlib.appkit.swing.XJTableView;

public class DBStackPanel
extends DetachablePanel {
    public static final int INFO_COLUMN_COUNT = 0;
    public static final int INFO_COLUMN_RULE = 1;
    private XJTableView infoTableView;
    private RuleTableDataModel ruleTableDataModel;
    private Stack<String> rules = new Stack();

    public DBStackPanel(Debugger debugger) {
        super("Stack", debugger);
        this.ruleTableDataModel = new RuleTableDataModel();
        this.infoTableView = new XJTableView();
        this.setInfoTableModel(this.infoTableView.getTable(), this.ruleTableDataModel);
        this.mainPanel.add((Component)this.infoTableView, "Center");
        this.infoTableView.autoresizeColumns();
    }

    public void setInfoTableModel(XJTable xJTable, AbstractTableModel abstractTableModel) {
        xJTable.setModel(abstractTableModel);
        this.selectLastInfoTableItem();
    }

    public void selectLastInfoTableItem() {
        this.infoTableView.scrollToLastRow();
    }

    public void clear() {
        this.rules.clear();
        this.ruleTableDataModel.clear();
    }

    public void updateOnBreakEvent() {
        this.ruleTableDataModel.update();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBStackPanel.this.selectLastInfoTableItem();
            }
        });
    }

    public void pushRule(String string) {
        this.rules.push(string);
        this.ruleTableDataModel.add(string);
    }

    public void popRule() {
        this.ruleTableDataModel.remove(this.rules.peek());
        this.rules.pop();
    }

    public class RuleTableDataModel
    extends AbstractTableModel {
        protected List<Object> rules = new ArrayList<Object>();

        public void add(Object object) {
            this.rules.add(object);
        }

        public void remove(Object object) {
            this.rules.remove(object);
        }

        public void clear() {
            this.rules.clear();
            this.fireTableDataChanged();
            DBStackPanel.this.infoTableView.autoresizeColumns();
        }

        public void update() {
            this.fireTableDataChanged();
            DBStackPanel.this.infoTableView.autoresizeColumns();
        }

        public int getRowCount() {
            return this.rules.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return "Rule";
                }
            }
            return super.getColumnName(n);
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return String.valueOf(n);
                }
                case 1: {
                    return this.rules.get(n);
                }
            }
            return null;
        }
    }
}

