/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.Token;
import org.antlr.works.awtree.AWTreePanel;
import org.antlr.works.awtree.AWTreePanelDelegate;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputProcessorTree;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.panels.DBInputConcretePanel;

public class DBInputTreePanel
implements DBInputConcretePanel,
AWTreePanelDelegate {
    public Debugger debugger;
    public AWTreePanel treePanel;
    public DBInputProcessorTree processorTree;

    public DBInputTreePanel(Debugger debugger) {
        this.debugger = debugger;
        this.treePanel = new AWTreePanel(new DefaultTreeModel(null));
        this.treePanel.setRootVisible(true);
        this.treePanel.setDelegate(this);
        this.processorTree = new DBInputProcessorTree(this.treePanel, debugger);
    }

    public void close() {
        this.treePanel.setDelegate(null);
        this.debugger = null;
        this.processorTree.close();
    }

    public void stop() {
    }

    public JComponent getComponent() {
        return this.treePanel;
    }

    public DBInputProcessor getInputProcessor() {
        return this.processorTree;
    }

    public void toggleInputTextTokensBox() {
    }

    public boolean isInputTokensBoxVisible() {
        return false;
    }

    public boolean isBreakpointAtToken(Token token) {
        return this.processorTree.isBreakpointAtToken(token);
    }

    public void selectToken(Token token) {
    }

    public DBInputTextTokenInfo getTokenInfoForToken(Token token) {
        return this.processorTree.getTokenInfoForToken(token);
    }

    public void updateOnBreakEvent() {
        this.processorTree.updateTreePanel();
    }

    public void awTreeDidSelectTreeNode(TreeNode treeNode, boolean bl) {
        DBInputProcessorTree.InputTreeNode inputTreeNode = (DBInputProcessorTree.InputTreeNode)treeNode;
        if (bl) {
            inputTreeNode.toggleBreakpoint();
        }
        this.debugger.selectToken(inputTreeNode.getToken(), inputTreeNode.getLine(), inputTreeNode.getPosition());
    }

    public JPopupMenu awTreeGetContextualMenu() {
        return this.debugger.treeGetContextualMenu();
    }
}

