/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.Component;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.panels.DBInputConcretePanel;
import org.antlr.works.debugger.panels.DBInputTokenPanel;
import org.antlr.works.debugger.panels.DBInputTreePanel;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.swing.DetachablePanel;

public class DBInputPanel
extends DetachablePanel {
    protected Debugger debugger;
    protected DBInputTokenPanel inputTokenPanel;
    protected DBInputTreePanel inputTreePanel;
    protected DBInputConcretePanel currentPanel;

    public DBInputPanel(Debugger debugger) {
        super("Input", debugger);
        this.debugger = debugger;
        this.inputTokenPanel = new DBInputTokenPanel(debugger);
        this.inputTreePanel = new DBInputTreePanel(debugger);
        this.setCurrentPanel(this.inputTokenPanel);
    }

    public void setCurrentPanel(DBInputConcretePanel dBInputConcretePanel) {
        this.currentPanel = dBInputConcretePanel;
        if (this.mainPanel.getComponentCount() > 0) {
            this.mainPanel.remove(0);
        }
        this.mainPanel.add((Component)this.currentPanel.getComponent(), "Center");
    }

    public void prepareForGrammar(EngineGrammar engineGrammar) {
        if (engineGrammar.isTreeParserGrammar()) {
            this.setCurrentPanel(this.inputTreePanel);
        } else {
            this.setCurrentPanel(this.inputTokenPanel);
        }
    }

    public void close() {
        super.close();
        this.inputTokenPanel.close();
        this.inputTreePanel.close();
        this.debugger = null;
        this.currentPanel.close();
    }

    public DBInputProcessor getInputBuffer() {
        return this.currentPanel.getInputProcessor();
    }

    public void toggleInputTokensBox() {
        this.currentPanel.toggleInputTextTokensBox();
    }

    public boolean isInputTokensBoxVisible() {
        return this.currentPanel.isInputTokensBoxVisible();
    }

    public void updateOnBreakEvent() {
        this.currentPanel.updateOnBreakEvent();
    }

    public boolean isBreakpointAtToken(Token token) {
        return this.currentPanel.isBreakpointAtToken(token);
    }

    public void stop() {
        this.currentPanel.stop();
    }

    public void selectToken(Token token) {
        this.currentPanel.selectToken(token);
    }

    public DBInputTextTokenInfo getTokenInfoForToken(Token token) {
        return this.currentPanel.getTokenInfoForToken(token);
    }
}

