/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.tivo.DBPlayerContextInfo;
import org.antlr.works.swing.DetachablePanel;
import org.antlr.xjlib.appkit.swing.XJTable;
import org.antlr.xjlib.appkit.swing.XJTableView;

public class DBEventsPanel
extends DetachablePanel {
    public static final int INFO_COLUMN_COUNT = 0;
    public static final int INFO_COLUMN_EVENT = 1;
    public static final int INFO_COLUMN_SUBRULE = 2;
    public static final int INFO_COLUMN_DECISION = 3;
    public static final int INFO_COLUMN_MARK = 4;
    public static final int INFO_COLUMN_BACKTRACK = 5;
    protected XJTableView infoTableView;
    protected EventTableDataModel eventTableDataModel = new EventTableDataModel();

    public DBEventsPanel(Debugger debugger) {
        super("Events", debugger);
        this.infoTableView = new XJTableView();
        this.infoTableView.setFocusable(true);
        this.setInfoTableModel(this.infoTableView.getTable(), this.eventTableDataModel);
        this.mainPanel.add((Component)this.infoTableView, "Center");
        this.infoTableView.autoresizeColumns();
    }

    public void setInfoTableModel(XJTable xJTable, AbstractTableModel abstractTableModel) {
        xJTable.setModel(abstractTableModel);
        this.selectLastInfoTableItem();
    }

    public void selectLastInfoTableItem() {
        this.infoTableView.scrollToLastRow();
    }

    public int getNumberOfEvents() {
        return this.eventTableDataModel.getRowCount();
    }

    public void clear() {
        this.eventTableDataModel.clear();
    }

    public void updateOnBreakEvent() {
        this.eventTableDataModel.update();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBEventsPanel.this.selectLastInfoTableItem();
            }
        });
    }

    public void addEvent(DBEvent dBEvent, DBPlayerContextInfo dBPlayerContextInfo) {
        this.eventTableDataModel.add(dBEvent, dBPlayerContextInfo);
    }

    public String getEventsAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.eventTableDataModel.getHeadersAsString());
        stringBuffer.append("\n");
        List<EventTableDataModel.EventInfo> list = this.eventTableDataModel.events;
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(i);
            stringBuffer.append(":\t");
            stringBuffer.append(list.get(i).toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public class EventTableDataModel
    extends AbstractTableModel {
        protected List<EventInfo> events = new ArrayList<EventInfo>();

        public void add(DBEvent dBEvent, DBPlayerContextInfo dBPlayerContextInfo) {
            this.events.add(new EventInfo(dBEvent, dBPlayerContextInfo));
        }

        public void clear() {
            this.events.clear();
            this.fireTableDataChanged();
            DBEventsPanel.this.infoTableView.autoresizeColumns();
        }

        public void update() {
            this.fireTableDataChanged();
            DBEventsPanel.this.infoTableView.autoresizeColumns();
        }

        public int getRowCount() {
            return this.events.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return "Event";
                }
                case 2: {
                    return "Subrule";
                }
                case 3: {
                    return "Decision";
                }
                case 4: {
                    return "Mark";
                }
                case 5: {
                    return "Backtrack";
                }
            }
            return super.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
            }
            return super.getColumnClass(n);
        }

        public Object getValueAt(int n, int n2) {
            EventInfo eventInfo = this.events.get(n);
            switch (n2) {
                case 0: {
                    return String.valueOf(n);
                }
                case 1: {
                    return eventInfo.event;
                }
                case 2: {
                    return eventInfo.getSubrule();
                }
                case 3: {
                    return eventInfo.getDecision();
                }
                case 4: {
                    return eventInfo.getMark();
                }
                case 5: {
                    return eventInfo.getBacktrack();
                }
            }
            return null;
        }

        public String getHeadersAsString() {
            return "#\tEvent\tSubrule\tDecision\tMark\tBacktrack";
        }

        public class EventInfo {
            public DBEvent event;
            public int subrule;
            public int decision;
            public int mark;
            public int backtrack;

            public EventInfo(DBEvent dBEvent, DBPlayerContextInfo dBPlayerContextInfo) {
                this.event = dBEvent;
                this.subrule = dBPlayerContextInfo.getSubrule();
                this.decision = dBPlayerContextInfo.getDecision();
                this.mark = dBPlayerContextInfo.getMark();
                this.backtrack = dBPlayerContextInfo.getBacktrack();
            }

            public Object getSubrule() {
                return this.subrule == -1 ? null : String.valueOf(this.subrule);
            }

            public Object getDecision() {
                return this.decision == -1 ? null : String.valueOf(this.decision);
            }

            public Object getMark() {
                return this.mark == -1 ? null : String.valueOf(this.mark);
            }

            public Object getBacktrack() {
                return this.backtrack == -1 ? null : String.valueOf(this.backtrack);
            }

            public String getTextForExport(int n) {
                if (n == -1) {
                    return "-";
                }
                return String.valueOf(n);
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.event.toString());
                stringBuffer.append("\t");
                stringBuffer.append(this.getTextForExport(this.subrule));
                stringBuffer.append("\t");
                stringBuffer.append(this.getTextForExport(this.decision));
                stringBuffer.append("\t");
                stringBuffer.append(this.getTextForExport(this.mark));
                stringBuffer.append("\t");
                stringBuffer.append(this.getTextForExport(this.backtrack));
                return stringBuffer.toString();
            }
        }
    }
}

