/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.tivo.DBPlayerContextInfo;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.swing.Toolbar;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.NumberSet;

public class DBControlPanel
extends JPanel {
    protected JButton stopButton;
    protected JButton goToStartButton;
    protected JButton goToEndButton;
    protected JButton fastForwardButton;
    protected JButton backButton;
    protected JButton forwardButton;
    protected JButton stepOverButton;
    protected JCheckBox breakAllButton;
    protected JCheckBox breakLocationButton;
    protected JCheckBox breakConsumeButton;
    protected JCheckBox breakLTButton;
    protected JCheckBox breakExceptionButton;
    protected JLabel infoLabel;
    protected Debugger debugger;

    public DBControlPanel(Debugger debugger) {
        super(new BorderLayout());
        this.debugger = debugger;
        Toolbar toolbar = Toolbar.createHorizontalToolbar();
        this.stopButton = this.createStopButton();
        toolbar.addElement(this.stopButton);
        toolbar.addGroupSeparator();
        this.goToStartButton = this.createGoToStartButton();
        toolbar.addElement(this.goToStartButton);
        this.backButton = this.createStepBackButton();
        toolbar.addElement(this.backButton);
        this.forwardButton = this.createStepForwardButton();
        toolbar.addElement(this.forwardButton);
        this.stepOverButton = this.createStepOverButton();
        toolbar.addElement(this.stepOverButton);
        this.fastForwardButton = this.createFastForwardButton();
        toolbar.addElement(this.fastForwardButton);
        this.goToEndButton = this.createGoToEndButton();
        toolbar.addElement(this.goToEndButton);
        toolbar.addGroupSeparator();
        this.createBreakEvents(toolbar);
        toolbar.addElement(Box.createHorizontalGlue());
        toolbar.addElement(this.createInfoLabelPanel());
        this.add((Component)toolbar, "Center");
    }

    public void close() {
        AWPrefs.getPreferences().unbindFromPreferences(this.breakAllButton, "PREF_DEBUG_BREAK_ALL");
        AWPrefs.getPreferences().unbindFromPreferences(this.breakLocationButton, "PREF_DEBUG_BREAK_LOCATION");
        AWPrefs.getPreferences().unbindFromPreferences(this.breakConsumeButton, "PREF_DEBUG_BREAK_CONSUME");
        AWPrefs.getPreferences().unbindFromPreferences(this.breakLTButton, "PREF_DEBUG_BREAK_LT");
        AWPrefs.getPreferences().unbindFromPreferences(this.breakExceptionButton, "PREF_DEBUG_BREAK_EXCEPTION");
        this.debugger = null;
    }

    public JButton createStopButton() {
        JButton jButton = new JButton(IconManager.shared().getIconStop());
        jButton.setToolTipText("Stop");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBControlPanel.this.debugger.debuggerStop(false);
                StatisticsAW.shared().recordEvent(140);
            }
        });
        return jButton;
    }

    public JButton createStepBackButton() {
        JButton jButton = new JButton(IconManager.shared().getIconStepBackward());
        jButton.setToolTipText("Step Back");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBControlPanel.this.debugger.getRecorder().stepBackward(DBControlPanel.this.getBreakEvent());
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(141);
            }
        });
        return jButton;
    }

    public JButton createStepForwardButton() {
        JButton jButton = new JButton(IconManager.shared().getIconStepForward());
        jButton.setToolTipText("Step Forward");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBControlPanel.this.debugger.getRecorder().stepForward(DBControlPanel.this.getBreakEvent());
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(142);
            }
        });
        return jButton;
    }

    public JButton createStepOverButton() {
        JButton jButton = new JButton(IconManager.shared().getIconStepOver());
        jButton.setToolTipText("Step Over");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBControlPanel.this.debugger.getRecorder().stepOver();
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(143);
            }
        });
        return jButton;
    }

    public JButton createGoToStartButton() {
        JButton jButton = new JButton(IconManager.shared().getIconGoToStart());
        jButton.setToolTipText("Go To Start");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBControlPanel.this.debugger.resetMarkLocationInGrammar();
                DBControlPanel.this.debugger.getRecorder().goToStart();
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(145);
            }
        });
        return jButton;
    }

    public JButton createGoToEndButton() {
        JButton jButton = new JButton(IconManager.shared().getIconGoToEnd());
        jButton.setToolTipText("Go To End");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBControlPanel.this.debugger.getRecorder().goToEnd();
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(146);
            }
        });
        return jButton;
    }

    public JButton createFastForwardButton() {
        JButton jButton = new JButton(IconManager.shared().getIconFastForward());
        jButton.setToolTipText("Fast forward");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBControlPanel.this.debugger.getRecorder().fastForward();
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(144);
            }
        });
        return jButton;
    }

    public void createBreakEvents(Toolbar toolbar) {
        toolbar.addElement(new JLabel("Break on:"));
        this.breakAllButton = this.createBreakButton("All");
        toolbar.addElement(this.breakAllButton);
        this.breakLocationButton = this.createBreakButton("Location");
        toolbar.addElement(this.breakLocationButton);
        this.breakConsumeButton = this.createBreakButton("Consume");
        toolbar.addElement(this.breakConsumeButton);
        this.breakLTButton = this.createBreakButton("LT");
        toolbar.addElement(this.breakLTButton);
        this.breakExceptionButton = this.createBreakButton("Exception");
        toolbar.addElement(this.breakExceptionButton);
        AWPrefs.getPreferences().bindToPreferences(this.breakAllButton, "PREF_DEBUG_BREAK_ALL", false);
        AWPrefs.getPreferences().bindToPreferences(this.breakLocationButton, "PREF_DEBUG_BREAK_LOCATION", false);
        AWPrefs.getPreferences().bindToPreferences(this.breakConsumeButton, "PREF_DEBUG_BREAK_CONSUME", true);
        AWPrefs.getPreferences().bindToPreferences(this.breakLTButton, "PREF_DEBUG_BREAK_LT", false);
        AWPrefs.getPreferences().bindToPreferences(this.breakExceptionButton, "PREF_DEBUG_BREAK_EXCEPTION", false);
    }

    public JCheckBox createBreakButton(String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setFocusable(false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DBControlPanel.this.getBreakEvent().isEmpty()) {
                    DBControlPanel.this.breakAllButton.setSelected(true);
                    AWPrefs.getPreferences().setBoolean("PREF_DEBUG_BREAK_ALL", true);
                }
            }
        });
        return jCheckBox;
    }

    public JComponent createInfoLabelPanel() {
        this.infoLabel = new JLabel();
        return this.infoLabel;
    }

    public Set getBreakEvent() {
        NumberSet numberSet = new NumberSet();
        if (this.breakAllButton.isSelected()) {
            numberSet.add(0);
        }
        if (this.breakLocationButton.isSelected()) {
            numberSet.add(4);
        }
        if (this.breakConsumeButton.isSelected()) {
            numberSet.add(5);
        }
        if (this.breakLTButton.isSelected()) {
            numberSet.add(7);
        }
        if (this.breakExceptionButton.isSelected()) {
            numberSet.add(26);
        }
        return numberSet;
    }

    public void updateStatusInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "-";
        switch (this.debugger.getRecorder().getStatus()) {
            case 0: {
                string = "Stopped";
                break;
            }
            case 1: {
                string = "Stopping";
                break;
            }
            case 2: {
                string = "Launching";
                break;
            }
            case 3: {
                string = "Running";
                break;
            }
            case 4: {
                string = "Break on " + DBEvent.getEventName(this.debugger.getRecorder().getStoppedOnEvent());
            }
        }
        stringBuffer.append(string);
        DBPlayerContextInfo dBPlayerContextInfo = this.debugger.getPlayer().getContextInfo();
        if (dBPlayerContextInfo.isBacktracking()) {
            stringBuffer.append(" (backtrack ");
            stringBuffer.append(dBPlayerContextInfo.getBacktrack());
            stringBuffer.append(")");
        }
        this.infoLabel.setText(stringBuffer.toString());
        this.updateInterface();
    }

    public void updateInterface() {
        this.stopButton.setEnabled(this.debugger.getRecorder().getStatus() != 0);
        boolean bl = this.debugger.getRecorder().isAlive();
        boolean bl2 = this.debugger.getRecorder().isAtBeginning();
        boolean bl3 = this.debugger.getRecorder().isAtEnd();
        this.backButton.setEnabled(bl && !bl2);
        this.forwardButton.setEnabled(bl && !bl3);
        this.stepOverButton.setEnabled(bl && !bl3);
        this.fastForwardButton.setEnabled(bl && !bl3);
        this.goToStartButton.setEnabled(bl && !bl2);
        this.goToEndButton.setEnabled(bl && !bl3);
    }

    public void updateInterfaceLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBControlPanel.this.updateInterface();
            }
        });
    }
}

