/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.local;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.antlr.works.IDE;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.DebuggerInputDialog;
import org.antlr.works.engine.EngineRuntime;
import org.antlr.works.generate.CodeGenerate;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.syntax.element.ElementBlock;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.utils.StreamWatcher;
import org.antlr.works.utils.StreamWatcherDelegate;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJUtils;

public class DBLocal
implements Runnable,
XJDialogProgressDelegate,
StreamWatcherDelegate {
    public static final String remoteParserClassName = "__Test__";
    public static final String parserGlueCodeTemplatePath = "org/antlr/works/debugger/local/";
    public static final String parserGlueCodeTemplateName = "DBParserGlueCode";
    public static final String ST_ATTR_IMPORT = "import";
    public static final String ST_ATTR_CLASSNAME = "class_name";
    public static final String ST_ATTR_INPUT_FILE = "input_file";
    public static final String ST_ATTR_JAVA_PARSER = "java_parser";
    public static final String ST_ATTR_JAVA_LEXER = "java_parser_lexer";
    public static final String ST_ATTR_START_SYMBOL = "start_symbol";
    public static final String ST_ATTR_DEBUG_PORT = "port";
    protected String outputFileDir;
    protected List<String> grammarGeneratedFiles;
    protected String fileRemoteParser;
    protected String fileRemoteParserInputTextFile;
    protected String startRule;
    protected String lastStartRule;
    protected Process remoteParserProcess;
    protected boolean cancelled;
    protected int options;
    protected CodeGenerate codeGenerator;
    protected Debugger debugger;
    protected int inputMode;
    protected int lastInputMode;
    protected String inputFile;
    protected String lastInputFile;
    protected String inputText;
    protected String rawInputText;
    protected XJDialogProgress progress;
    protected ErrorReporter error = new ErrorReporter();
    protected int debugPort = -1;
    protected boolean debugPortChanged = true;

    public DBLocal(Debugger debugger) {
        this.debugger = debugger;
        this.codeGenerator = new CodeGenerate(debugger.getProvider(), null);
    }

    public void close() {
        this.codeGenerator.close();
        this.codeGenerator = null;
        this.debugger = null;
    }

    public void setStartRule(String string) {
        this.startRule = string;
    }

    public String getStartRule() {
        return this.startRule;
    }

    public boolean canDebugAgain() {
        if (this.inputMode == 0) {
            return this.inputText != null;
        }
        return this.inputFile != null && new File(this.inputFile).exists();
    }

    public void dialogDidCancel() {
        this.cancel();
    }

    public void forceStop() {
        if (this.remoteParserProcess != null) {
            this.remoteParserProcess.destroy();
        }
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized boolean cancelled() {
        return this.cancelled;
    }

    public void showProgress() {
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.debugger.getWindowComponent());
        }
        this.progress.setInfo("Preparing...");
        this.progress.setIndeterminate(false);
        this.progress.setProgress(0);
        this.progress.setProgressMax(3);
        this.progress.setDelegate(this);
        this.progress.display();
    }

    public void hideProgress() {
        if (this.progress != null) {
            this.progress.close();
        }
    }

    private boolean optionBuild() {
        return (this.options & 2) > 0 || this.debugPortChanged;
    }

    private boolean optionAgain() {
        return (this.options & 1) > 0;
    }

    public void prepareAndLaunch(int n) {
        this.options = n;
        this.cancelled = false;
        if (this.debugPort != AWPrefs.getDebugDefaultLocalPort()) {
            this.debugPort = AWPrefs.getDebugDefaultLocalPort();
            this.debugPortChanged = true;
        } else {
            this.debugPortChanged = false;
        }
        if (this.optionBuild()) {
            this.showProgress();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBLocal.this.startThread();
            }
        });
    }

    public void startThread() {
        new Thread(this).start();
    }

    public void run() {
        this.resetErrors();
        if (this.prepare()) {
            if (this.optionBuild()) {
                this.generateAndCompileGrammar();
            }
            if (!this.cancelled() && !this.optionAgain()) {
                this.askUserForInputText();
            }
            if (!this.cancelled()) {
                this.generateAndCompileGlueCode(this.optionBuild());
            }
            if (!this.cancelled()) {
                this.generateInputText();
            }
            if (!this.cancelled()) {
                this.launchRemoteParser();
            }
        }
        if (this.hasErrors()) {
            this.notifyErrors();
        } else if (this.cancelled()) {
            this.notifyCancellation();
        } else {
            this.notifyCompletion();
        }
    }

    protected void askUserForInputText() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DBLocal.this.hideProgress();
                    DebuggerInputDialog debuggerInputDialog = new DebuggerInputDialog(DBLocal.this.debugger, DBLocal.this.debugger.getWindowComponent());
                    debuggerInputDialog.setInputText(DBLocal.this.rawInputText);
                    if (debuggerInputDialog.runModal() == 1) {
                        DBLocal.this.rawInputText = debuggerInputDialog.getRawInputText();
                        DBLocal.this.inputText = debuggerInputDialog.getInputText();
                        DBLocal.this.inputFile = debuggerInputDialog.getInputFile();
                        DBLocal.this.inputMode = debuggerInputDialog.getInputMode();
                        DBLocal.this.setStartRule(debuggerInputDialog.getRule());
                        DBLocal.this.showProgress();
                    } else {
                        DBLocal.this.cancel();
                    }
                }
            });
        }
        catch (Exception exception) {
            this.debugger.getConsole().print(exception);
        }
    }

    protected void reportError(String string) {
        this.error.setTitle("Error");
        this.error.setMessage(string);
        this.error.enable();
        this.cancel();
    }

    protected void resetErrors() {
        this.error.reset();
    }

    protected boolean hasErrors() {
        return this.error.hasErrors;
    }

    protected void notifyErrors() {
        this.hideProgress();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (XJAlert.displayAlert(DBLocal.this.debugger.getWindowComponent(), DBLocal.this.error.title, DBLocal.this.error.message, "Show Console", "OK", 1, 1) == 0) {
                    DBLocal.this.debugger.selectConsoleTab();
                }
            }
        });
    }

    protected void notifyCancellation() {
        this.hideProgress();
    }

    protected void notifyCompletion() {
        this.hideProgress();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!DBLocal.this.cancelled()) {
                    DBLocal.this.debugger.debuggerLocalDidRun(DBLocal.this.optionBuild());
                }
            }
        });
    }

    protected boolean prepare() {
        try {
            this.setStartRule(AWPrefs.getStartSymbol());
            this.grammarGeneratedFiles = this.codeGenerator.getGeneratedTextFileNames();
            this.fileRemoteParser = XJUtils.concatPath(this.codeGenerator.getOutputPath(), "__Test__.java");
            this.fileRemoteParserInputTextFile = XJUtils.concatPath(this.codeGenerator.getOutputPath(), "__Test___input.txt");
            this.outputFileDir = XJUtils.concatPath(this.codeGenerator.getOutputPath(), "classes");
            new File(this.outputFileDir).mkdirs();
        }
        catch (Exception exception) {
            this.debugger.getConsole().print(exception);
            String string = ErrorListener.getThreadInstance().getFirstErrorMessage();
            StringBuffer stringBuffer = new StringBuffer("Error while preparing the grammar:\n");
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            stringBuffer.append(exception.toString());
            this.reportError(stringBuffer.toString());
            return false;
        }
        return true;
    }

    protected void generateAndCompileGrammar() {
        this.progress.setInfo("Analyzing...");
        this.progress.setProgress(1);
        this.analyzeGrammar();
        if (this.cancelled()) {
            return;
        }
        this.progress.setInfo("Generating...");
        this.progress.setProgress(2);
        this.generateGrammar();
        if (this.cancelled()) {
            return;
        }
        this.progress.setInfo("Compiling...");
        this.progress.setProgress(3);
        this.compileGrammar();
    }

    protected void analyzeGrammar() {
        String string = null;
        try {
            this.debugger.getGrammar().analyze();
        }
        catch (Exception exception) {
            this.debugger.getConsole().print(exception);
            string = exception.getLocalizedMessage();
        }
        if (string != null) {
            this.reportError("Error while analyzing the grammar:\n" + string);
        }
    }

    protected void generateGrammar() {
        String string = null;
        try {
            if (!this.codeGenerator.generate()) {
                string = this.codeGenerator.getLastError();
            }
        }
        catch (Exception exception) {
            this.debugger.getConsole().print(exception);
            string = exception.toString();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.debugger.getConsole().print(outOfMemoryError);
            string = outOfMemoryError.toString();
        }
        if (string != null) {
            this.reportError("Error while generating the grammar:\n" + string);
        }
    }

    protected void compileGrammar() {
        XJUtils.deleteDirectory(this.outputFileDir);
        new File(this.outputFileDir).mkdirs();
        this.compileFiles(this.grammarGeneratedFiles.toArray(new String[this.grammarGeneratedFiles.size()]));
    }

    protected void generateAndCompileGlueCode(boolean bl) {
        this.progress.setInfo("Preparing...");
        this.progress.setIndeterminate(true);
        if (!bl && this.lastStartRule != null && this.startRule.equals(this.lastStartRule) && this.inputFile.equals(this.lastInputFile) && this.lastInputMode == this.inputMode) {
            return;
        }
        this.lastStartRule = this.startRule;
        this.lastInputMode = this.inputMode;
        this.lastInputFile = this.inputFile;
        this.generateGlueCode();
        if (this.cancelled()) {
            return;
        }
        this.compileGlueCode();
    }

    protected void generateGlueCode() {
        try {
            StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("DebuggerLocalGroup", DefaultTemplateLexer.class);
            StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("org/antlr/works/debugger/local/DBParserGlueCode");
            stringTemplate.setAttribute(ST_ATTR_IMPORT, this.getCustomImports());
            stringTemplate.setAttribute(ST_ATTR_CLASSNAME, remoteParserClassName);
            if (this.inputMode == 0) {
                stringTemplate.setAttribute(ST_ATTR_INPUT_FILE, XJUtils.escapeString(this.fileRemoteParserInputTextFile));
            } else {
                stringTemplate.setAttribute(ST_ATTR_INPUT_FILE, XJUtils.escapeString(this.inputFile));
            }
            stringTemplate.setAttribute(ST_ATTR_JAVA_PARSER, this.codeGenerator.getGeneratedClassName(1));
            stringTemplate.setAttribute(ST_ATTR_JAVA_LEXER, this.codeGenerator.getGeneratedClassName(2));
            stringTemplate.setAttribute(ST_ATTR_START_SYMBOL, this.startRule);
            stringTemplate.setAttribute(ST_ATTR_DEBUG_PORT, AWPrefs.getDebugDefaultLocalPort());
            XJUtils.writeStringToFile(stringTemplate.toString(), this.fileRemoteParser);
        }
        catch (Exception exception) {
            this.debugger.getConsole().print(exception);
            this.reportError("Error while generating the glue-code:\n" + exception.toString());
        }
    }

    private String getCustomImports() {
        List<ElementBlock> list = this.debugger.getBlocks();
        if (list == null || list.isEmpty()) {
            return "";
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ElementBlock object : list) {
            if (!object.name.equals("@header") && !object.name.equals("@lexer::header")) continue;
            List<ATEToken> list2 = object.internalTokens;
            for (int i = 0; i < list2.size(); ++i) {
                ATEToken aTEToken;
                String string;
                ATEToken aTEToken2 = list2.get(i);
                if (aTEToken2.type != 5 || !aTEToken2.getAttribute().equals("package")) continue;
                StringBuffer stringBuffer = new StringBuffer();
                ++i;
                while (i < list2.size() && !(string = (aTEToken = list2.get(i)).getAttribute()).equals(";")) {
                    stringBuffer.append(string);
                    ++i;
                }
                hashSet.add(stringBuffer.toString());
            }
        }
        if (hashSet.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : hashSet) {
            stringBuffer.append("import ");
            stringBuffer.append(string);
            stringBuffer.append(".*;\n");
        }
        return stringBuffer.toString();
    }

    protected void compileGlueCode() {
        this.compileFiles(new String[]{this.fileRemoteParser});
    }

    protected void compileFiles(String[] stringArray) {
        String string = EngineRuntime.compileFiles(this.debugger.getConsole(), stringArray, this.outputFileDir, this);
        if (string != null) {
            this.reportError(string);
        }
    }

    protected void generateInputText() {
        try {
            XJUtils.writeStringToFile(this.inputText, this.fileRemoteParserInputTextFile);
        }
        catch (IOException iOException) {
            this.debugger.getConsole().print(iOException);
            this.reportError("Error while generating the input text:\n" + iOException.toString());
        }
    }

    public boolean isRequiredFilesExisting() {
        if (!this.prepare()) {
            return false;
        }
        if (!new File(this.fileRemoteParser).exists()) {
            return false;
        }
        if (this.inputMode == 0 && !new File(this.fileRemoteParserInputTextFile).exists()) {
            return false;
        }
        if (this.inputMode == 1 && !new File(this.inputFile).exists()) {
            return false;
        }
        for (String string : this.grammarGeneratedFiles) {
            if (new File(string).exists()) continue;
            return false;
        }
        return true;
    }

    public boolean checkForLaunch() {
        boolean bl = true;
        try {
            ServerSocket serverSocket = new ServerSocket(AWPrefs.getDebugDefaultLocalPort());
            serverSocket.close();
        }
        catch (IOException iOException) {
            this.reportError("Cannot launch the remote parser because port " + AWPrefs.getDebugDefaultLocalPort() + " is already in use.");
            bl = false;
        }
        return bl;
    }

    public boolean launchRemoteParser() {
        if (!this.checkForLaunch()) {
            return false;
        }
        String string = EngineRuntime.getClassPath(this.outputFileDir);
        IDE.debugVerbose(this.debugger.getConsole(), this.getClass(), "Launch with path: " + string);
        try {
            this.remoteParserProcess = Runtime.getRuntime().exec(new String[]{"java", "-classpath", string, remoteParserClassName});
            new StreamWatcher(this.remoteParserProcess.getErrorStream(), "Launcher", this.debugger.getOutputPanel()).start();
            new StreamWatcher(this.remoteParserProcess.getInputStream(), "Launcher", this.debugger.getOutputPanel()).start();
        }
        catch (IOException iOException) {
            this.reportError("Cannot launch the remote parser:\n" + iOException.toString() + "\nIt is possible that some errors prevented the parser from launching. Check the output panel of the debugger and any other output console in your system to see if an error has been reported from the parser and try again.");
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void streamWatcherDidStarted() {
    }

    public synchronized void streamWatcherDidReceiveString(String string) {
        this.debugger.getConsole().print(string, 0);
    }

    public synchronized void streamWatcherException(Exception exception) {
        this.debugger.getConsole().print(exception);
    }

    protected static class ErrorReporter {
        public String title;
        public String message;
        public boolean hasErrors;

        protected ErrorReporter() {
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public void enable() {
            this.hasErrors = true;
        }

        public void reset() {
            this.hasErrors = false;
        }
    }
}

