/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.input;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.Token;
import org.antlr.tool.Grammar;
import org.antlr.works.awtree.AWTreePanel;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.tree.DBTreeNode;
import org.antlr.works.debugger.tree.DBTreeToken;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class DBInputProcessorTree
implements DBInputProcessor,
XJNotificationObserver {
    public AWTreePanel treePanel;
    public Debugger debugger;
    public InputTreeNode rootNode;
    public InputTreeNode currentNode;
    public InputTreeNode lastNode;
    public Map<Integer, NodeInfo> nodeInfoForToken = new HashMap<Integer, NodeInfo>();
    public int line;
    public int pos;
    public Color nonConsumedColor;
    public Color consumedColor;
    public Color ltColor;

    public DBInputProcessorTree(AWTreePanel aWTreePanel, Debugger debugger) {
        this.treePanel = aWTreePanel;
        this.debugger = debugger;
        this.createColors();
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
    }

    public void close() {
        this.treePanel = null;
        this.debugger = null;
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public void updateTreePanel() {
        this.treePanel.refresh();
        this.treePanel.scrollNodeToVisible(this.lastNode);
    }

    public void createColors() {
        this.nonConsumedColor = AWPrefs.getNonConsumedTokenColor();
        this.consumedColor = AWPrefs.getConsumedTokenColor();
        this.ltColor = AWPrefs.getLookaheadTokenColor();
    }

    public void applyColor(Color color) {
        for (NodeInfo nodeInfo : this.nodeInfoForToken.values()) {
            if (nodeInfo.node == null) continue;
            nodeInfo.node.setColor(color);
        }
    }

    public void reset() {
        this.nodeInfoForToken.clear();
        this.rootNode = this.createNode(null);
        this.treePanel.setRoot(this.rootNode);
        this.lastNode = this.currentNode = this.rootNode;
    }

    public void removeAllLT() {
    }

    public void rewind(int n) {
    }

    public void rewindAll() {
        this.applyColor(this.nonConsumedColor);
        this.lastNode = this.currentNode = this.rootNode;
    }

    public void LT(Token token) {
        InputTreeNode inputTreeNode = this.processToken(token);
        if (inputTreeNode != null) {
            this.lastNode = inputTreeNode;
            inputTreeNode.setColor(this.ltColor);
        }
    }

    public void consumeToken(Token token, int n) {
        InputTreeNode inputTreeNode = this.processToken(token);
        if (inputTreeNode != null) {
            this.lastNode = inputTreeNode;
            inputTreeNode.setColor(this.consumedColor);
        }
    }

    public InputTreeNode processToken(Token token) {
        NodeInfo nodeInfo = this.getNode(token);
        if (nodeInfo != null) {
            this.setCurrentNode(nodeInfo.currentNode);
            return nodeInfo.node;
        }
        nodeInfo = new NodeInfo(token);
        switch (token.getType()) {
            case 2: {
                this.setCurrentNode((InputTreeNode)this.currentNode.getLastChild());
                nodeInfo.currentNode = this.currentNode;
                break;
            }
            case 3: {
                if (this.currentNode == this.rootNode) {
                    this.debugger.warning(this, "UP token applied to the root node!");
                }
                if (this.currentNode == null) {
                    this.debugger.warning(this, "CurrentNode is null, use rootNode instead.");
                    this.setCurrentNode(this.rootNode);
                } else {
                    this.setCurrentNode((InputTreeNode)this.currentNode.getParent());
                }
                nodeInfo.currentNode = this.currentNode;
                break;
            }
            default: {
                if (this.currentNode == null) {
                    this.debugger.warning(this, "CurrentNode is null, use rootNode instead.");
                    this.setCurrentNode(this.rootNode);
                }
                nodeInfo.node = this.createNode(token);
                this.currentNode.add(nodeInfo.node);
                nodeInfo.currentNode = this.currentNode;
            }
        }
        DBTreeToken dBTreeToken = (DBTreeToken)token;
        this.nodeInfoForToken.put(dBTreeToken.ID, nodeInfo);
        return nodeInfo.node;
    }

    public void setCurrentNode(InputTreeNode inputTreeNode) {
        this.currentNode = inputTreeNode;
    }

    public InputTreeNode createNode(Token token) {
        InputTreeNode inputTreeNode = new InputTreeNode((DBTreeToken)token, this.debugger.getGrammar().getANTLRGrammar());
        inputTreeNode.setPosition(this.line, this.pos);
        return inputTreeNode;
    }

    public NodeInfo getNode(Token token) {
        DBTreeToken dBTreeToken = (DBTreeToken)token;
        NodeInfo nodeInfo = this.nodeInfoForToken.get(dBTreeToken.ID);
        if (nodeInfo != null && !nodeInfo.token.toString().equals(token.toString())) {
            this.debugger.warning(this, "Duplicate token ID " + dBTreeToken.ID + " for " + nodeInfo.token + " <-> " + token);
        }
        return nodeInfo;
    }

    public void setLocation(int n, int n2) {
        this.line = n;
        this.pos = n2;
    }

    public int getCurrentTokenIndex() {
        return 0;
    }

    public DBInputTextTokenInfo getTokenInfoAtTokenIndex(int n) {
        return null;
    }

    public DBInputTextTokenInfo getTokenInfoForToken(Token token) {
        return null;
    }

    public void notificationFire(Object object, String string) {
        if (string.equals("NOTIF_PREFS_APPLIED")) {
            this.createColors();
        }
    }

    public boolean isBreakpointAtToken(Token token) {
        NodeInfo nodeInfo = this.getNode(token);
        return nodeInfo != null && nodeInfo.node != null && nodeInfo.node.breakpoint;
    }

    public class InputTreeNode
    extends DBTreeNode {
        public boolean breakpoint;

        public InputTreeNode(DBTreeToken dBTreeToken, Grammar grammar) {
            super(dBTreeToken, grammar);
            this.breakpoint = false;
        }

        public void toggleBreakpoint() {
            this.breakpoint = !this.breakpoint;
            DBInputProcessorTree.this.treePanel.getGraphView().repaintNode(this);
        }

        public Color getColor() {
            if (this.breakpoint) {
                return Color.red;
            }
            return super.getColor();
        }

        public String toString() {
            if (this.token != null) {
                return this.token.getText();
            }
            return "nil";
        }
    }

    public static class NodeInfo {
        public Token token;
        public InputTreeNode node;
        public InputTreeNode currentNode;

        public NodeInfo(Token token) {
            this.token = token;
        }
    }
}

