/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.input;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.TextPane;
import org.antlr.works.utils.TextPaneDelegate;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class DBInputProcessorToken
implements DBInputProcessor,
TextPaneDelegate,
XJNotificationObserver {
    public static final Color HIGHLIGHTED_COLOR = new Color(0.0f, 0.5f, 1.0f, 0.4f);
    public static final Color INPUT_BREAKPOINT_COLOR = new Color(1.0f, 0.2f, 0.0f, 0.5f);
    protected Debugger debugger;
    protected TextPane textPane;
    protected int mouseIndex = -1;
    protected LinkedList<Integer> inputTokenIndexes = new LinkedList();
    protected Map<Integer, DBInputTextTokenInfo> indexToTokenInfoMap = new HashMap<Integer, DBInputTextTokenInfo>();
    protected Map<Integer, AttributeSet> indexToConsumeAttributeMap = new HashMap<Integer, AttributeSet>();
    protected Set<Integer> lookaheadTokenIndexes = new HashSet<Integer>();
    protected int currentTokenIndex;
    protected int currentTokenIndexInText;
    protected int locationLine;
    protected int locationCharInLine;
    protected Set<Integer> inputBreakpointIndexes = new HashSet<Integer>();
    protected SimpleAttributeSet attributeNonConsumed;
    protected SimpleAttributeSet attributeConsume;
    protected SimpleAttributeSet attributeConsumeHidden;
    protected SimpleAttributeSet attributeConsumeDead;
    protected SimpleAttributeSet attributeLookahead;
    protected boolean drawTokensBox;

    public DBInputProcessorToken(Debugger debugger, TextPane textPane) {
        this.debugger = debugger;
        this.textPane = textPane;
        this.textPane.setDelegate(this);
        this.textPane.addMouseListener(new MyMouseListener());
        this.textPane.addMouseMotionListener(new MyMouseMotionListener());
        this.drawTokensBox = false;
        this.reset();
        this.createTextAttributes();
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
    }

    public void close() {
        this.debugger = null;
        this.textPane.setDelegate(null);
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public void setDrawTokensBox(boolean bl) {
        this.drawTokensBox = bl;
        this.textPane.repaint();
    }

    public boolean isTokensBoxVisible() {
        return this.drawTokensBox;
    }

    public int getCurrentTokenIndex() {
        return this.currentTokenIndex;
    }

    public void setLocation(int n, int n2) {
        this.locationLine = n;
        this.locationCharInLine = n2;
    }

    public void consumeToken(Token token, int n) {
        if (this.ignoreToken(token)) {
            return;
        }
        SimpleAttributeSet simpleAttributeSet = null;
        switch (n) {
            case 1: {
                simpleAttributeSet = this.attributeConsume;
                break;
            }
            case 2: {
                simpleAttributeSet = this.attributeConsumeHidden;
                break;
            }
            case 3: {
                simpleAttributeSet = this.attributeConsumeDead;
            }
        }
        this.addToken(token);
        this.addConsumeAttribute(token, simpleAttributeSet);
        this.removeTokenLT(token);
    }

    public void LT(Token token) {
        this.addToken(token);
        this.addTokenLT(token);
    }

    public boolean ignoreToken(Token token) {
        if (!XJSystem.isWindows()) {
            return false;
        }
        Token token2 = this.getCurrentToken();
        if (token2 == null) {
            return false;
        }
        return token2.getText().equals("\r") && token.getText().equals("\n");
    }

    public void addConsumeAttribute(Token token, AttributeSet attributeSet) {
        this.indexToConsumeAttributeMap.put(token.getTokenIndex(), attributeSet);
    }

    public void addTokenLT(Token token) {
        this.lookaheadTokenIndexes.add(token.getTokenIndex());
    }

    public void removeTokenLT(Token token) {
        this.lookaheadTokenIndexes.remove(token.getTokenIndex());
    }

    public void removeAllLT() {
        this.lookaheadTokenIndexes.clear();
    }

    public void stop() {
        this.inputBreakpointIndexes.clear();
    }

    public void reset() {
        this.textPane.setText("");
        this.textPane.setCharacterAttributes(SimpleAttributeSet.EMPTY, true);
        this.currentTokenIndex = -1;
        this.currentTokenIndexInText = 0;
        this.inputTokenIndexes.clear();
        this.indexToTokenInfoMap.clear();
        this.indexToConsumeAttributeMap.clear();
        this.lookaheadTokenIndexes.clear();
    }

    public void rewindAll() {
        this.rewind(-1);
    }

    public void rewind(int n) {
        this.currentTokenIndex = n;
        for (Integer n2 : this.inputTokenIndexes) {
            if (n2 < n) continue;
            this.indexToConsumeAttributeMap.remove(n2);
            this.lookaheadTokenIndexes.remove(n2);
        }
    }

    public void addToken(Token token) {
        int n = token.getTokenIndex();
        if (n == -1) {
            return;
        }
        this.currentTokenIndex = n;
        if (!this.indexToTokenInfoMap.containsKey(n)) {
            if (this.inputTokenIndexes.isEmpty()) {
                this.inputTokenIndexes.add(n);
            } else {
                for (int i = this.inputTokenIndexes.size() - 1; i >= 0; --i) {
                    Integer n2 = this.inputTokenIndexes.get(i);
                    if (n2 >= n) continue;
                    this.inputTokenIndexes.add(i + 1, n);
                    break;
                }
            }
        }
        this.indexToTokenInfoMap.put(n, new DBInputTextTokenInfo(token, this.locationLine, this.locationCharInLine));
    }

    public Token getCurrentToken() {
        DBInputTextTokenInfo dBInputTextTokenInfo = this.indexToTokenInfoMap.get(this.getCurrentTokenIndex());
        if (dBInputTextTokenInfo == null) {
            return null;
        }
        return dBInputTextTokenInfo.token;
    }

    public String renderTokensText() {
        this.currentTokenIndexInText = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (Integer n : this.inputTokenIndexes) {
            DBInputTextTokenInfo dBInputTextTokenInfo = this.indexToTokenInfoMap.get(n);
            dBInputTextTokenInfo.setStart(stringBuffer.length());
            stringBuffer.append(dBInputTextTokenInfo.getText());
            if (n.intValue() != this.getCurrentTokenIndex()) continue;
            this.currentTokenIndexInText = dBInputTextTokenInfo.start;
        }
        return stringBuffer.toString();
    }

    public void render() {
        String string = this.renderTokensText();
        this.textPane.setText(string);
        this.textPane.getStyledDocument().setCharacterAttributes(0, string.length(), SimpleAttributeSet.EMPTY, true);
        for (Integer n : this.inputTokenIndexes) {
            DBInputTextTokenInfo dBInputTextTokenInfo = this.indexToTokenInfoMap.get(n);
            AttributeSet attributeSet = this.indexToConsumeAttributeMap.get(n);
            if (attributeSet == null) {
                attributeSet = this.attributeNonConsumed;
            }
            if (this.lookaheadTokenIndexes.contains(n)) {
                attributeSet = this.attributeLookahead;
            }
            this.textPane.getStyledDocument().setCharacterAttributes(dBInputTextTokenInfo.start, dBInputTextTokenInfo.end, attributeSet, true);
        }
    }

    public void updateOnBreakEvent() {
        this.render();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    DBInputProcessorToken.this.textPane.scrollRectToVisible(DBInputProcessorToken.this.textPane.modelToView(DBInputProcessorToken.this.currentTokenIndexInText));
                }
                catch (BadLocationException badLocationException) {
                    DBInputProcessorToken.this.debugger.getConsole().print(badLocationException);
                }
            }
        });
    }

    public void createTextAttributes() {
        this.attributeNonConsumed = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeNonConsumed, AWPrefs.getNonConsumedTokenColor());
        this.attributeConsume = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeConsume, AWPrefs.getConsumedTokenColor());
        this.attributeConsumeHidden = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeConsumeHidden, AWPrefs.getHiddenTokenColor());
        this.attributeConsumeDead = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeConsumeDead, AWPrefs.getDeadTokenColor());
        this.attributeLookahead = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeLookahead, AWPrefs.getLookaheadTokenColor());
        StyleConstants.setItalic(this.attributeLookahead, true);
    }

    public void textPaneDidPaint(Graphics graphics) {
        for (DBInputTextTokenInfo dBInputTextTokenInfo : this.indexToTokenInfoMap.values()) {
            if (this.drawTokensBox) {
                this.drawToken(dBInputTextTokenInfo, (Graphics2D)graphics, Color.red, false);
            }
            if (this.inputBreakpointIndexes.contains(dBInputTextTokenInfo.token.getTokenIndex())) {
                this.drawToken(dBInputTextTokenInfo, (Graphics2D)graphics, INPUT_BREAKPOINT_COLOR, true);
                continue;
            }
            if (this.mouseIndex < dBInputTextTokenInfo.start || this.mouseIndex >= dBInputTextTokenInfo.end) continue;
            this.drawToken(dBInputTextTokenInfo, (Graphics2D)graphics, HIGHLIGHTED_COLOR, true);
        }
    }

    public void drawToken(DBInputTextTokenInfo dBInputTextTokenInfo, Graphics2D graphics2D, Color color, boolean bl) {
        graphics2D.setColor(color);
        try {
            Rectangle rectangle = this.textPane.modelToView(dBInputTextTokenInfo.start);
            Rectangle rectangle2 = this.textPane.modelToView(dBInputTextTokenInfo.end);
            if (rectangle2.y > rectangle.y) {
                GeneralPath generalPath = new GeneralPath();
                Area area = new Area();
                for (int i = dBInputTextTokenInfo.start; i < dBInputTextTokenInfo.end; ++i) {
                    Rectangle rectangle3 = this.textPane.modelToView(i);
                    rectangle3.width = Math.max(0, this.textPane.modelToView((int)(i + 1)).x - rectangle3.x);
                    area.add(new Area(rectangle3));
                }
                generalPath.append(area, true);
                if (bl) {
                    graphics2D.fill(generalPath);
                } else {
                    graphics2D.draw(generalPath);
                }
            } else if (bl) {
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
            } else {
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public DBInputTextTokenInfo getTokenInfoAtTokenIndex(int n) {
        return this.indexToTokenInfoMap.get(n);
    }

    public DBInputTextTokenInfo getTokenInfoAtPositionIndex(int n) {
        for (DBInputTextTokenInfo dBInputTextTokenInfo : this.indexToTokenInfoMap.values()) {
            if (n < dBInputTextTokenInfo.start || n >= dBInputTextTokenInfo.end) continue;
            return dBInputTextTokenInfo;
        }
        return null;
    }

    public boolean isBreakpointAtToken(Token token) {
        return this.inputBreakpointIndexes.contains(token.getTokenIndex());
    }

    public void highlightToken(int n) {
        this.mouseIndex = n;
        this.textPane.repaint();
    }

    public void selectToken(Token token) {
        if (token == null) {
            this.highlightToken(-1);
            return;
        }
        DBInputTextTokenInfo dBInputTextTokenInfo = this.getTokenInfoForToken(token);
        if (dBInputTextTokenInfo != null) {
            this.highlightToken(dBInputTextTokenInfo.start);
        } else {
            this.highlightToken(-1);
        }
    }

    public DBInputTextTokenInfo getTokenInfoForToken(Token token) {
        for (DBInputTextTokenInfo dBInputTextTokenInfo : this.indexToTokenInfoMap.values()) {
            if (dBInputTextTokenInfo.token.getTokenIndex() != token.getTokenIndex() || dBInputTextTokenInfo.token.getType() != token.getType()) continue;
            return dBInputTextTokenInfo;
        }
        return null;
    }

    public void notificationFire(Object object, String string) {
        if (string.equals("NOTIF_PREFS_APPLIED")) {
            this.createTextAttributes();
        }
    }

    protected class MyMouseMotionListener
    extends MouseMotionAdapter {
        protected MyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            DBInputProcessorToken.this.mouseIndex = DBInputProcessorToken.this.textPane.getTextIndexAtLocation(mouseEvent.getPoint());
            DBInputProcessorToken.this.textPane.repaint();
        }
    }

    protected class MyMouseListener
    extends MouseAdapter {
        protected MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            DBInputProcessorToken.this.highlightToken(DBInputProcessorToken.this.textPane.getTextIndexAtLocation(mouseEvent.getPoint()));
            if (DBInputProcessorToken.this.mouseIndex == -1) {
                return;
            }
            DBInputTextTokenInfo dBInputTextTokenInfo = DBInputProcessorToken.this.getTokenInfoAtPositionIndex(DBInputProcessorToken.this.mouseIndex);
            if (dBInputTextTokenInfo == null) {
                return;
            }
            boolean bl2 = bl = (mouseEvent.getModifiersEx() & 0x40) == 64;
            if (mouseEvent.getButton() == 1 && !bl) {
                DBInputProcessorToken.this.debugger.selectToken(dBInputTextTokenInfo.token, dBInputTextTokenInfo.line, dBInputTextTokenInfo.charInLine);
            } else {
                Integer n = dBInputTextTokenInfo.token.getTokenIndex();
                if (DBInputProcessorToken.this.inputBreakpointIndexes.contains(n)) {
                    DBInputProcessorToken.this.inputBreakpointIndexes.remove(n);
                } else {
                    DBInputProcessorToken.this.inputBreakpointIndexes.add(n);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DBInputProcessorToken.this.highlightToken(-1);
        }
    }
}

