/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.TextUtils;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.foundation.XJSystem;

public class DebuggerInputDialog
extends XJDialog {
    private JPanel dialogPane;
    private JPanel contentPane;
    private JRadioButton textInputRadio;
    private JScrollPane scrollPane1;
    private JTextPane inputTextArea;
    private JRadioButton fileInputRadio;
    private JTextField inputFileField;
    private JButton browseInputFileButton;
    private JLabel label2;
    private JComboBox rulesCombo;
    private JLabel label3;
    private JComboBox eolCombo;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public DebuggerInputDialog(Debugger debugger, Container container) {
        super(container, true);
        this.initComponents();
        this.setSize(600, 400);
        if (XJSystem.isMacOS()) {
            this.buttonBar.remove(this.okButton);
            this.buttonBar.remove(this.cancelButton);
            CellConstraints cellConstraints = new CellConstraints();
            this.buttonBar.add((Component)this.cancelButton, cellConstraints.xy(2, 1));
            this.buttonBar.add((Component)this.okButton, cellConstraints.xy(4, 1));
        }
        this.setDefaultButton(this.okButton);
        this.setOKButton(this.okButton);
        this.setCancelButton(this.cancelButton);
        TextUtils.createTabs(this.inputTextArea);
        TextUtils.setDefaultTextPaneProperties(this.inputTextArea);
        this.inputTextArea.setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.inputTextArea.setFocusable(true);
        this.inputTextArea.requestFocusInWindow();
        this.inputTextArea.setText(AWPrefs.getDebuggerInputText());
        this.rulesCombo.removeAllItems();
        for (ElementRule elementRule : debugger.getSortedRules()) {
            this.rulesCombo.addItem(elementRule.name);
        }
        this.rulesCombo.setSelectedItem(AWPrefs.getStartSymbol());
        Utils.fillComboWithEOL(this.eolCombo);
        this.eolCombo.setSelectedIndex(AWPrefs.getDebuggerEOL());
        if (AWPrefs.getDebuggerInputMode() == 0) {
            this.textInputRadio.setSelected(true);
        } else {
            this.fileInputRadio.setSelected(true);
        }
        this.inputFileField.setText(AWPrefs.getDebuggerInputFile());
        this.browseInputFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJFileChooser.shared().displayOpenDialog(DebuggerInputDialog.this.getContentPane(), false)) {
                    DebuggerInputDialog.this.inputFileField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setDebuggerInputFile(DebuggerInputDialog.this.inputFileField.getText());
                    DebuggerInputDialog.this.fileInputRadio.setSelected(true);
                }
            }
        });
    }

    public void dialogWillCloseOK() {
        String string = this.getRawInputText();
        if (string.length() > 8192) {
            XJAlert.display(this.getJavaComponent(), "Error", "The input text is too large: " + string.length() + " bytes but preferences can only hold " + 8192 + " bytes. It will be truncated.");
            string = string.substring(0, 8191);
        }
        AWPrefs.setStartSymbol(this.getRule());
        AWPrefs.setDebuggerInputText(string);
        AWPrefs.setDebuggerEOL(this.eolCombo.getSelectedIndex());
        AWPrefs.setDebuggerInputMode(this.textInputRadio.isSelected() ? 0 : 1);
        AWPrefs.setDebuggerInputFile(this.inputFileField.getText());
    }

    public int getInputMode() {
        return this.textInputRadio.isSelected() ? 0 : 1;
    }

    public void setInputText(String string) {
        if (string != null) {
            this.inputTextArea.setText(string);
        }
    }

    public String getRawInputText() {
        return this.inputTextArea.getText();
    }

    public String getInputText() {
        return Utils.convertRawTextWithEOL(this.getRawInputText(), this.eolCombo);
    }

    public String getInputFile() {
        return this.inputFileField.getText();
    }

    public String getRule() {
        return (String)this.rulesCombo.getSelectedItem();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPane = new JPanel();
        this.textInputRadio = new JRadioButton();
        this.scrollPane1 = new JScrollPane();
        this.inputTextArea = new JTextPane();
        this.fileInputRadio = new JRadioButton();
        this.inputFileField = new JTextField();
        this.browseInputFileButton = new JButton();
        this.label2 = new JLabel();
        this.rulesCombo = new JComboBox();
        this.label3 = new JLabel();
        this.eolCombo = new JComboBox();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        this.setTitle("Input Text");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPane.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.textInputRadio.setText("Text:");
        this.textInputRadio.setSelected(true);
        this.contentPane.add((Component)this.textInputRadio, cellConstraints.xy(1, 1));
        this.scrollPane1.setPreferredSize(new Dimension(300, 200));
        this.scrollPane1.setViewportView(this.inputTextArea);
        this.contentPane.add((Component)this.scrollPane1, cellConstraints.xywh(3, 1, 5, 5));
        this.fileInputRadio.setText("File:");
        this.contentPane.add((Component)this.fileInputRadio, cellConstraints.xy(1, 7));
        this.contentPane.add((Component)this.inputFileField, cellConstraints.xywh(3, 7, 3, 1));
        this.browseInputFileButton.setText("Browse...");
        this.contentPane.add((Component)this.browseInputFileButton, cellConstraints.xy(7, 7));
        this.label2.setText("Start Rule:");
        this.contentPane.add((Component)this.label2, cellConstraints.xywh(1, 9, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.contentPane.add((Component)this.rulesCombo, cellConstraints.xywh(3, 9, 5, 1));
        this.label3.setText("Line Endings:");
        this.contentPane.add((Component)this.label3, cellConstraints.xywh(1, 11, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.eolCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Unix (LF)", "Mac (CR)", "Windows (CRLF)"}));
        this.contentPane.add((Component)this.eolCombo, cellConstraints.xy(3, 11));
        this.dialogPane.add((Component)this.contentPane, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")));
        this.okButton.setText("OK");
        this.buttonBar.add((Component)this.okButton, cellConstraints.xy(2, 1));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, cellConstraints.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        container.add((Component)this.dialogPane, "Center");
        this.setSize(625, 395);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.textInputRadio);
        buttonGroup.add(this.fileInputRadio);
    }
}

