/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.Token;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.local.DBLocal;
import org.antlr.works.debugger.panels.DBControlPanel;
import org.antlr.works.debugger.panels.DBEventsPanel;
import org.antlr.works.debugger.panels.DBInputPanel;
import org.antlr.works.debugger.panels.DBOutputPanel;
import org.antlr.works.debugger.panels.DBStackPanel;
import org.antlr.works.debugger.remote.DBRemoteConnectDialog;
import org.antlr.works.debugger.tivo.DBPlayer;
import org.antlr.works.debugger.tivo.DBPlayerContextInfo;
import org.antlr.works.debugger.tivo.DBRecorder;
import org.antlr.works.debugger.tree.DBASTModel;
import org.antlr.works.debugger.tree.DBASTPanel;
import org.antlr.works.debugger.tree.DBParseTreeModel;
import org.antlr.works.debugger.tree.DBParseTreePanel;
import org.antlr.works.editor.EditorConsole;
import org.antlr.works.editor.EditorProvider;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.swing.CustomSplitPanel;
import org.antlr.works.swing.CustomToggleButton;
import org.antlr.works.swing.DetachablePanel;
import org.antlr.works.swing.DetachablePanelDelegate;
import org.antlr.works.syntax.element.ElementBlock;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debugger
extends EditorTab
implements DetachablePanelDelegate {
    public static final String DEFAULT_LOCAL_ADDRESS = "localhost";
    public static final String NOTIF_DEBUG_STARTED = "NOTIF_DEBUG_STARTED";
    public static final String NOTIF_DEBUG_STOPPED = "NOTIF_DEBUG_STOPPED";
    public static final int OPTION_NONE = 0;
    public static final int OPTION_AGAIN = 1;
    public static final int OPTION_BUILD = 2;
    public static final float PERCENT_WIDTH_LEFT = 0.2f;
    public static final float PERCENT_WIDTH_MIDDLE = 0.5f;
    protected JPanel panel;
    protected DBInputPanel inputPanel;
    protected DBOutputPanel outputPanel;
    protected DBParseTreePanel parseTreePanel;
    protected DBParseTreeModel parseTreeModel;
    protected DBASTPanel astPanel;
    protected DBASTModel astModel;
    protected DBStackPanel stackPanel;
    protected DBEventsPanel eventsPanel;
    protected DBControlPanel controlPanel;
    protected CustomSplitPanel splitPanel;
    protected Map<Component, CustomToggleButton> components2toggle;
    protected CEditorGrammar editor;
    protected Set<Integer> breakpoints;
    protected DBLocal local;
    protected DBRecorder recorder;
    protected DBPlayer player;
    protected boolean running;
    protected long dateOfModificationOnDisk = 0L;
    protected int debuggerCursorIndex = -1;
    private boolean closing = false;
    public static final int TOGGLE_INPUT = 0;
    public static final int TOGGLE_OUTPUT = 1;
    public static final int TOGGLE_PTREE = 2;
    public static final int TOGGLE_AST = 3;
    public static final int TOGGLE_STACK = 4;
    public static final int TOGGLE_EVENTS = 5;
    public int grammarIndex;
    public static final String KEY_SPLITPANE_A = "KEY_SPLITPANE_A";
    public static final String KEY_SPLITPANE_B = "KEY_SPLITPANE_B";
    public static final String KEY_SPLITPANE_C = "KEY_SPLITPANE_C";

    public Debugger(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void awake() {
        this.panel = new JPanel(new BorderLayout());
        this.splitPanel = new CustomSplitPanel();
        this.components2toggle = new HashMap<Component, CustomToggleButton>();
        this.controlPanel = new DBControlPanel(this);
        this.inputPanel = new DBInputPanel(this);
        this.inputPanel.setTag(0);
        this.outputPanel = new DBOutputPanel(this);
        this.outputPanel.setTag(0);
        this.parseTreePanel = new DBParseTreePanel(this);
        this.parseTreePanel.setTag(1);
        this.parseTreeModel = this.parseTreePanel.getModel();
        this.astPanel = new DBASTPanel(this);
        this.astPanel.setTag(1);
        this.astModel = this.astPanel.getModel();
        this.stackPanel = new DBStackPanel(this);
        this.stackPanel.setTag(2);
        this.eventsPanel = new DBEventsPanel(this);
        this.eventsPanel.setTag(2);
        this.panel.add((Component)this.controlPanel, "North");
        this.panel.add((Component)this.splitPanel, "Center");
        this.panel.add((Component)this.createToggleButtons(), "South");
        this.local = new DBLocal(this);
        this.recorder = new DBRecorder(this);
        this.player = new DBPlayer(this);
        this.updateStatusInfo();
    }

    public void close() {
        this.closing = true;
        this.debuggerStop(true);
        this.splitPanel.close();
        this.controlPanel.close();
        this.inputPanel.close();
        this.outputPanel.close();
        this.parseTreePanel.close();
        this.astPanel.close();
        this.stackPanel.close();
        this.eventsPanel.close();
        this.local.close();
        this.recorder.close();
        this.player.close();
        this.parseTreeModel.close();
        this.astModel.close();
        for (CustomToggleButton customToggleButton : this.components2toggle.values()) {
            for (ActionListener actionListener : customToggleButton.getActionListeners()) {
                customToggleButton.removeActionListener(actionListener);
            }
        }
        this.editor = null;
    }

    public void componentShouldLayout(Dimension dimension) {
        this.assemblePanelsIntoSplitPane(dimension.width);
        this.astPanel.componentShouldLayout(new Dimension((int)((float)dimension.width * 0.5f), dimension.height));
    }

    public Box createToggleButtons() {
        Box box = Box.createHorizontalBox();
        box.add(this.createToggleButton("Input", 0, this.inputPanel));
        box.add(this.createToggleButton("Output", 1, this.outputPanel));
        box.add(Box.createHorizontalStrut(15));
        box.add(this.createToggleButton("Parse Tree", 2, this.parseTreePanel));
        box.add(this.createToggleButton("AST", 3, this.astPanel));
        box.add(Box.createHorizontalStrut(15));
        box.add(this.createToggleButton("Stack", 4, this.stackPanel));
        box.add(this.createToggleButton("Events", 5, this.eventsPanel));
        box.add(Box.createHorizontalGlue());
        return box;
    }

    public JToggleButton createToggleButton(String string, int n, Component component) {
        CustomToggleButton customToggleButton = new CustomToggleButton(string);
        customToggleButton.setTag(n);
        customToggleButton.setFocusable(false);
        customToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.performToggleButtonAction((CustomToggleButton)actionEvent.getSource());
            }
        });
        this.components2toggle.put(component, customToggleButton);
        return customToggleButton;
    }

    public void assemblePanelsIntoSplitPane(int n) {
        this.setComponentVisible(this.inputPanel, true);
        this.setComponentVisible(this.outputPanel, false);
        this.setComponentVisible(this.parseTreePanel, true);
        this.setComponentVisible(this.astPanel, false);
        this.setComponentVisible(this.stackPanel, true);
        this.setComponentVisible(this.eventsPanel, false);
        this.splitPanel.setComponentWidth(this.inputPanel, (float)n * 0.2f);
        this.splitPanel.setComponentWidth(this.outputPanel, (float)n * 0.2f);
        this.splitPanel.setComponentWidth(this.parseTreePanel, (float)n * 0.5f);
        this.splitPanel.setComponentWidth(this.astPanel, (float)n * 0.5f);
        this.splitPanel.setComponents(this.inputPanel, this.parseTreePanel, this.stackPanel);
    }

    public void setComponentVisible(Component component, boolean bl) {
        component.setVisible(bl);
        JToggleButton jToggleButton = this.components2toggle.get(component);
        jToggleButton.setSelected(bl);
    }

    public void performToggleButtonAction(CustomToggleButton customToggleButton) {
        switch (customToggleButton.getTag()) {
            case 0: {
                this.toggleComponents(this.inputPanel, this.outputPanel, 0);
                break;
            }
            case 1: {
                this.toggleComponents(this.outputPanel, this.inputPanel, 0);
                break;
            }
            case 2: {
                this.toggleComponents(this.parseTreePanel, this.astPanel, 1);
                break;
            }
            case 3: {
                this.toggleComponents(this.astPanel, this.parseTreePanel, 1);
                break;
            }
            case 4: {
                this.toggleComponents(this.stackPanel, this.eventsPanel, 2);
                break;
            }
            case 5: {
                this.toggleComponents(this.eventsPanel, this.stackPanel, 2);
            }
        }
    }

    public void toggleComponents(DetachablePanel detachablePanel, DetachablePanel detachablePanel2, int n) {
        detachablePanel.setVisible(!detachablePanel.isVisible());
        if (detachablePanel.isVisible()) {
            if (!detachablePanel2.isDetached()) {
                this.setComponentVisible(detachablePanel2, false);
            }
            if (!detachablePanel.isDetached()) {
                this.splitPanel.setComponent(detachablePanel, n);
            }
        } else if (detachablePanel2.isVisible() && !detachablePanel2.isDetached()) {
            this.splitPanel.setComponent(detachablePanel2, n);
        } else {
            this.splitPanel.setComponent(null, n);
        }
    }

    public void toggleInputTokensBox() {
        this.inputPanel.toggleInputTokensBox();
    }

    public boolean isInputTokenVisible() {
        return this.inputPanel.isInputTokensBoxVisible();
    }

    public void selectConsoleTab() {
        this.editor.selectConsoleTab();
    }

    public DBOutputPanel getOutputPanel() {
        return this.outputPanel;
    }

    public DBRecorder getRecorder() {
        return this.recorder;
    }

    public DBPlayer getPlayer() {
        return this.player;
    }

    public Container getWindowComponent() {
        return this.editor.getWindowContainer();
    }

    public EditorConsole getConsole() {
        return this.editor.getConsole();
    }

    public List<ElementBlock> getBlocks() {
        return this.editor.getBlocks();
    }

    public EditorProvider getProvider() {
        return this.editor;
    }

    public Container getContainer() {
        return this.panel;
    }

    public void updateStatusInfo() {
        this.controlPanel.updateStatusInfo();
    }

    public void breaksOnEvent() {
        this.inputPanel.updateOnBreakEvent();
        this.parseTreePanel.updateOnBreakEvent();
        this.astPanel.updateOnBreakEvent();
        this.stackPanel.updateOnBreakEvent();
        this.eventsPanel.updateOnBreakEvent();
    }

    public EngineGrammar getGrammar() {
        return this.editor.getEngineGrammar();
    }

    public boolean needsToGenerateGrammar() {
        return this.dateOfModificationOnDisk != this.editor.getDocument().getDateOfModificationOnDisk() || this.editor.getDocument().isDirty();
    }

    public void grammarGenerated() {
        this.editor.getDocument().performAutoSave();
        this.dateOfModificationOnDisk = this.editor.getDocument().getDateOfModificationOnDisk();
    }

    public void queryGrammarBreakpoints() {
        this.breakpoints = this.editor.breakpointManager.getBreakpoints();
    }

    public boolean isBreakpointAtLine(int n) {
        if (this.breakpoints == null) {
            return false;
        }
        return this.breakpoints.contains(n);
    }

    public boolean isBreakpointAtToken(Token token) {
        return this.inputPanel.isBreakpointAtToken(token);
    }

    public void selectToken(Token token, int n, int n2) {
        if (token != null) {
            DBInputTextTokenInfo dBInputTextTokenInfo = this.inputPanel.getTokenInfoForToken(token);
            if (dBInputTextTokenInfo == null) {
                this.setGrammarPosition(n, n2);
            } else {
                this.setGrammarPosition(dBInputTextTokenInfo.line, dBInputTextTokenInfo.charInLine);
            }
        } else {
            this.setGrammarPosition(n, n2);
        }
        this.inputPanel.selectToken(token);
        this.parseTreePanel.selectToken(token);
        this.astPanel.selectToken(token);
    }

    public void setGrammarPosition(int n, int n2) {
        this.grammarIndex = this.computeAbsoluteGrammarIndex(n, n2);
        if (this.grammarIndex >= 0) {
            if (this.editor.getTextPane().hasFocus()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Debugger.this.editor.selectTextRange(Debugger.this.grammarIndex, Debugger.this.grammarIndex + 1);
                    }
                });
            } else {
                this.editor.selectTextRange(this.grammarIndex, this.grammarIndex + 1);
            }
        }
    }

    public void markLocationInGrammar(int n) {
        try {
            this.editor.setCaretPosition(n);
            this.debuggerCursorIndex = n;
        }
        catch (Exception exception) {
            this.getConsole().print(exception);
        }
    }

    public void resetMarkLocationInGrammar() {
        this.debuggerCursorIndex = -1;
    }

    public int getDebuggerCursorIndex() {
        return this.debuggerCursorIndex;
    }

    public List<ElementRule> getRules() {
        return this.editor.getRules();
    }

    public List<ElementRule> getSortedRules() {
        return this.editor.getSortedRules();
    }

    public String getEventsAsString() {
        return this.eventsPanel.getEventsAsString();
    }

    public int getNumberOfEvents() {
        return this.eventsPanel.getNumberOfEvents();
    }

    public void launchLocalDebugger(int n) {
        if (this.getGrammar().getType() == 3) {
            XJAlert.display(this.editor.getWindowContainer(), "Unsupported Grammar Type", "ANTLRWorks supports tree grammar debugging only if you \"debug remote\".");
            return;
        }
        if (this.needsToGenerateGrammar()) {
            if (AWPrefs.getDebuggerAskGen()) {
                int n2 = XJAlert.displayCustomAlert(this.editor.getWindowContainer(), "Generate and compile", "The grammar has been modified and needs to be generated and compiled again. You can choose to cancel the operation, to continue without generating and compiling the grammar or to generate and compile the grammar.", new String[]{"Cancel", "Continue", "Generate and compile"}, 2, 0);
                switch (n2) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        n |= 2;
                    }
                }
            } else {
                n |= 2;
            }
        }
        if ((n & 2) > 0 && !this.editor.ensureDocumentSaved()) {
            return;
        }
        if ((n & 2) > 0 || !this.local.isRequiredFilesExisting()) {
            this.local.prepareAndLaunch(n);
            this.grammarGenerated();
        } else {
            this.local.prepareAndLaunch(n);
        }
    }

    public void debuggerLocalDidRun(boolean bl) {
        if (bl) {
            StatisticsAW.shared().recordEvent(93);
        } else {
            StatisticsAW.shared().recordEvent(92);
        }
        this.debuggerLaunch(DEFAULT_LOCAL_ADDRESS, AWPrefs.getDebugDefaultLocalPort(), false);
    }

    public void launchRemoteDebugger() {
        StatisticsAW.shared().recordEvent(94);
        DBRemoteConnectDialog dBRemoteConnectDialog = new DBRemoteConnectDialog(this.getWindowComponent());
        if (dBRemoteConnectDialog.runModal() == 1) {
            this.debuggerLaunch(dBRemoteConnectDialog.getAddress(), dBRemoteConnectDialog.getPort(), true);
        }
    }

    public void debuggerLaunch(String string, int n, boolean bl) {
        if (bl && !this.debuggerLaunchGrammar()) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot launch the debugger.\nException while parsing grammar.");
            return;
        }
        this.queryGrammarBreakpoints();
        this.inputPanel.prepareForGrammar(this.getGrammar());
        this.player.setInputBuffer(this.inputPanel.getInputBuffer());
        this.recorder.connect(string, n);
    }

    public void connectionSuccess() {
        this.running = true;
        XJNotificationCenter.defaultCenter().postNotification(this, NOTIF_DEBUG_STARTED);
        this.editor.selectDebuggerTab();
        this.editor.console.makeCurrent();
        this.editor.getTextPane().setEditable(false);
        this.editor.getTextPane().getCaret().setVisible(false);
        this.player.resetPlayEvents(true);
    }

    public void connectionFailed() {
        XJAlert.display(this.editor.getWindowContainer(), "Connection Error", "Cannot launch the debugger.\nTime-out waiting to connect to the remote parser.");
    }

    public void connectionCancelled() {
    }

    public boolean debuggerLaunchGrammar() {
        try {
            this.getGrammar().analyze();
        }
        catch (Exception exception) {
            this.editor.getConsole().print(exception);
            return false;
        }
        return true;
    }

    public void debuggerStop(boolean bl) {
        if (this.recorder.getStatus() == 1) {
            if (bl || XJAlert.displayAlertYESNO(this.editor.getWindowContainer(), "Stopping", "The debugger is currently stopping. Do you want to force stop it ?") == 0) {
                this.local.forceStop();
                this.recorder.stop();
            }
        } else {
            this.recorder.requestStop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void resetGUI() {
        this.stackPanel.clear();
        this.eventsPanel.clear();
        this.parseTreePanel.clear();
        this.astPanel.clear();
    }

    public int computeAbsoluteGrammarIndex(int n, int n2) {
        List<ATELine> list = this.editor.getLines();
        if (n - 1 < 0 || n - 1 >= list.size()) {
            return -1;
        }
        ATELine aTELine = list.get(n - 1);
        return aTELine.position + n2 - 1;
    }

    public void addEvent(DBEvent dBEvent, DBPlayerContextInfo dBPlayerContextInfo) {
        this.eventsPanel.addEvent(dBEvent, dBPlayerContextInfo);
    }

    public void playEvents(List list, boolean bl) {
        this.player.playEvents(list, bl);
        this.breaksOnEvent();
    }

    public void playerSetLocation(int n, int n2) {
        this.parseTreeModel.setLocation(n, n2);
    }

    public void playerPushRule(String string) {
        this.stackPanel.pushRule(string);
        this.parseTreeModel.pushRule(string);
        this.astModel.pushRule(string);
    }

    public void playerPopRule(String string) {
        this.stackPanel.popRule();
        this.parseTreeModel.popRule();
        this.astModel.popRule();
    }

    public void playerConsumeToken(Token token) {
        this.parseTreeModel.addToken(token);
    }

    public void playerRecognitionException(Exception exception) {
        this.parseTreeModel.addException(exception);
    }

    public void playerBeginBacktrack(int n) {
        this.parseTreeModel.beginBacktrack(n);
    }

    public void playerEndBacktrack(int n, boolean bl) {
        this.parseTreeModel.endBacktrack(n, bl);
    }

    public void playerNilNode(int n) {
        this.astModel.nilNode(n);
    }

    public void playerErrorNode(int n, String string) {
        this.astModel.errorNode(n, string);
    }

    public void playerCreateNode(int n, Token token) {
        this.astModel.createNode(n, token);
    }

    public void playerCreateNode(int n, String string, int n2) {
        this.astModel.createNode(n, new ClassicToken(n2, string));
    }

    public void playerBecomeRoot(int n, int n2) {
        this.astModel.becomeRoot(n, n2);
    }

    public void playerAddChild(int n, int n2) {
        this.astModel.addChild(n, n2);
    }

    public void playerSetTokenBoundaries(int n, int n2, int n3) {
    }

    public void recorderStatusDidChange() {
        if (this.closing) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Debugger.this.updateStatusInfo();
            }
        });
    }

    public void recorderDidStop() {
        if (this.closing) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Debugger.this.resetMarkLocationInGrammar();
                Debugger.this.editor.getTextPane().setEditable(true);
                Debugger.this.editor.getTextPane().requestFocusInWindow();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Debugger.this.editor.getTextPane().getCaret().setVisible(true);
                    }
                });
                Debugger.this.inputPanel.stop();
                Debugger.this.running = false;
                Debugger.this.editor.refreshMainMenuBar();
                XJNotificationCenter.defaultCenter().postNotification(this, Debugger.NOTIF_DEBUG_STOPPED);
            }
        });
    }

    @Override
    public boolean canExportToBitmap() {
        return this.getExportableGView() != null;
    }

    @Override
    public boolean canExportToEPS() {
        return this.getExportableGView() != null;
    }

    @Override
    public GView getExportableGView() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (Utils.isComponentChildOf(component, this.parseTreePanel)) {
            return this.parseTreePanel.getGraphView();
        }
        if (Utils.isComponentChildOf(component, this.astPanel)) {
            return this.astPanel.getGraphView();
        }
        return null;
    }

    @Override
    public String getTabName() {
        return "Debugger";
    }

    @Override
    public Component getTabComponent() {
        return this.getContainer();
    }

    public JPopupMenu treeGetContextualMenu() {
        ContextualMenuFactory contextualMenuFactory = new ContextualMenuFactory(this.editor.editorMenu);
        contextualMenuFactory.addItem(111);
        contextualMenuFactory.addItem(110);
        return contextualMenuFactory.menu;
    }

    public void setPersistentData(Map map) {
        if (map == null) {
            return;
        }
    }

    public Map getPersistentData() {
        return new HashMap();
    }

    @Override
    public void panelDoDetach(DetachablePanel detachablePanel) {
        this.splitPanel.setComponent(null, detachablePanel.getTag());
    }

    @Override
    public void panelDoAttach(DetachablePanel detachablePanel) {
        Component component = this.splitPanel.getComponentAtIndex(detachablePanel.getTag());
        if (component != null) {
            component.setVisible(false);
            this.splitPanel.setComponent(null, detachablePanel.getTag());
            CustomToggleButton customToggleButton = this.components2toggle.get(component);
            customToggleButton.setSelected(false);
        }
        this.splitPanel.setComponent(detachablePanel, detachablePanel.getTag());
    }

    @Override
    public void panelDoClose(DetachablePanel detachablePanel) {
        CustomToggleButton customToggleButton = this.components2toggle.get(detachablePanel);
        customToggleButton.setSelected(false);
    }

    @Override
    public Container panelParentContainer() {
        return this.editor.getJavaContainer();
    }

    public boolean canDebugAgain() {
        return this.local.canDebugAgain();
    }

    public void warning(Object object, String string) {
        this.getConsole().println("[" + object.getClass().getName() + " - event " + this.getNumberOfEvents() + "] Warning: " + string, 1);
    }

    public String getOutputPath() {
        return this.editor.getOutputPath();
    }
}

