/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.JLabel;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATEPanelDelegate;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.syntax.language.ATELanguageSyntaxEngine;
import org.antlr.works.components.ComponentContainer;
import org.antlr.works.components.ComponentEditor;
import org.antlr.works.prefs.AWPrefs;

public class CEditorText
extends ComponentEditor
implements ATEPanelDelegate {
    protected ATEPanel textEditor;
    protected ATELanguageSyntaxEngine syntaxEngine;
    protected JLabel cursorLabel;

    public CEditorText(ComponentContainer componentContainer) {
        super(componentContainer);
    }

    public void create() {
        this.syntaxEngine = this.createLanguageEngine();
        this.textEditor = new ATEPanel(this.getXJFrame());
        this.textEditor.setParserEngine(this.syntaxEngine);
        this.textEditor.setSyntaxColoring(true);
        this.textEditor.setAnalysisColumnVisible(false);
        this.textEditor.setDelegate(this);
        this.applyPrefs();
        this.cursorLabel = new JLabel();
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.cursorLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(CEditorText.createSeparator());
    }

    public void assemble() {
        this.mainPanel.add((Component)this.textEditor, "Center");
    }

    public ATELanguageSyntaxEngine createLanguageEngine() {
        return new ATELanguageSyntaxEngine();
    }

    public void applyPrefs() {
        this.textEditor.setFoldingEnabled(AWPrefs.getFoldingEnabled());
        this.textEditor.setLineNumberEnabled(AWPrefs.getLineNumberEnabled());
        this.textEditor.setHighlightCursorLine(AWPrefs.getHighlightCursorEnabled());
        this.textEditor.refresh();
        this.applyFont();
    }

    public void applyFont() {
        this.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
    }

    public void loadText(String string) {
        this.textEditor.loadText(string);
    }

    public String getText() {
        return this.getTextPane().getText();
    }

    public void close() {
        super.close();
    }

    public void notificationPrefsChanged() {
        this.applyPrefs();
    }

    public void componentDocumentContentChanged() {
        int n = this.getTextPane().getCaretPosition();
        this.getDocument().reload();
        this.getTextPane().setCaretPosition(n);
    }

    public void componentIsSelected() {
        this.getTextPane().requestFocusInWindow();
    }

    public ATETextPane getTextPane() {
        return this.textEditor.getTextPane();
    }

    public void ateCaretUpdate(int n) {
        this.cursorLabel.setText(this.textEditor.getCurrentLinePosition() + ":" + this.textEditor.getCurrentColumnPosition());
    }

    public void ateChangeUpdate(int n, int n2, boolean bl) {
        this.container.setDirty();
    }

    public void ateAutoIndent(int n, int n2) {
    }

    public void ateMousePressed(Point point) {
    }

    public void ateMouseExited() {
    }

    public void ateMouseMoved(Point point) {
    }

    public void ateInvokePopUp(Component component, int n, int n2) {
    }

    public void ateParserWillParse() {
    }

    public void ateParserDidParse() {
    }
}

