/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.project.file;

import java.util.HashMap;
import java.util.Map;
import org.antlr.works.components.ComponentContainer;
import org.antlr.works.components.ComponentDocument;
import org.antlr.works.components.ComponentEditor;
import org.antlr.works.components.project.CContainerProject;
import org.antlr.works.project.ProjectFileItem;
import org.antlr.xjlib.appkit.document.XJDataPlainText;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuBarCustomizer;
import org.antlr.xjlib.appkit.menu.XJMenuBarDelegate;
import org.antlr.xjlib.appkit.menu.XJMenuItem;

public abstract class CContainerProjectFile
implements ComponentContainer,
XJMenuBarCustomizer,
XJMenuBarDelegate {
    public CContainerProject project;
    public ProjectFileItem item;
    public ComponentEditor editor;
    public ComponentDocument document;
    public XJMainMenuBar mainMenuBar;
    public static final String KEY_EDITOR_DATA = "KEY_EDITOR_DATA";

    public CContainerProjectFile(CContainerProject cContainerProject, ProjectFileItem projectFileItem) {
        this.project = cContainerProject;
        this.item = projectFileItem;
        this.document = this.createDocument();
        this.document.setJavaContainer(cContainerProject.getJavaContainer());
        this.document.setDocumentData(new XJDataPlainText());
        this.document.setComponentContainer(this);
        this.editor = this.createEditor();
        this.editor.create();
        this.editor.assemble();
        this.editor.componentDidAwake();
        projectFileItem.setComponentContainer(this);
        this.awake();
    }

    public void awake() {
    }

    public abstract ComponentDocument createDocument();

    public abstract ComponentEditor createEditor();

    public void createMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = XJMainMenuBar.createInstance();
            this.mainMenuBar.setCustomizer(this);
            this.mainMenuBar.setDelegate(this);
            this.mainMenuBar.createMenuBar();
        }
    }

    public XJMainMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.createMainMenuBar();
        }
        return this.mainMenuBar;
    }

    public ComponentEditor getEditor() {
        return this.editor;
    }

    public XJDocument getDocument() {
        return this.document;
    }

    public XJFrameInterface getXJFrame() {
        return this.project.getXJFrame();
    }

    public void loadText(String string) {
        this.editor.loadText(string);
    }

    public String getText() {
        return this.editor.getText();
    }

    public void close() {
        this.editor.close();
        this.document.performClose(true);
        if (this.getMainMenuBar() == this.getMainMenuBar()) {
            this.project.setDefaultMainMenuBar();
        }
        XJMainMenuBar.removeInstance(this.getMainMenuBar());
    }

    public boolean willSaveDocument() {
        return this.editor.componentDocumentWillSave();
    }

    public void setDirty() {
        this.getDocument().setDirty(true);
        this.project.fileDidBecomeDirty(this, this.item);
    }

    public void setPersistentData(Map map) {
        if (map == null) {
            return;
        }
        this.getEditor().setPersistentData((Map)map.get(KEY_EDITOR_DATA));
    }

    public Map getPersistentData() {
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        hashMap.put(KEY_EDITOR_DATA, this.getEditor().getPersistentData());
        return hashMap;
    }

    public void customizeFileMenu(XJMenu xJMenu) {
        this.project.customizeFileMenu(xJMenu);
        this.editor.customizeFileMenu(xJMenu);
    }

    public void customizeEditMenu(XJMenu xJMenu) {
        this.project.customizeEditMenu(xJMenu);
        this.editor.customizeEditMenu(xJMenu);
    }

    public void customizeWindowMenu(XJMenu xJMenu) {
        this.project.customizeWindowMenu(xJMenu);
        this.editor.customizeWindowMenu(xJMenu);
    }

    public void customizeHelpMenu(XJMenu xJMenu) {
        this.project.customizeHelpMenu(xJMenu);
        this.editor.customizeHelpMenu(xJMenu);
    }

    public void customizeMenuBar(XJMainMenuBar xJMainMenuBar) {
        this.project.customizeMenuBar(xJMainMenuBar);
        this.editor.customizeMenuBar(xJMainMenuBar);
    }

    public void menuItemState(XJMenuItem xJMenuItem) {
        this.project.menuItemState(xJMenuItem);
        this.editor.menuItemState(xJMenuItem);
    }

    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
        this.project.handleMenuEvent(xJMenu, xJMenuItem);
    }

    public void handleMenuSelected(XJMenu xJMenu) {
        this.project.handleMenuSelected(xJMenu);
    }
}

