/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.antlr.works.components.ComponentContainer;
import org.antlr.works.components.ComponentEditor;
import org.antlr.works.components.ComponentStatusBar;
import org.antlr.works.components.project.CDocumentProject;
import org.antlr.works.components.project.file.CContainerProjectFile;
import org.antlr.works.project.ProjectBuildList;
import org.antlr.works.project.ProjectBuilder;
import org.antlr.works.project.ProjectConsole;
import org.antlr.works.project.ProjectData;
import org.antlr.works.project.ProjectEditorZone;
import org.antlr.works.project.ProjectExplorer;
import org.antlr.works.project.ProjectFileItem;
import org.antlr.works.project.ProjectRunSettingsDialog;
import org.antlr.works.project.ProjectSettingsDialog;
import org.antlr.works.project.ProjectToolbar;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.foundation.XJUtils;

public class CContainerProject
extends XJWindow
implements ComponentContainer,
XJMenuItemDelegate {
    protected XJMainMenuBar projectDefaultMainMenuBar;
    protected JSplitPane splitPaneA;
    protected JSplitPane splitPaneB;
    protected JPanel projectPanel;
    protected Box projectStatusBar;
    protected ProjectToolbar projectToolbar;
    protected ProjectExplorer explorer;
    protected ProjectEditorZone editorZone;
    protected ProjectBuilder builder = new ProjectBuilder(this);
    protected ProjectConsole console = new ProjectConsole();
    protected ProjectBuildList buildList = new ProjectBuildList();
    public static final String KEY_WINDOW_LOC = "KEY_WINDOW_LOC";
    public static final String KEY_WINDOW_SIZE = "KEY_WINDOW_SIZE";
    public static final String KEY_SPLITPANE_A = "KEY_SPLITPANE_A";
    public static final String KEY_SPLITPANE_B = "KEY_SPLITPANE_B";
    public static final int MI_CLEAN = 500;
    public static final int MI_BUILD_FILE = 501;
    public static final int MI_BUILD_ALL = 502;
    public static final int MI_RUN = 503;
    public static final int MI_RUN_SETTINGS = 504;
    public static final int MI_SETTINGS = 505;
    public static final int MI_CLOSE_EDITOR = 506;
    public static final int MI_MOVE_EDITOR_LEFT = 507;
    public static final int MI_MOVE_EDITOR_RIGHT = 508;

    public CContainerProject() {
        this.projectPanel = new JPanel(new BorderLayout());
        this.projectToolbar = new ProjectToolbar(this);
        this.projectPanel.add((Component)this.projectToolbar.getToolbar(), "North");
        this.projectStatusBar = new ComponentStatusBar();
        this.projectStatusBar.setPreferredSize(new Dimension(0, 30));
        this.projectPanel.add((Component)this.projectStatusBar, "South");
        this.explorer = new ProjectExplorer(this);
        this.editorZone = new ProjectEditorZone(this);
        this.splitPaneA = new JSplitPane();
        this.splitPaneA.setBorder(null);
        this.splitPaneA.setOrientation(1);
        this.splitPaneA.setLeftComponent(this.explorer.getPanel());
        this.splitPaneA.setRightComponent(this.editorZone.getPanel());
        this.splitPaneA.setContinuousLayout(true);
        this.splitPaneA.setOneTouchExpandable(true);
        this.splitPaneA.setDividerLocation(150);
        this.splitPaneB = new JSplitPane();
        this.splitPaneB.setBorder(null);
        this.splitPaneB.setOrientation(0);
        this.splitPaneB.setLeftComponent(this.splitPaneA);
        this.splitPaneB.setRightComponent(this.console.getContainer());
        this.splitPaneB.setContinuousLayout(true);
        this.splitPaneB.setOneTouchExpandable(true);
        this.splitPaneB.setDividerLocation(this.getRootPane().getPreferredSize().height);
        this.projectPanel.add((Component)this.splitPaneB, "Center");
        this.getContentPane().add(this.projectPanel);
        this.pack();
    }

    public void awake() {
        super.awake();
        this.getData().setProject(this);
        this.projectDefaultMainMenuBar = this.mainMenuBar;
    }

    public void setDefaultSize() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        rectangle.height = (int)((double)rectangle.height * 0.75);
        rectangle.width = (int)((double)rectangle.width * 0.8);
        this.getRootPane().setPreferredSize(rectangle.getSize());
    }

    public void setToolBar(JComponent jComponent) {
        this.projectToolbar.setCustomToolbar(jComponent);
    }

    public void setStatusBar(JComponent jComponent) {
        if (this.projectStatusBar.getComponentCount() > 0) {
            this.projectStatusBar.remove(0);
        }
        if (jComponent != null) {
            this.projectStatusBar.add((Component)jComponent, "Center");
        }
        this.projectStatusBar.revalidate();
        this.projectStatusBar.repaint();
    }

    public void setDefaultMainMenuBar() {
        if (this.getMainMenuBar() != this.projectDefaultMainMenuBar) {
            this.setMainMenuBar(this.projectDefaultMainMenuBar);
        }
    }

    public void refreshMainMenuBar() {
        if (this.getXJFrame().getMainMenuBar() != null) {
            this.getXJFrame().getMainMenuBar().refreshState();
        }
    }

    protected String customizeWindowTitle(String string) {
        return super.customizeWindowTitle(string) + " - [Project]";
    }

    public ProjectData getData() {
        return ((CDocumentProject)this.getDocument()).data;
    }

    public ProjectBuildList getBuildList() {
        return this.buildList;
    }

    public String getSourcePath() {
        return this.getData().getSourcePath();
    }

    public void makeBottomComponentVisible() {
        if (this.splitPaneB.getBottomComponent().getHeight() == 0) {
            this.splitPaneB.setDividerLocation(0.6);
        }
    }

    public XJFrameInterface getXJFrame() {
        return this;
    }

    public void becomingVisibleForTheFirstTime() {
        if (this.getDocument().getDocumentPath() == null) {
            this.getDocument().changeDone();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CContainerProject.this.projectSettings();
                }
            });
        }
    }

    public void windowActivated() {
        super.windowActivated();
        if (this.getBuildList().handleExternalModification()) {
            this.changeDone();
        }
        this.explorer.windowActivated();
    }

    public void windowDeactivated() {
        this.explorer.saveAll();
    }

    public void windowDocumentPathDidChange() {
    }

    public void changeDone() {
        this.getDocument().changeDone();
    }

    public void openFileItem(ProjectFileItem projectFileItem) {
        if (projectFileItem != null) {
            this.editorZone.openFileItem(projectFileItem);
            this.changeDone();
        }
    }

    public void closeFileItem(ProjectFileItem projectFileItem) {
        this.editorZone.removeFileItemFromTab(projectFileItem);
        projectFileItem.close();
    }

    public List getFileEditorItems() {
        return this.explorer.getFileEditorItems();
    }

    public String[] getRunParameters() {
        String string = this.getData().getRunParametersString();
        if (string == null) {
            return null;
        }
        return string.split(" ");
    }

    public void projectSettings() {
        ProjectSettingsDialog projectSettingsDialog = new ProjectSettingsDialog(this.getJavaContainer());
        projectSettingsDialog.setSourcePath(this.getData().getSourcePath());
        if (projectSettingsDialog.runModal() == 1) {
            this.getData().setSourcePath(projectSettingsDialog.getSourcePath());
            this.explorer.reload();
            this.changeDone();
        }
    }

    public void runSettings(boolean bl) {
        ProjectRunSettingsDialog projectRunSettingsDialog = new ProjectRunSettingsDialog(this.getJavaContainer());
        projectRunSettingsDialog.setRunParametersString(this.getData().getRunParametersString());
        projectRunSettingsDialog.setShowBeforeRunning(this.getData().getShowBeforeRunning());
        if (projectRunSettingsDialog.runModal() == 1) {
            this.changeDone();
            this.getData().setRunParametersString(projectRunSettingsDialog.getRunParametersString());
            this.getData().setShowBeforeRunning(projectRunSettingsDialog.isShowBeforeRunning());
            if (bl) {
                this.buildAndRun();
            }
        }
    }

    public void run() {
        String[] stringArray = this.getRunParameters();
        if (stringArray == null || stringArray.length == 0 || this.getData().getShowBeforeRunning()) {
            this.runSettings(true);
        } else {
            this.buildAndRun();
        }
    }

    public void clean() {
        this.builder.clean();
    }

    public void buildFile() {
        ProjectFileItem projectFileItem = this.editorZone.getSelectedFileItem();
        if (projectFileItem != null) {
            this.explorer.saveAll();
            this.clearConsole();
            this.builder.buildFile(projectFileItem);
        }
    }

    public void buildAll() {
        this.explorer.saveAll();
        this.clearConsole();
        this.builder.buildAll();
    }

    public void buildAndRun() {
        this.explorer.saveAll();
        this.clearConsole();
        this.builder.run();
    }

    public void buildReportError(String string) {
        this.printToConsole(string);
    }

    public void clearConsole() {
        this.console.clear();
    }

    public void printToConsole(String string) {
        this.console.print(string);
        this.makeBottomComponentVisible();
    }

    public void printToConsole(Exception exception) {
        this.printToConsole(XJUtils.stackTrace(exception));
    }

    public void close() {
        this.getDocument().performAutoSave();
        this.explorer.close();
        super.close();
    }

    public void setPersistentData(Map map) {
        Integer n;
        Dimension dimension;
        if (map == null) {
            return;
        }
        Point point = (Point)map.get(KEY_WINDOW_LOC);
        if (point != null) {
            this.setLocation(point);
        }
        if ((dimension = (Dimension)map.get(KEY_WINDOW_SIZE)) != null) {
            this.setSize(dimension);
        }
        if ((n = (Integer)map.get(KEY_SPLITPANE_A)) != null) {
            this.splitPaneA.setDividerLocation(n);
        }
        if ((n = (Integer)map.get(KEY_SPLITPANE_B)) != null) {
            this.splitPaneB.setDividerLocation(n);
        }
    }

    public Map getPersistentData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(KEY_WINDOW_LOC, this.getLocation());
        hashMap.put(KEY_WINDOW_SIZE, this.getSize());
        hashMap.put(KEY_SPLITPANE_A, this.splitPaneA.getDividerLocation());
        hashMap.put(KEY_SPLITPANE_B, this.splitPaneB.getDividerLocation());
        return hashMap;
    }

    public void fileDidBecomeDirty(CContainerProjectFile cContainerProjectFile, ProjectFileItem projectFileItem) {
        this.getBuildList().setFileDirty(projectFileItem, true);
        this.changeDone();
    }

    public void documentDidLoad() {
        this.buildList.setPersistentData((Map)this.getData().getBuildListData());
        this.explorer.setPersistentData((Map)this.getData().getExplorerData());
        this.editorZone.setPersistentData((Map)this.getData().getEditorZoneData());
        this.setPersistentData((Map)this.getData().getContainerData());
    }

    public void documentWillSave() {
        this.getData().setBuildListData(this.buildList.getPersistentData());
        this.getData().setExplorerData(this.explorer.getPersistentData());
        this.getData().setEditorZoneData(this.editorZone.getPersistentData());
        this.getData().setContainerData(this.getPersistentData());
        this.explorer.saveAll();
    }

    public void createProjectMenu(XJMainMenuBar xJMainMenuBar) {
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle("Project");
        xJMenu.addItem(new XJMenuItem("Run", 503, this));
        xJMenu.addItem(new XJMenuItem("Edit Run Settings...", 504, this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem("Build All", 502, this));
        xJMenu.addItem(new XJMenuItem("Build File", 501, this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem("Clean", 500, this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem("Move Active Editor Left", 37, XJMenuItem.getKeyModifier() | 2, 507, (XJMenuItemDelegate)this));
        xJMenu.addItem(new XJMenuItem("Move Active Editor Right", 39, XJMenuItem.getKeyModifier() | 2, 508, (XJMenuItemDelegate)this));
        xJMenu.addSeparator();
        xJMenu.addItem(new XJMenuItem("Settings...", 59, 505, this));
        xJMainMenuBar.addCustomMenu(xJMenu);
    }

    public void customizeFileMenu(XJMenu xJMenu) {
        xJMenu.insertItemAfter(new XJMenuItem("Close Active Editor", 115, 506, this), 10005);
    }

    public void customizeMenuBar(XJMainMenuBar xJMainMenuBar) {
        this.createProjectMenu(xJMainMenuBar);
    }

    public void menuItemState(XJMenuItem xJMenuItem) {
        super.menuItemState(xJMenuItem);
        switch (xJMenuItem.getTag()) {
            case 506: 
            case 507: 
            case 508: {
                xJMenuItem.setEnabled(this.editorZone.getSelectedFileItem() != null);
            }
        }
    }

    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
        super.handleMenuEvent(xJMenu, xJMenuItem);
        switch (xJMenuItem.getTag()) {
            case 500: {
                this.clean();
                break;
            }
            case 501: {
                this.buildFile();
                break;
            }
            case 502: {
                this.buildAll();
                break;
            }
            case 503: {
                this.run();
                break;
            }
            case 504: {
                this.runSettings(false);
                break;
            }
            case 505: {
                this.projectSettings();
                break;
            }
            case 506: {
                this.editorZone.closeActiveEditor();
                break;
            }
            case 507: {
                this.editorZone.moveActiveEditor(-1);
                break;
            }
            case 508: {
                this.editorZone.moveActiveEditor(1);
            }
        }
    }

    public void loadText(String string) {
    }

    public String getText() {
        return null;
    }

    public boolean willSaveDocument() {
        return true;
    }

    public ComponentEditor getEditor() {
        return null;
    }
}

