/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.grammar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.antlr.Tool;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATEPanelDelegate;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEThread;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.completion.AutoCompletionMenu;
import org.antlr.works.completion.AutoCompletionMenuDelegate;
import org.antlr.works.completion.RuleTemplates;
import org.antlr.works.components.ComponentContainer;
import org.antlr.works.components.ComponentEditor;
import org.antlr.works.components.grammar.CEditorGrammarDefaultDelegate;
import org.antlr.works.components.grammar.CEditorGrammarDelegate;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.editor.EditorATEEditorKit;
import org.antlr.works.editor.EditorAnalysisManager;
import org.antlr.works.editor.EditorBreakpointManager;
import org.antlr.works.editor.EditorConsole;
import org.antlr.works.editor.EditorFoldingManager;
import org.antlr.works.editor.EditorIdeas;
import org.antlr.works.editor.EditorInspector;
import org.antlr.works.editor.EditorMenu;
import org.antlr.works.editor.EditorPersistence;
import org.antlr.works.editor.EditorProvider;
import org.antlr.works.editor.EditorRules;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.editor.EditorTips;
import org.antlr.works.editor.EditorToolbar;
import org.antlr.works.editor.EditorUnderlyingManager;
import org.antlr.works.editor.InspectorDelegate;
import org.antlr.works.find.FindAndReplace;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.grammar.EngineGrammarDelegate;
import org.antlr.works.grammar.decisiondfa.DecisionDFAEngine;
import org.antlr.works.interpreter.EditorInterpreter;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.menu.MenuDebugger;
import org.antlr.works.menu.MenuExport;
import org.antlr.works.menu.MenuFind;
import org.antlr.works.menu.MenuFolding;
import org.antlr.works.menu.MenuGenerate;
import org.antlr.works.menu.MenuGoTo;
import org.antlr.works.menu.MenuGrammar;
import org.antlr.works.menu.MenuRefactor;
import org.antlr.works.menu.MenuSCM;
import org.antlr.works.navigation.GoToHistory;
import org.antlr.works.navigation.GoToRule;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.syntax.GrammarAutoIndent;
import org.antlr.works.syntax.GrammarSyntax;
import org.antlr.works.syntax.GrammarSyntaxDelegate;
import org.antlr.works.syntax.GrammarSyntaxEngine;
import org.antlr.works.syntax.GrammarSyntaxParser;
import org.antlr.works.syntax.element.ElementAction;
import org.antlr.works.syntax.element.ElementBlock;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.Utils;
import org.antlr.works.visualization.Visual;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.swing.XJTree;
import org.antlr.xjlib.appkit.text.XJURLLabel;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEditorGrammar
extends ComponentEditor
implements AutoCompletionMenuDelegate,
EditorProvider,
ATEPanelDelegate,
XJUndoDelegate,
InspectorDelegate,
GrammarSyntaxDelegate,
EngineGrammarDelegate {
    public AutoCompletionMenu autoCompletionMenu;
    public RuleTemplates ruleTemplates;
    public FindAndReplace findAndReplace;
    public DecisionDFAEngine decisionDFAEngine;
    public GoToRule goToRule;
    public GoToHistory goToHistory;
    public EditorBreakpointManager breakpointManager;
    public EditorFoldingManager foldingManager;
    public EditorUnderlyingManager underlyingManager;
    public EditorAnalysisManager analysisManager;
    public GrammarSyntaxEngine parserEngine;
    public EditorRules rules;
    public Visual visual;
    public EditorInterpreter interpreter;
    public Debugger debugger;
    public EditorConsole console;
    public EditorToolbar toolbar;
    public EditorMenu editorMenu;
    public EditorIdeas editorIdeas;
    public EditorTips editorTips;
    public EditorInspector editorInspector;
    public EditorPersistence persistence;
    public MenuFolding menuFolding;
    public MenuFind menuFind;
    public MenuGrammar menuGrammar;
    public MenuRefactor menuRefactor;
    public MenuGoTo menuGoTo;
    public MenuGenerate menuGenerate;
    public MenuDebugger menuDebugger;
    public MenuSCM menuSCM;
    public MenuExport menuExport;
    public ATEPanel textEditor;
    protected JScrollPane rulesScrollPane;
    protected XJTree rulesTree;
    protected JTabbedPane tabbedPane;
    protected JLabel infoLabel;
    protected JLabel cursorLabel;
    protected JLabel writableLabel;
    protected JLabel scmLabel;
    protected ConsoleStatus consoleStatus;
    protected JSplitPane rulesTextSplitPane;
    protected JSplitPane upDownSplitPane;
    protected boolean windowFirstDisplay = true;
    protected String lastSelectedRule;
    protected CEditorGrammarDelegate delegate;
    protected List<EditorTab> tabs = new ArrayList<EditorTab>();
    protected AfterParseOperations afterParserOp;
    protected EngineGrammar engineGrammar;
    protected GrammarSyntax grammarSyntax;
    private XJDialogProgress progress;
    protected EditorATEEditorKit editorKit;
    protected MouseListener ml;
    protected ChangeListener cl;
    public boolean wasSaving = false;
    public static final String KEY_SPLITPANE_A = "KEY_SPLITPANE_A";
    public static final String KEY_SPLITPANE_B = "KEY_SPLITPANE_B";
    public static final String KEY_INTERPRETER = "KEY_INTERPRETER";
    public static final String KEY_DEBUGGER = "KEY_DEBUGGER";

    public CEditorGrammar(ComponentContainer componentContainer) {
        super(componentContainer);
    }

    public void setDelegate(CEditorGrammarDelegate cEditorGrammarDelegate) {
        this.delegate = cEditorGrammarDelegate;
    }

    @Override
    public void create() {
        this.initCore();
        this.createInterface();
        this.initEditor();
        this.initMenus();
        this.initManagers();
        this.initComponents();
        this.initAutoCompletion();
        this.initTools();
        this.awakeInstances();
        this.awakeInterface();
        this.register();
    }

    @Override
    public void assemble() {
        this.rulesTextSplitPane = new JSplitPane();
        this.rulesTextSplitPane.setBorder(null);
        this.rulesTextSplitPane.setOrientation(1);
        this.rulesTextSplitPane.setLeftComponent(this.rulesScrollPane);
        this.rulesTextSplitPane.setRightComponent(this.textEditor);
        this.rulesTextSplitPane.setContinuousLayout(true);
        this.rulesTextSplitPane.setOneTouchExpandable(true);
        this.upDownSplitPane = new JSplitPane();
        this.upDownSplitPane.setBorder(null);
        this.upDownSplitPane.setOrientation(0);
        this.upDownSplitPane.add((Component)this.rulesTextSplitPane, "top");
        this.upDownSplitPane.add((Component)this.tabbedPane, "bottom");
        this.upDownSplitPane.setContinuousLayout(true);
        this.upDownSplitPane.setOneTouchExpandable(true);
        this.delegate = new CEditorGrammarDefaultDelegate(this.upDownSplitPane);
        this.mainPanel.add((Component)this.upDownSplitPane, "Center");
    }

    protected void initComponents() {
        this.rules = new EditorRules(this, this.rulesTree);
        this.visual = new Visual(this);
    }

    protected void initTools() {
        this.goToRule = new GoToRule(this, this.getXJFrame(), this.getTextPane());
        this.goToHistory = new GoToHistory();
        this.findAndReplace = new FindAndReplace(this);
    }

    protected void initAutoCompletion() {
        if (this.autoCompletionMenu != null) {
            this.autoCompletionMenu.close();
        }
        this.autoCompletionMenu = new AutoCompletionMenu(this, this.getTextPane(), this.getXJFrame());
        if (this.ruleTemplates != null) {
            this.ruleTemplates.close();
        }
        this.ruleTemplates = new RuleTemplates(this, this.getTextPane(), this.getXJFrame());
    }

    protected void initCore() {
        this.afterParserOp = new AfterParseOperations();
        this.decisionDFAEngine = new DecisionDFAEngine(this);
        this.parserEngine = new GrammarSyntaxEngine();
        this.grammarSyntax = new GrammarSyntax(this);
        this.interpreter = new EditorInterpreter(this);
        this.debugger = new Debugger(this);
    }

    protected void initEditor() {
        this.console = new EditorConsole(this);
        this.console.makeCurrent();
        this.editorMenu = new EditorMenu(this);
        this.editorIdeas = new EditorIdeas(this);
        this.editorTips = new EditorTips(this);
        this.editorInspector = new EditorInspector(this.grammarSyntax, this.decisionDFAEngine, this);
        this.persistence = new EditorPersistence(this);
        this.engineGrammar = new EngineGrammar(this);
        this.engineGrammar.setDelegate(this);
    }

    protected void initMenus() {
        this.menuFolding = new MenuFolding(this);
        this.menuFind = new MenuFind(this);
        this.menuGrammar = new MenuGrammar(this);
        this.menuRefactor = new MenuRefactor(this);
        this.menuGoTo = new MenuGoTo(this);
        this.menuGenerate = new MenuGenerate(this);
        this.menuDebugger = new MenuDebugger(this);
        this.menuSCM = new MenuSCM(this);
        this.menuExport = new MenuExport(this);
    }

    protected void initManagers() {
        this.breakpointManager = new EditorBreakpointManager(this);
        this.textEditor.setBreakpointManager(this.breakpointManager);
        this.foldingManager = new EditorFoldingManager(this);
        this.textEditor.setFoldingManager(this.foldingManager);
        this.underlyingManager = new EditorUnderlyingManager(this);
        this.textEditor.setUnderlyingManager(this.underlyingManager);
        this.analysisManager = new EditorAnalysisManager(this);
        this.textEditor.setAnalysisManager(this.analysisManager);
    }

    protected void awakeInstances() {
        this.editorIdeas.awake();
        this.editorTips.awake();
        this.menuSCM.awake();
        this.interpreter.awake();
        this.debugger.awake();
        this.toolbar.awake();
        this.rules.setKeyBindings(this.textEditor.getKeyBindings());
        this.textEditor.setParserEngine(this.parserEngine);
    }

    protected void createTextEditor() {
        this.textEditor = new ATEPanel(this.getXJFrame());
        this.editorKit = new EditorATEEditorKit(this);
        this.textEditor.setEditorKit(this.editorKit);
        this.textEditor.setSyntaxColoring(true);
        this.textEditor.setDelegate(this);
        this.applyPrefs();
    }

    protected void createRulesPane() {
        this.rulesTree = new RuleTree();
        this.rulesTree.setBorder(null);
        this.rulesTree.setToolTipText("");
        this.rulesTree.setDragEnabled(true);
        this.rulesScrollPane = new JScrollPane(this.rulesTree);
        this.rulesScrollPane.setWheelScrollingEnabled(true);
    }

    public JComponent getRulesComponent() {
        return this.rulesScrollPane;
    }

    protected void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(3);
        this.ml = new TabbedPaneMouseListener();
        this.tabbedPane.addMouseListener(this.ml);
        this.cl = new TabbedPaneChangeListener();
        this.tabbedPane.addChangeListener(this.cl);
    }

    public JComponent getTabbedComponent() {
        return this.tabbedPane;
    }

    protected void createToolbar() {
        this.toolbar = new EditorToolbar(this);
    }

    protected void createStatusBar() {
        this.infoLabel = new JLabel();
        this.cursorLabel = new JLabel();
        this.writableLabel = new JLabel();
        this.scmLabel = new JLabel();
        this.consoleStatus = new ConsoleStatus();
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.infoLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(CEditorGrammar.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.cursorLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(CEditorGrammar.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.writableLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(CEditorGrammar.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.consoleStatus.getPanel());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(CEditorGrammar.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.scmLabel);
        this.statusBar.add(Box.createHorizontalGlue());
    }

    protected void createInterface() {
        this.createTextEditor();
        this.createRulesPane();
        this.createTabbedPane();
        this.createToolbar();
        this.createStatusBar();
    }

    protected void awakeInterface() {
        this.addTab(this.visual);
        this.addTab(this.interpreter);
        this.addTab(this.debugger);
        this.addTab(this.console);
        this.selectVisualizationTab();
    }

    protected void register() {
        this.getXJFrame().registerUndo(this, this.getTextPane());
    }

    public void applyPrefs() {
        this.afterParserOp.setDefaultThreshold(AWPrefs.getParserDelay());
        this.textEditor.setFoldingEnabled(AWPrefs.getFoldingEnabled());
        this.textEditor.setLineNumberEnabled(AWPrefs.getLineNumberEnabled());
        this.textEditor.setHighlightCursorLine(AWPrefs.getHighlightCursorEnabled());
        this.textEditor.refresh();
        this.initAutoCompletion();
        this.applyFont();
    }

    public void applyFont() {
        this.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
    }

    @Override
    public void close() {
        this.goToRule.close();
        this.findAndReplace.close();
        this.autoCompletionMenu.close();
        this.ruleTemplates.close();
        this.decisionDFAEngine.close();
        this.grammarSyntax.close();
        this.interpreter.close();
        this.debugger.close();
        this.console.close();
        this.editorMenu.close();
        this.editorIdeas.close();
        this.editorTips.close();
        this.editorInspector.close();
        this.persistence.close();
        this.engineGrammar.close();
        this.parserEngine.close();
        this.rules.close();
        this.visual.close();
        this.afterParserOp.stop();
        this.afterParserOp = null;
        this.menuFolding.close();
        this.menuFind.close();
        this.menuGrammar.close();
        this.menuRefactor.close();
        this.menuGoTo.close();
        this.menuGenerate.close();
        this.menuDebugger.close();
        this.menuSCM.close();
        this.menuExport.close();
        this.breakpointManager.close();
        this.foldingManager.close();
        this.underlyingManager.close();
        this.analysisManager.close();
        this.textEditor.close();
        this.toolbar.close();
        this.getXJFrame().unregisterUndo(this);
        this.editorKit.close();
        this.tabbedPane.removeMouseListener(this.ml);
        this.tabbedPane.removeChangeListener(this.cl);
        this.ml = null;
        this.cl = null;
        this.consoleStatus = null;
        this.rulesTree.close();
        this.rulesTree = null;
        super.close();
    }

    public void selectVisualizationTab() {
        this.selectTab(this.visual.getTabComponent());
    }

    public void selectInterpreterTab() {
        this.selectTab(this.interpreter.getTabComponent());
        this.makeBottomComponentVisible();
    }

    public void selectDebuggerTab() {
        this.selectTab(this.debugger.getTabComponent());
        this.makeBottomComponentVisible();
    }

    public void selectConsoleTab() {
        this.selectTab(this.console.getTabComponent());
        this.makeBottomComponentVisible();
    }

    public void addTab(EditorTab editorTab) {
        int n = this.getSimilarTab(editorTab);
        if (n > 3) {
            this.tabs.remove(n);
            this.tabs.add(n, editorTab);
            this.tabbedPane.removeTabAt(n);
            this.tabbedPane.insertTab(editorTab.getTabName(), null, editorTab.getTabComponent(), null, n);
        } else {
            this.tabs.add(editorTab);
            this.tabbedPane.add(editorTab.getTabName(), editorTab.getTabComponent());
        }
        this.selectTab(editorTab.getTabComponent());
    }

    public int getSimilarTab(EditorTab editorTab) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            EditorTab editorTab2 = this.tabs.get(i);
            if (!editorTab2.getTabName().equals(editorTab.getTabName())) continue;
            return i;
        }
        return -1;
    }

    public EditorTab getSelectedTab() {
        return this.tabs.get(this.tabbedPane.getSelectedIndex());
    }

    public void selectTab(Component component) {
        if (this.tabbedPane.getSelectedComponent() != component) {
            this.tabbedPane.setSelectedComponent(component);
            this.refreshMainMenuBar();
        }
    }

    public void makeBottomComponentVisible() {
        if (!this.isBottomComponentVisible()) {
            this.setBottomComponentVisible(true);
        }
    }

    public void setBottomComponentVisible(boolean bl) {
        if (this.delegate != null) {
            this.delegate.setBottomComponentVisible(bl);
        }
    }

    public boolean isBottomComponentVisible() {
        return this.delegate != null && this.delegate.isBottomComponentVisible();
    }

    @Override
    public JComponent getToolbarComponent() {
        return this.toolbar.getToolbar();
    }

    @Override
    public EngineGrammar getEngineGrammar() {
        return this.engineGrammar;
    }

    @Override
    public EditorConsole getConsole() {
        return this.console;
    }

    public ATETextPane getTextPane() {
        return this.textEditor.getTextPane();
    }

    public ATEPanel getTextEditor() {
        return this.textEditor;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public GrammarSyntax getSyntax() {
        return this.grammarSyntax;
    }

    @Override
    public GrammarSyntaxParser getParser() {
        return (GrammarSyntaxParser)this.parserEngine.getParser();
    }

    public void toggleAutoIndent() {
        this.textEditor.setAutoIndent(!this.textEditor.autoIndent());
    }

    public void toggleSyntaxColoring() {
        StatisticsAW.shared().recordEvent(120);
        this.textEditor.toggleSyntaxColoring();
    }

    public void toggleRulesSorting() {
        StatisticsAW.shared().recordEvent(123);
        this.rules.toggleSorting();
        this.interpreter.setRules(this.getRules());
    }

    public void toggleSyntaxDiagram() {
        StatisticsAW.shared().recordEvent(121);
        this.visual.setEnable(!this.visual.isEnable());
        if (this.visual.isEnable()) {
            this.visual.setText(this.getText(), this.getFileName());
        }
        this.updateVisualization(false);
    }

    public void toggleNFAOptimization() {
        this.visual.toggleNFAOptimization();
        this.updateVisualization(false);
    }

    public void toggleIdeas() {
        StatisticsAW.shared().recordEvent(122);
        this.editorIdeas.toggleEnabled();
    }

    public void toggleTips() {
        this.editorTips.toggleEnabled();
    }

    public void toggleUnderlying() {
        this.textEditor.setUnderlying(!this.textEditor.isUnderlying());
        this.textEditor.refresh();
    }

    public void toggleAnalysis() {
        this.textEditor.toggleAnalysis();
    }

    public void changeUpdate() {
        this.ateChangeUpdate(-1, -1, false);
    }

    public void beginGroupChange(String string) {
        this.disableTextPane(false);
        this.beginTextPaneUndoGroup(string);
    }

    public void endGroupChange() {
        this.endTextPaneUndoGroup();
        this.enableTextPane(false);
        this.textEditor.parse();
        this.changeDone();
    }

    public void enableTextPane(boolean bl) {
        this.textEditor.setEnableRecordChange(true);
        if (bl) {
            this.enableTextPaneUndo();
        }
    }

    public void disableTextPane(boolean bl) {
        this.textEditor.setEnableRecordChange(false);
        if (bl) {
            this.disableTextPaneUndo();
        }
    }

    public void beginTextPaneUndoGroup(String string) {
        XJUndo xJUndo = this.getXJFrame().getUndo(this.getTextPane());
        if (xJUndo != null) {
            xJUndo.beginUndoGroup(string);
        }
    }

    public void endTextPaneUndoGroup() {
        XJUndo xJUndo = this.getXJFrame().getUndo(this.getTextPane());
        if (xJUndo != null) {
            xJUndo.endUndoGroup();
        }
    }

    public void enableTextPaneUndo() {
        XJUndo xJUndo = this.getXJFrame().getUndo(this.getTextPane());
        if (xJUndo != null) {
            xJUndo.enableUndo();
        }
    }

    public void disableTextPaneUndo() {
        XJUndo xJUndo = this.getXJFrame().getUndo(this.getTextPane());
        if (xJUndo != null) {
            xJUndo.disableUndo();
        }
    }

    @Override
    public void undoManagerWillUndo(boolean bl) {
    }

    @Override
    public void undoManagerDidUndo(boolean bl) {
        this.changeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadText(String string) {
        this.disableTextPaneUndo();
        try {
            this.textEditor.loadText(string);
            this.grammarChanged();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.enableTextPaneUndo();
        }
    }

    public void setText(String string) {
        this.textEditor.setText(string);
        this.grammarChanged();
        this.textEditor.parse();
        this.changeDone();
    }

    @Override
    public synchronized String getText() {
        return this.getTextPane().getText();
    }

    @Override
    public Tool getANTLRTool() {
        String[] stringArray = AWPrefs.getANTLR3Options();
        if (this.getFileFolder() != null) {
            stringArray = Utils.concat(stringArray, new String[]{"-lib", this.getFileFolder()});
        }
        if (stringArray.length > 0) {
            return new Tool(stringArray);
        }
        return new Tool();
    }

    @Override
    public void createRuleAtIndex(boolean bl, String string, String string2) {
        this.menuRefactor.createRuleAtIndex(bl, string, string2);
    }

    @Override
    public void deleteRuleAtCurrentPosition() {
        this.menuRefactor.deleteRuleAtIndex(this.getCaretPosition());
    }

    @Override
    public void removeLeftRecursion() {
        this.menuRefactor.removeLeftRecursion();
    }

    @Override
    public void convertLiteralsToSingleQuote() {
        this.menuRefactor.convertLiteralsToSingleQuote();
    }

    @Override
    public void replaceText(int n, int n2, String string) {
        this.textEditor.replaceText(n, n2, string);
    }

    public void selectTextRange(int n, int n2) {
        this.textEditor.selectTextRange(n, n2);
    }

    public void deselectTextRange() {
        this.textEditor.deselectTextRange();
    }

    public int getSelectionLeftIndexOnTokenBoundary() {
        ATEToken aTEToken = this.getTokenAtPosition(this.getTextPane().getSelectionStart(), true);
        if (aTEToken == null) {
            return -1;
        }
        return aTEToken.getStartIndex();
    }

    public int getSelectionRightIndexOnTokenBoundary() {
        ATEToken aTEToken = this.getTokenAtPosition(this.getTextPane().getSelectionEnd(), false);
        if (aTEToken == null) {
            return -1;
        }
        return aTEToken.getEndIndex();
    }

    public synchronized boolean isFileWritable() {
        String string = this.getFilePath();
        if (string == null) {
            return true;
        }
        File file = new File(string);
        return !file.exists() || file.canWrite();
    }

    @Override
    public synchronized String getFileFolder() {
        return XJUtils.getPathByDeletingLastComponent(this.getFilePath());
    }

    @Override
    public String getTokenVocabFile(String string) {
        String string2 = this.getFileFolder();
        if (string2 == null) {
            return null;
        }
        String string3 = XJUtils.concatPath(string2, string);
        if (new File(string3).exists()) {
            return string3;
        }
        string3 = XJUtils.concatPath(this.getOutputPath(), string);
        if (new File(string3).exists()) {
            return string3;
        }
        return null;
    }

    @Override
    public synchronized String getFilePath() {
        return this.getDocument().getDocumentPath();
    }

    @Override
    public synchronized String getFileName() {
        return this.getDocument().getDocumentName();
    }

    @Override
    public String getOutputPath() {
        if (AWPrefs.getOutputPathSameAsDocument()) {
            return XJUtils.getPathByDeletingLastComponent(this.getFilePath());
        }
        return AWPrefs.getOutputPath();
    }

    @Override
    public Container getWindowContainer() {
        return this.getXJFrame().getJavaContainer();
    }

    @Override
    public GrammarSyntaxEngine getParserEngine() {
        return this.parserEngine;
    }

    public List<ElementRule> getRules() {
        if (this.rules.isSorted()) {
            return this.rules.getSortedRules();
        }
        return this.rules.getRules();
    }

    public List<ElementRule> getSortedRules() {
        return this.rules.getSortedRules();
    }

    public List<ElementBlock> getBlocks() {
        return this.parserEngine.getBlocks();
    }

    public List<ElementAction> getActions() {
        return this.parserEngine.getActions();
    }

    public List<ElementReference> getReferences() {
        return this.parserEngine.getReferences();
    }

    public List<ATEToken> getTokens() {
        return this.textEditor.getTokens();
    }

    public List<ATELine> getLines() {
        return this.textEditor.getLines();
    }

    public void goToHistoryRememberCurrentPosition() {
        this.goToHistory.addPosition(this.getCaretPosition());
        this.refreshMainMenuBar();
    }

    public ElementReference getCurrentReference() {
        return this.getReferenceAtPosition(this.getCaretPosition());
    }

    public ElementReference getReferenceAtPosition(int n) {
        List<ElementReference> list = this.getReferences();
        for (ElementReference elementReference : list) {
            if (!elementReference.containsIndex(n)) continue;
            return elementReference;
        }
        return null;
    }

    public ATEToken getCurrentToken() {
        return this.getTokenAtPosition(this.getCaretPosition(), false);
    }

    public ATEToken getTokenAtPosition(int n, boolean bl) {
        List<ATEToken> list = this.getTokens();
        if (list == null) {
            return null;
        }
        if (bl) {
            for (int i = list.size() - 1; i >= 0; --i) {
                ATEToken aTEToken = list.get(i);
                if (!aTEToken.containsIndex(n)) continue;
                return aTEToken;
            }
        } else {
            for (ATEToken aTEToken : list) {
                if (!aTEToken.containsIndex(n)) continue;
                return aTEToken;
            }
        }
        return null;
    }

    public ElementRule getCurrentRule() {
        return this.rules.getEnclosingRuleAtPosition(this.getCaretPosition());
    }

    public ElementAction getCurrentAction() {
        List<ElementAction> list = this.parserEngine.getActions();
        int n = this.getCaretPosition();
        for (ElementAction elementAction : list) {
            if (!elementAction.containsIndex(n)) continue;
            return elementAction;
        }
        return null;
    }

    public void setCaretPosition(int n) {
        this.setCaretPosition(n, AWPrefs.getSmoothScrolling());
    }

    public void setCaretPosition(int n, boolean bl) {
        ElementRule elementRule = this.rules.getEnclosingRuleAtPosition(n);
        if (elementRule != null && !elementRule.isExpanded()) {
            this.foldingManager.toggleFolding(elementRule);
        }
        this.textEditor.setCaretPosition(n, true, bl);
    }

    public int getCaretPosition() {
        return this.textEditor.getCaretPosition();
    }

    @Override
    public void customizeFileMenu(XJMenu xJMenu) {
        this.editorMenu.customizeFileMenu(xJMenu);
    }

    @Override
    public void customizeMenuBar(XJMainMenuBar xJMainMenuBar) {
        this.editorMenu.customizeMenuBar(xJMainMenuBar);
    }

    @Override
    public void menuItemState(XJMenuItem xJMenuItem) {
        this.editorMenu.menuItemState(xJMenuItem);
    }

    @Override
    public void handleMenuSelected(XJMenu xJMenu) {
        this.editorMenu.handleMenuSelected(xJMenu);
    }

    public void updateVisualization(boolean bl) {
        if (this.visual.isEnable()) {
            ElementRule elementRule = this.rules.getEnclosingRuleAtPosition(this.getCaretPosition());
            if (elementRule == null) {
                this.visual.setPlaceholder("Select a rule to display its syntax diagram");
            } else {
                if (elementRule.hasErrors() && elementRule.needsToBuildErrors()) {
                    this.engineGrammar.computeRuleErrors(elementRule);
                }
                this.visual.setRule(elementRule, bl);
            }
        } else {
            this.visual.setPlaceholder("Syntax Diagram Disabled");
        }
    }

    public void engineGrammarDidAnalyze() {
        if (!this.visual.update()) {
            this.updateVisualization(true);
        }
        this.updateInformation();
    }

    public void updateInformation() {
        String string;
        int n = 0;
        if (this.parserEngine.getRules() != null) {
            n = this.parserEngine.getRules().size();
        }
        switch (n) {
            case 0: {
                string = "No rules";
                break;
            }
            case 1: {
                string = "One rule";
                break;
            }
            default: {
                string = n + " rules";
            }
        }
        int n2 = this.grammarSyntax.getNumberOfErrors();
        if (n2 > 0) {
            string = string + " (" + n2 + " warning" + (n2 > 0 ? "s" : "") + ")";
        }
        this.infoLabel.setText(string);
        if (this.isFileWritable()) {
            this.writableLabel.setText("Writable");
        } else {
            this.writableLabel.setText("Read-only");
        }
    }

    public void updateCursorInfo() {
        this.cursorLabel.setText(this.textEditor.getCurrentLinePosition() + ":" + this.textEditor.getCurrentColumnPosition());
    }

    public void updateSCMStatus(String string) {
        this.scmLabel.setVisible(AWPrefs.getP4Enabled());
        if (string != null) {
            this.scmLabel.setText("SCM Status: " + string);
        } else {
            this.scmLabel.setText("");
        }
    }

    public void rulesCaretPositionDidChange() {
        this.updateVisualization(false);
    }

    public void rulesDidSelectRule() {
        this.updateVisualization(true);
    }

    public void rulesDidChange() {
        this.interpreter.updateIgnoreTokens(this.getRules());
    }

    public JPopupMenu rulesGetContextualMenu(List list) {
        if (list.isEmpty()) {
            return null;
        }
        ContextualMenuFactory contextualMenuFactory = new ContextualMenuFactory(this.editorMenu);
        contextualMenuFactory.addItem(56);
        contextualMenuFactory.addItem(57);
        contextualMenuFactory.addSeparator();
        XJMenuItemCheck xJMenuItemCheck = (XJMenuItemCheck)contextualMenuFactory.addItem(58);
        xJMenuItemCheck.setSelected(this.rules.getFirstSelectedRuleIgnoredFlag());
        return contextualMenuFactory.menu;
    }

    @Override
    public void ateParserWillParse() {
        this.persistence.store();
    }

    @Override
    public void ateParserDidParse() {
        this.updateInformation();
        this.updateCursorInfo();
        if (this.windowFirstDisplay) {
            this.windowFirstDisplay = false;
            this.afterParseOperations();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CEditorGrammar.this.updateVisualization(true);
                    CEditorGrammar.this.executeFirstOpeningOperations();
                    CEditorGrammar.this.findTokensToIgnore(true);
                }
            });
        } else {
            this.afterParserOp.awakeThread();
        }
    }

    public void afterParseOperations() {
        this.persistence.restore();
        this.interpreter.setRules(this.getRules());
        this.rules.parserDidParse();
        this.grammarSyntax.parserDidParse();
        this.decisionDFAEngine.reset();
        this.decisionDFAEngine.refreshMenu();
        this.editorIdeas.display(this.getCaretPosition());
        this.visual.setText(this.getText(), this.getFileName());
        this.updateVisualization(false);
        this.textEditor.damage();
        this.textEditor.repaint();
    }

    @Override
    public void changeDone() {
        this.grammarChanged();
        this.getDocument().changeDone();
    }

    public boolean ensureDocumentSaved() {
        return this.getDocument().getDocumentPath() != null || this.getDocument().performSave(false);
    }

    public void grammarChanged() {
        this.engineGrammar.markDirty();
    }

    public void consolePrint(String string, int n) {
        this.consoleStatus.showLevel(n);
    }

    public void clearConsoleStatus() {
        this.consoleStatus.clearMessage();
    }

    @Override
    public void notificationPrefsChanged() {
        this.applyPrefs();
        this.updateSCMStatus(null);
    }

    @Override
    public void notificationDebuggerStarted() {
        this.refreshMainMenuBar();
        this.editorIdeas.hide();
    }

    @Override
    public void componentShouldLayout(Dimension dimension) {
        if (this.rulesTextSplitPane != null) {
            this.rulesTextSplitPane.setDividerLocation((int)((double)dimension.width * 0.2));
        }
        if (this.upDownSplitPane != null) {
            this.upDownSplitPane.setDividerLocation((int)((double)dimension.height * 0.5));
        }
        this.interpreter.componentShouldLayout();
        this.debugger.componentShouldLayout(dimension);
    }

    @Override
    public void componentDidAwake() {
        this.updateInformation();
        this.updateCursorInfo();
        this.menuSCM.setSilent(true);
        this.menuSCM.queryFileStatus();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CEditorGrammar.this.getTextPane().requestFocusInWindow();
            }
        });
    }

    @Override
    public void componentActivated() {
        this.grammarSyntax.resetTokenVocab();
        this.grammarSyntax.rebuildAll();
        this.textEditor.getTextPane().setWritable(this.isFileWritable());
        this.textEditor.refresh();
        this.updateInformation();
    }

    @Override
    public void componentDidHide() {
        this.editorIdeas.hide();
    }

    @Override
    public void componentIsSelected() {
        this.getTextPane().requestFocusInWindow();
    }

    @Override
    public void componentDocumentContentChanged() {
        int n = this.getCaretPosition();
        this.getDocument().reload();
        this.grammarChanged();
        this.setCaretPosition(Math.min(n, this.getText().length()));
    }

    @Override
    public List<String> autoCompletionMenuGetMatchingWordsForPartialWord(String string) {
        if (this.parserEngine == null || this.parserEngine.getRules() == null) {
            return null;
        }
        string = string.toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.rules.isRuleAtIndex(this.getCaretPosition())) {
            ArrayList<ElementRule> arrayList2 = Collections.list(Collections.enumeration(this.parserEngine.getRules()));
            Collections.sort(arrayList2, new Comparator<ElementRule>(){

                @Override
                public int compare(ElementRule elementRule, ElementRule elementRule2) {
                    return elementRule.name.compareToIgnoreCase(elementRule2.name);
                }
            });
            for (ElementRule elementRule : arrayList2) {
                if (!elementRule.name.toLowerCase().startsWith(string) || arrayList.contains(elementRule.name)) continue;
                arrayList.add(elementRule.name);
            }
        } else {
            ArrayList<ElementReference> arrayList3 = Collections.list(Collections.enumeration(this.grammarSyntax.getUndefinedReferences()));
            Collections.sort(arrayList3, new Comparator<ElementReference>(){

                @Override
                public int compare(ElementReference elementReference, ElementReference elementReference2) {
                    return elementReference.rule.name.compareToIgnoreCase(elementReference2.rule.name);
                }
            });
            for (ElementReference elementReference : arrayList3) {
                String string2 = elementReference.token.getAttribute();
                if (!string2.toLowerCase().startsWith(string) || string2.equals(string) || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    @Override
    public void autoCompletionMenuWillDisplay() {
        this.editorIdeas.hide();
    }

    @Override
    public void ateChangeUpdate(int n, int n2, boolean bl) {
        this.changeDone();
        this.visual.cancelDrawingProcess();
    }

    @Override
    public void ateAutoIndent(int n, int n2) {
        try {
            GrammarAutoIndent.autoIndentOnSpecificKeys(this, this.getTextPane().getDocument(), n, n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void ateMousePressed(Point point) {
        if (!this.debugger.isRunning()) {
            this.editorIdeas.display(point);
        }
    }

    @Override
    public void ateMouseExited() {
        if (this.getTextPane().hasFocus()) {
            this.editorTips.hide();
        }
    }

    @Override
    public void ateMouseMoved(Point point) {
        if (this.getTextPane().hasFocus()) {
            Point point2 = SwingUtilities.convertPoint(this.getTextPane(), point, this.getJavaContainer());
            this.editorTips.display(point, point2);
        }
    }

    @Override
    public void ateInvokePopUp(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = this.editorMenu.getContextualMenu(this.textEditor.getTextIndexAtPosition(n, n2));
        if (jPopupMenu != null) {
            jPopupMenu.show(component, n, n2);
        }
    }

    @Override
    public void ateCaretUpdate(int n) {
        this.updateCursorInfo();
        if (this.getTextPane().hasFocus()) {
            this.editorIdeas.hide();
            if (!this.debugger.isRunning()) {
                this.editorIdeas.display(this.getCaretPosition());
            }
        }
        this.autoCompletionMenu.updateAutoCompleteList();
        ElementRule elementRule = this.rules.selectRuleInTreeAtPosition(n);
        if (elementRule == null || elementRule.name == null) {
            this.updateVisualization(false);
            this.lastSelectedRule = null;
            return;
        }
        if (this.lastSelectedRule == null || !this.lastSelectedRule.equals(elementRule.name)) {
            this.lastSelectedRule = elementRule.name;
            this.updateVisualization(false);
        }
    }

    public void executeFirstOpeningOperations() {
        this.checkGrammarVersion();
    }

    public void checkGrammarVersion() {
        boolean bl = false;
        List<ATEToken> list = this.parserEngine.getTokens();
        for (int i = 0; i < list.size(); ++i) {
            ATEToken aTEToken = list.get(i);
            if (aTEToken.type != 5 || !aTEToken.getAttribute().equals("class") || i + 2 >= list.size()) continue;
            ATEToken aTEToken2 = list.get(i + 2);
            if (aTEToken2.type != 5 || !aTEToken2.getAttribute().equals("extends")) continue;
            bl = true;
            break;
        }
        if (bl) {
            XJAlert.display(this.getWindowContainer(), "Incompatible Grammar Version", "This grammar does not appear to be an ANTLR 3.x grammar.\nANTLRWorks includes ANTLR 3.x and therefore only ANTLR 3.x grammars are recognized.");
        }
    }

    public void findTokensToIgnore(boolean bl) {
        this.rules.findTokensToIgnore(bl);
        this.interpreter.setRules(this.getRules());
    }

    @Override
    public boolean componentDocumentWillSave() {
        AWPrefs.setLastSavedDocument(this.getFilePath());
        if (this.menuSCM.isFileWritable()) {
            return true;
        }
        if (XJAlert.displayAlertYESNO(this.getWindowContainer(), "Cannot Save", "This file is currently closed in the SCM depot.\nDo you want to open it for edit before saving its content ?") == 0) {
            this.menuSCM.editFile();
            this.wasSaving = true;
        }
        return false;
    }

    public void scmCommandsDidComplete() {
        if (this.wasSaving) {
            this.wasSaving = false;
            this.getDocument().performSave(false);
        }
    }

    @Override
    public void setPersistentData(Map map) {
        if (map == null) {
            return;
        }
        Integer n = (Integer)map.get(KEY_SPLITPANE_A);
        if (n != null && this.rulesTextSplitPane != null) {
            this.rulesTextSplitPane.setDividerLocation(n);
        }
        if ((n = (Integer)map.get(KEY_SPLITPANE_B)) != null && this.upDownSplitPane != null) {
            this.upDownSplitPane.setDividerLocation(n);
        }
        this.interpreter.setPersistentData((Map)map.get(KEY_INTERPRETER));
        this.debugger.setPersistentData((Map)map.get(KEY_DEBUGGER));
    }

    @Override
    public Map<String, Object> getPersistentData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.rulesTextSplitPane != null) {
            hashMap.put(KEY_SPLITPANE_A, this.rulesTextSplitPane.getDividerLocation());
        }
        if (this.upDownSplitPane != null) {
            hashMap.put(KEY_SPLITPANE_B, this.upDownSplitPane.getDividerLocation());
        }
        hashMap.put(KEY_INTERPRETER, this.interpreter.getPersistentData());
        hashMap.put(KEY_DEBUGGER, this.debugger.getPersistentData());
        return hashMap;
    }

    public void print() {
        try {
            this.textEditor.print();
        }
        catch (PrinterException printerException) {
            XJAlert.display(this.getWindowContainer(), "Print Error", "An error occurred while printing:\n" + printerException.toString());
        }
    }

    public void showProgress(String string, XJDialogProgressDelegate xJDialogProgressDelegate) {
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.getWindowContainer());
        }
        this.progress.setInfo(string);
        this.progress.setCancellable(true);
        this.progress.setDelegate(xJDialogProgressDelegate);
        this.progress.setIndeterminate(true);
        this.progress.display();
    }

    public void hideProgress() {
        this.progress.close();
    }

    protected class TabbedPaneChangeListener
    implements ChangeListener {
        protected TabbedPaneChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CEditorGrammar.this.refreshMainMenuBar();
        }
    }

    protected class TabbedPaneMouseListener
    extends MouseAdapter {
        protected static final int CLOSING_INDEX_LIMIT = 4;

        protected TabbedPaneMouseListener() {
        }

        public void displayPopUp(MouseEvent mouseEvent) {
            if (CEditorGrammar.this.tabbedPane.getSelectedIndex() < 4) {
                return;
            }
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Close");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (CEditorGrammar.this.tabbedPane.getSelectedIndex() < 4) {
                        return;
                    }
                    CEditorGrammar.this.tabs.remove(CEditorGrammar.this.tabbedPane.getSelectedIndex());
                    CEditorGrammar.this.tabbedPane.removeTabAt(CEditorGrammar.this.tabbedPane.getSelectedIndex());
                }
            });
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.displayPopUp(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.displayPopUp(mouseEvent);
        }
    }

    protected class ConsoleStatus {
        public Box box = Box.createHorizontalBox();
        public XJURLLabel label = new XJURLLabel(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CEditorGrammar.this.selectConsoleTab();
                ConsoleStatus.this.clearMessage();
            }
        });
        public boolean visible;
        public int currentDisplayedLevel;

        public ConsoleStatus() {
            this.clearMessage();
        }

        public void showMessage(String string, Color color) {
            this.label.setText(string);
            this.label.setUnvisitedURLColor(color);
            this.label.setVisitedURLColor(color);
            this.label.repaint();
        }

        public void showLevel(int n) {
            if (n == 0) {
                return;
            }
            if (!this.visible) {
                this.visible = true;
                this.box.removeAll();
                this.box.add(this.label);
                this.box.revalidate();
            }
            if (n > this.currentDisplayedLevel) {
                this.currentDisplayedLevel = n;
                if (n == 2) {
                    this.showMessage("Errors reported in console", Color.red);
                } else {
                    this.showMessage("Warnings reported in console", Color.blue);
                }
            }
        }

        public void clearMessage() {
            this.label.setText("");
            this.box.removeAll();
            this.box.add(Box.createHorizontalStrut(20));
            this.visible = false;
            this.currentDisplayedLevel = 0;
        }

        public JComponent getPanel() {
            return this.box;
        }
    }

    protected static class RuleTree
    extends XJTree {
        protected RuleTree() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return "";
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            EditorRules.RuleTreeUserObject ruleTreeUserObject = (EditorRules.RuleTreeUserObject)defaultMutableTreeNode.getUserObject();
            if (ruleTreeUserObject == null) {
                return "";
            }
            ElementRule elementRule = ruleTreeUserObject.rule;
            if (elementRule == null || !elementRule.hasErrors()) {
                return "";
            }
            return elementRule.getErrorMessageHTML();
        }
    }

    protected class AfterParseOperations
    extends ATEThread {
        public AfterParseOperations() {
            this.start();
        }

        protected void threadRun() throws Exception {
            CEditorGrammar.this.afterParseOperations();
        }
    }
}

