/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.antlr.works.components.ComponentContainer;
import org.antlr.works.components.ComponentStatusBar;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentEditor
implements XJNotificationObserver {
    protected ComponentContainer container;
    protected JPanel mainPanel;
    protected Box statusBar;
    protected ComponentListener cl;
    protected PropertyChangeListener pcl;

    public ComponentEditor(ComponentContainer componentContainer) {
        this.container = componentContainer;
        this.mainPanel = new JPanel(new BorderLayout());
        this.cl = new MainPanelComponentListener();
        this.mainPanel.addComponentListener(this.cl);
        this.statusBar = new ComponentStatusBar();
        this.statusBar.setPreferredSize(new Dimension(0, 30));
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STARTED");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STOPPED");
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("permanentFocusOwner")) {
                    XJMainMenuBar.refreshAllMenuBars();
                }
            }
        };
        keyboardFocusManager.addPropertyChangeListener(this.pcl);
    }

    public void refreshMainMenuBar() {
        if (this.getXJFrame().getMainMenuBar() != null) {
            this.getXJFrame().getMainMenuBar().refreshState();
        }
    }

    public JComponent getToolbarComponent() {
        return null;
    }

    public JComponent getStatusComponent() {
        return this.statusBar;
    }

    public XJDocument getDocument() {
        return this.container.getDocument();
    }

    public XJFrameInterface getXJFrame() {
        return this.container.getXJFrame();
    }

    public Container getJavaContainer() {
        return this.getXJFrame().getJavaContainer();
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public XJUndo getCurrentUndo() {
        return this.getXJFrame().getCurrentUndo();
    }

    @Override
    public void notificationFire(Object object, String string) {
        if (string.equals("NOTIF_PREFS_APPLIED")) {
            this.notificationPrefsChanged();
        } else if (string.equals("NOTIF_DEBUG_STARTED")) {
            this.notificationDebuggerStarted();
        } else if (string.equals("NOTIF_DEBUG_STOPPED")) {
            this.notificationDebuggerStopped();
        }
    }

    protected static JComponent createSeparator() {
        JSeparator jSeparator = new JSeparator(1);
        Dimension dimension = jSeparator.getMaximumSize();
        dimension.width = 2;
        jSeparator.setMaximumSize(dimension);
        return jSeparator;
    }

    public abstract void create();

    public abstract void assemble();

    public abstract void loadText(String var1);

    public abstract String getText();

    public void close() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.pcl);
        this.pcl = null;
        this.mainPanel.removeComponentListener(this.cl);
        this.cl = null;
        this.container = null;
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public abstract void componentDocumentContentChanged();

    public boolean componentDocumentWillSave() {
        return true;
    }

    public void setPersistentData(Map map) {
    }

    public Map<String, Object> getPersistentData() {
        return null;
    }

    public void componentShouldLayout(Dimension dimension) {
    }

    public void componentDidAwake() {
    }

    public void customizeFileMenu(XJMenu xJMenu) {
    }

    public void customizeEditMenu(XJMenu xJMenu) {
    }

    public void customizeWindowMenu(XJMenu xJMenu) {
    }

    public void customizeHelpMenu(XJMenu xJMenu) {
    }

    public void customizeMenuBar(XJMainMenuBar xJMainMenuBar) {
    }

    public void menuItemState(XJMenuItem xJMenuItem) {
    }

    public void handleMenuSelected(XJMenu xJMenu) {
    }

    public void componentActivated() {
    }

    public void componentDidHide() {
    }

    public void componentIsSelected() {
    }

    public void notificationPrefsChanged() {
    }

    public void notificationDebuggerStarted() {
    }

    public void notificationDebuggerStopped() {
    }

    protected class MainPanelComponentListener
    extends ComponentAdapter {
        protected MainPanelComponentListener() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            ComponentEditor.this.componentDidHide();
        }
    }
}

