/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.completion;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.antlr.works.completion.AutoCompletionMenu;
import org.antlr.works.completion.AutoCompletionMenuDelegate;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

public class RuleTemplates
extends AutoCompletionMenu {
    private List<String> templateRuleNames = new ArrayList<String>();
    private List<String> templateRuleTexts = new ArrayList<String>();

    public RuleTemplates(AutoCompletionMenuDelegate autoCompletionMenuDelegate, JTextComponent jTextComponent, XJFrameInterface xJFrameInterface) {
        super(autoCompletionMenuDelegate, jTextComponent, xJFrameInterface);
        this.list.addMouseMotionListener(new ListMouseMotionAdapter());
        this.list.addMouseListener(new ListMouseAdapter());
        this.initTemplateRules();
    }

    public void initTemplateRules() {
        this.templateRuleNames.add("INTEGER");
        this.templateRuleNames.add("ID");
        this.templateRuleNames.add("DIGIT");
        this.templateRuleNames.add("LETTER");
        this.templateRuleNames.add("WS (ignore)");
        this.templateRuleNames.add("WS");
        this.templateRuleTexts.add("INTEGER\n\t:\tDIGIT (DIGIT)*\n\t;\n");
        this.templateRuleTexts.add("ID\t:\tLETTER (LETTER | DIGIT)*\n\t;\n");
        this.templateRuleTexts.add("DIGIT\t:\t'0'..'9'\n\t;\n");
        this.templateRuleTexts.add("LETTER\n\t:\t'a'..'z' | 'A'..'Z'\n\t;\n");
        this.templateRuleTexts.add("WS\t:\t(' ' | '\\t' | '\\n' | '\\r') { $setType(Token.SKIP); }\n\t;\n");
        this.templateRuleTexts.add("WS\t:\t(' ' | '\\t' | '\\n' | '\\r')\n\t;\n");
    }

    public KeyStroke overlayDisplayKeyStroke() {
        return KeyStroke.getKeyStroke(84, 4);
    }

    public String overlayDisplayKeyStrokeMappingName() {
        return "META-T";
    }

    public boolean overlayWillDisplay() {
        int n = this.getTextComponent().getCaretPosition();
        this.setDisplayIndex(n);
        this.setWordLists(this.templateRuleNames, this.templateRuleTexts);
        this.setInsertionStartIndex(n);
        this.setInsertionEndIndex(n);
        return true;
    }

    public class ListMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            RuleTemplates.this.autoComplete();
            RuleTemplates.this.hide();
        }
    }

    public class ListMouseMotionAdapter
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent mouseEvent) {
            RuleTemplates.this.list.setSelectedIndex(RuleTemplates.this.list.locationToIndex(mouseEvent.getPoint()));
        }
    }
}

