/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.antlr.works.completion.AutoCompletionMenuDelegate;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.OverlayObject;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionMenu
extends OverlayObject {
    protected AutoCompletionMenuDelegate delegate;
    protected DefaultListModel listModel;
    protected JList list;
    protected List<String> words;
    protected static List<String> recentlyUsedWords = new LinkedList<String>();
    protected int maxWordLength;
    protected int insertionStartIndex;
    protected int insertionEndIndex;
    protected int displayIndex;
    public static int visibleMatchingRules = 15;

    public AutoCompletionMenu(AutoCompletionMenuDelegate autoCompletionMenuDelegate, JTextComponent jTextComponent, XJFrameInterface xJFrameInterface) {
        super(xJFrameInterface, jTextComponent);
        this.delegate = autoCompletionMenuDelegate;
    }

    @Override
    public void close() {
        super.close();
        this.delegate = null;
    }

    public boolean isVStyle() {
        return AWPrefs.isVStyleAutoCompletion();
    }

    public JTextComponent getTextComponent() {
        return (JTextComponent)this.parentComponent;
    }

    @Override
    public JComponent overlayCreateInterface() {
        visibleMatchingRules = this.isVStyle() ? 7 : 15;
        this.getTextComponent().addKeyListener(new MyKeyAdapter());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel){

            public int getVisibleRowCount() {
                return Math.min(AutoCompletionMenu.this.listModel.getSize(), visibleMatchingRules);
            }
        };
        this.list.setSelectionMode(0);
        this.list.setBackground(new Color(235, 244, 254));
        this.list.addKeyListener(new MyKeyAdapter());
        this.list.setPrototypeCellValue("This is a rule name g");
        this.list.addMouseListener(new ListMouseAdapter());
        JScrollPane jScrollPane = new JScrollPane(this.list, 20, 31);
        jScrollPane.setBorder(BorderFactory.createBevelBorder(0));
        return jScrollPane;
    }

    @Override
    public boolean overlayWillDisplay() {
        if (this.isVStyle()) {
            int n = this.getTextComponent().getCaretPosition() + 1;
            String string = "";
            this.setInsertionStartIndex(n);
            this.setInsertionEndIndex(n);
            List<String> list = this.delegate.autoCompletionMenuGetMatchingWordsForPartialWord(string);
            if (list.size() == 0) {
                return false;
            }
            this.list.setFont(new Font(AWPrefs.getEditorFont(), 0, 12));
            this.list.setAutoscrolls(true);
            this.setDisplayIndex(n);
            this.setWordLists(list, list);
            this.delegate.autoCompletionMenuWillDisplay();
            this.selectMostRecentlyUsedWordPosition(string, list.get(0));
            return true;
        }
        int n = this.getTextComponent().getCaretPosition();
        int n2 = this.getPartialWordBeginsAtPosition(n);
        String string = "";
        if (n2 < n) {
            string = this.getTextComponent().getText().substring(n2 + 1, n);
        }
        this.setInsertionStartIndex(n2 + 1);
        this.setInsertionEndIndex(n);
        List<String> list = this.delegate.autoCompletionMenuGetMatchingWordsForPartialWord(string);
        if (list.size() == 0) {
            return false;
        }
        if (list.size() == 1) {
            this.completePartialWord(list.get(0));
            return false;
        }
        this.list.setFont(new Font(AWPrefs.getEditorFont(), 0, 12));
        this.list.setAutoscrolls(true);
        this.setDisplayIndex(n2 + 1);
        this.setWordLists(list, list);
        this.delegate.autoCompletionMenuWillDisplay();
        return true;
    }

    @Override
    public KeyStroke overlayDisplayKeyStroke() {
        if (this.isVStyle()) {
            return KeyStroke.getKeyStroke(32, 0);
        }
        return KeyStroke.getKeyStroke(32, 2);
    }

    @Override
    public String overlayDisplayKeyStrokeMappingName() {
        return "controlEspace";
    }

    public void setWordLists(List<String> list, List<String> list2) {
        this.listModel.clear();
        for (String string : list) {
            this.listModel.addElement(string);
        }
        this.words = list2;
        this.maxWordLength = 0;
        for (String string : list2) {
            this.maxWordLength = Math.max(this.maxWordLength, string.length());
        }
    }

    public void setInsertionStartIndex(int n) {
        this.insertionStartIndex = n;
    }

    public void setInsertionEndIndex(int n) {
        this.insertionEndIndex = n;
    }

    public void setDisplayIndex(int n) {
        this.displayIndex = n;
    }

    public static boolean isCharIdentifier(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static boolean isAlphaNumericOr_(int n) {
        return n >= 65 && n <= 90 || n == 45;
    }

    private static boolean isFunctionKey(int n) {
        return n >= 16 && n <= 18 || n == 20;
    }

    public int getPartialWordBeginsAtPosition(int n) {
        int n2;
        String string = this.getTextComponent().getText();
        for (n2 = n - 1; n2 >= 0 && AutoCompletionMenu.isCharIdentifier(string.charAt(n2)); --n2) {
        }
        return n2;
    }

    public void completePartialWord(String string) {
        try {
            Document document = this.getTextComponent().getDocument();
            document.remove(this.insertionStartIndex, this.insertionEndIndex - this.insertionStartIndex);
            document.insertString(this.insertionStartIndex, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void autoComplete() {
        if (this.list.getSelectedIndex() >= 0) {
            String string = this.words.get(this.list.getSelectedIndex());
            if (this.isVStyle()) {
                recentlyUsedWords.remove(string);
                ((LinkedList)recentlyUsedWords).addFirst(string);
            }
            this.completePartialWord(string);
        }
    }

    @Override
    public void resize() {
        Rectangle rectangle = null;
        StatisticsAW.shared().recordEvent(133);
        try {
            rectangle = this.getTextComponent().getUI().modelToView(this.getTextComponent(), this.displayIndex);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        if (rectangle == null) {
            return;
        }
        Point point = SwingUtilities.convertPoint(this.getTextComponent(), new Point(rectangle.x, rectangle.y), this.parentFrame.getRootPane());
        int n = this.list.getFixedCellHeight();
        int n2 = this.listModel.size();
        if (n2 > 0) {
            n = n * Math.min(visibleMatchingRules, n2) + 5;
            this.content.setBounds(point.x - 3, point.y + rectangle.height, this.maxWordLength * 8 + 50, n);
        }
    }

    public void selectMostRecentlyUsedWordPosition(String string, String string2) {
        String string3 = "";
        for (String string4 : recentlyUsedWords) {
            if (!string4.toLowerCase().startsWith(string) || !this.words.contains(string4)) continue;
            string3 = string4;
            break;
        }
        if (string3.length() > 0) {
            this.list.setSelectedValue(string3, true);
        } else {
            this.list.setSelectedValue(string2, true);
        }
        int n = this.list.getSelectedIndex();
        int n2 = Math.max(0, n - 1);
        int n3 = Math.min(this.words.size() - 1, n + 2);
        this.list.scrollRectToVisible(this.list.getCellBounds(n2, n3));
    }

    public void updateAutoCompleteList() {
        List<String> list;
        if (!this.content.isVisible()) {
            return;
        }
        int n = this.getTextComponent().getCaretPosition();
        int n2 = this.getPartialWordBeginsAtPosition(n);
        String string = "";
        if (n2 < n) {
            string = this.getTextComponent().getText().substring(n2 + 1, n);
        }
        if ((list = this.delegate.autoCompletionMenuGetMatchingWordsForPartialWord(string)) == null || list.size() == 0) {
            this.hide();
        } else {
            this.setInsertionEndIndex(n);
            if (!this.isVStyle()) {
                this.setWordLists(list, list);
            }
            this.selectMostRecentlyUsedWordPosition(string, list.get(0));
            this.resize();
        }
    }

    public class MyKeyAdapter
    extends KeyAdapter {
        public void move(int n) {
            if (AutoCompletionMenu.this.listModel.getSize() < 1) {
                return;
            }
            int n2 = AutoCompletionMenu.this.list.getSelectedIndex();
            int n3 = Math.max(0, Math.min(AutoCompletionMenu.this.listModel.getSize() - 1, n2 + n));
            AutoCompletionMenu.this.list.setSelectionInterval(n3, n3);
            AutoCompletionMenu.this.list.scrollRectToVisible(AutoCompletionMenu.this.list.getCellBounds(n3, n3));
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (!AutoCompletionMenu.this.content.isVisible()) {
                return;
            }
            switch (n) {
                case 37: 
                case 39: {
                    AutoCompletionMenu.this.content.setVisible(false);
                    break;
                }
                case 8: {
                    int n2 = AutoCompletionMenu.this.getTextComponent().getCaretPosition();
                    int n3 = AutoCompletionMenu.this.getPartialWordBeginsAtPosition(n2);
                    if (n2 - 1 > n3) break;
                    AutoCompletionMenu.this.content.setVisible(false);
                    break;
                }
                case 70: 
                case 84: {
                    if (!keyEvent.isControlDown()) break;
                    AutoCompletionMenu.this.content.setVisible(false);
                    break;
                }
                case 27: {
                    AutoCompletionMenu.this.content.setVisible(false);
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    AutoCompletionMenu.this.autoComplete();
                    AutoCompletionMenu.this.content.setVisible(false);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.move(1);
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    this.move(-1);
                    keyEvent.consume();
                    break;
                }
                case 34: {
                    if (AutoCompletionMenu.this.isVStyle()) {
                        AutoCompletionMenu.this.content.setVisible(false);
                        break;
                    }
                    this.move(AutoCompletionMenu.this.list.getVisibleRowCount() - 1);
                    keyEvent.consume();
                    break;
                }
                case 33: {
                    if (AutoCompletionMenu.this.isVStyle()) {
                        AutoCompletionMenu.this.content.setVisible(false);
                        break;
                    }
                    this.move(-(AutoCompletionMenu.this.list.getVisibleRowCount() - 1));
                    keyEvent.consume();
                    break;
                }
                case 36: {
                    if (AutoCompletionMenu.this.isVStyle()) {
                        AutoCompletionMenu.this.content.setVisible(false);
                        break;
                    }
                    this.move(-AutoCompletionMenu.this.listModel.getSize());
                    keyEvent.consume();
                    break;
                }
                case 35: {
                    if (AutoCompletionMenu.this.isVStyle()) {
                        AutoCompletionMenu.this.content.setVisible(false);
                        break;
                    }
                    this.move(AutoCompletionMenu.this.listModel.getSize());
                    keyEvent.consume();
                    break;
                }
                default: {
                    if (AutoCompletionMenu.isAlphaNumericOr_(n) || AutoCompletionMenu.isFunctionKey(n)) break;
                    System.out.println(n);
                    AutoCompletionMenu.this.content.setVisible(false);
                }
            }
        }
    }

    public class ListMouseAdapter
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed() || !AutoCompletionMenu.this.content.isVisible()) {
                return;
            }
            AutoCompletionMenu.this.autoComplete();
            AutoCompletionMenu.this.content.setVisible(false);
            AutoCompletionMenu.this.parentComponent.requestFocusInWindow();
        }
    }
}

