/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.awtree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.antlr.works.awtree.AWTreeGraphView;
import org.antlr.works.awtree.AWTreeModel;
import org.antlr.works.awtree.AWTreeNode;
import org.antlr.works.awtree.AWTreePanelDelegate;
import org.antlr.works.swing.Toolbar;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.TreeUtilities;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class AWTreePanel
extends JPanel {
    protected Component listViewComponent;
    protected Component graphViewComponent;
    protected JTree tree;
    protected DefaultTreeModel jTreeModel;
    protected AWTreeGraphView treeGraphView;
    protected JScrollPane graphScrollPane;
    protected AWTreePanelDelegate delegate;

    public AWTreePanel(DefaultTreeModel defaultTreeModel) {
        super(new BorderLayout());
        this.jTreeModel = defaultTreeModel;
        this.tree = new JTree(defaultTreeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = AWTreePanel.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = AWTreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    AWTreePanel.this.displayNodeInfo(treePath.getLastPathComponent());
                    mouseEvent.consume();
                }
            }
        });
        this.listViewComponent = this.createListView();
        this.graphViewComponent = this.createGraphView();
        this.add(this.graphViewComponent, "Center");
    }

    public void setDelegate(AWTreePanelDelegate aWTreePanelDelegate) {
        this.delegate = aWTreePanelDelegate;
    }

    public void setAWTreeModel(AWTreeModel aWTreeModel) {
        this.treeGraphView.setModel(aWTreeModel);
    }

    public Component createListView() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setWheelScrollingEnabled(true);
        jScrollPane.setBackground(Color.white);
        Toolbar toolbar = Toolbar.createHorizontalToolbar();
        toolbar.addElement(this.createExpandAllButton());
        toolbar.addElement(this.createCollapseAllButton());
        toolbar.add(Box.createHorizontalGlue());
        toolbar.addElement(this.createDisplayAsGraphButton());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)toolbar, "South");
        return jPanel;
    }

    public JButton createDisplayAsGraphButton() {
        JButton jButton = new JButton(IconManager.shared().getIconGraph());
        jButton.setToolTipText("Display as Graph");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTreePanel.this.toggleGraph();
            }
        });
        return jButton;
    }

    public JButton createExpandAllButton() {
        JButton jButton = new JButton(IconManager.shared().getIconExpandAll());
        jButton.setToolTipText("Expand All");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeUtilities.expandAll(AWTreePanel.this.tree);
            }
        });
        return jButton;
    }

    public JButton createCollapseAllButton() {
        JButton jButton = new JButton(IconManager.shared().getIconCollapseAll());
        jButton.setToolTipText("Collapse All");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeUtilities.collapseAll(AWTreePanel.this.tree);
            }
        });
        return jButton;
    }

    public Component createGraphView() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.treeGraphView = new AWTreeGraphView(this);
        this.treeGraphView.setAutoAdjustSize(true);
        this.treeGraphView.setBackground(Color.white);
        this.treeGraphView.setDrawBorder(false);
        ParseTreeMouseAdapter parseTreeMouseAdapter = new ParseTreeMouseAdapter();
        this.treeGraphView.addMouseListener(parseTreeMouseAdapter);
        this.treeGraphView.addMouseMotionListener(parseTreeMouseAdapter);
        this.graphScrollPane = new JScrollPane(this.treeGraphView);
        this.graphScrollPane.setWheelScrollingEnabled(true);
        Toolbar toolbar = Toolbar.createHorizontalToolbar();
        toolbar.addElement(new JLabel("Zoom"));
        toolbar.addElement(this.createZoomSlider());
        toolbar.add(Box.createHorizontalGlue());
        toolbar.addElement(this.createDisplayAsListButton());
        jPanel.add((Component)this.graphScrollPane, "Center");
        jPanel.add((Component)toolbar, "South");
        return jPanel;
    }

    public JButton createDisplayAsListButton() {
        JButton jButton = new JButton(IconManager.shared().getIconListTree());
        jButton.setToolTipText("Display as List");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTreePanel.this.toggleGraph();
            }
        });
        return jButton;
    }

    public JSlider createZoomSlider() {
        JSlider jSlider = new JSlider();
        jSlider.setFocusable(false);
        jSlider.setMinimum(1);
        jSlider.setMaximum(200);
        jSlider.setValue(100);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                AWTreePanel.this.treeGraphView.setZoom((float)jSlider.getValue() / 100.0f);
                AWTreePanel.this.treeGraphView.repaint();
                AWTreePanel.this.treeGraphView.revalidate();
            }
        });
        return jSlider;
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    public void setRoot(TreeNode treeNode) {
        this.jTreeModel.setRoot(treeNode);
        this.treeGraphView.setRoot(treeNode);
    }

    public Object getRoot() {
        return this.jTreeModel.getRoot();
    }

    public AWTreeGraphView getGraphView() {
        return this.treeGraphView;
    }

    public void clear() {
        this.treeGraphView.clear();
    }

    public void refresh() {
        this.jTreeModel.reload();
        TreeUtilities.expandAll(this.tree);
        this.treeGraphView.refresh();
    }

    public void toggleGraph() {
        if (this.getComponent(0) == this.listViewComponent) {
            this.remove(this.listViewComponent);
            this.add(this.graphViewComponent, "Center");
        } else {
            this.remove(this.graphViewComponent);
            this.add(this.listViewComponent, "Center");
        }
        this.repaint();
        this.revalidate();
    }

    public void selectNode(TreeNode treeNode) {
        TreePath treePath = new TreePath(this.jTreeModel.getPathToRoot(treeNode));
        this.tree.scrollPathToVisible(treePath);
        this.tree.setSelectionPath(treePath);
        this.treeGraphView.highlightNode(treeNode);
    }

    public void scrollNodeToVisible(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        this.tree.scrollPathToVisible(new TreePath(this.jTreeModel.getPathToRoot(treeNode)));
        this.treeGraphView.scrollNodeToVisible(treeNode);
    }

    public void displayNodeInfo(Object object) {
        AWTreeNode aWTreeNode = (AWTreeNode)object;
        XJAlert.display(this, "Node info", aWTreeNode.getInfoString());
    }

    public JPopupMenu getContextualMenu() {
        if (this.delegate != null) {
            return this.delegate.awTreeGetContextualMenu();
        }
        return null;
    }

    protected class ParseTreeMouseAdapter
    implements MouseListener,
    MouseMotionListener {
        public Point origin;
        public Rectangle r;
        public boolean dragging;

        protected ParseTreeMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GElement gElement = AWTreePanel.this.treeGraphView.getElementAtMousePosition(mouseEvent);
            if (gElement != null && gElement instanceof AWTreeGraphView.GElementNode) {
                boolean bl;
                TreeNode treeNode = AWTreePanel.this.treeGraphView.getTreeNodeForElement((AWTreeGraphView.GElementNode)gElement);
                if (treeNode == null) {
                    return;
                }
                boolean bl2 = bl = (mouseEvent.getModifiersEx() & 0x40) == 64;
                if (AWTreePanel.this.delegate != null) {
                    AWTreePanel.this.delegate.awTreeDidSelectTreeNode(treeNode, bl);
                }
                AWTreePanel.this.selectNode(treeNode);
            }
            this.origin = SwingUtilities.convertPoint(AWTreePanel.this.treeGraphView, mouseEvent.getPoint(), null);
            this.r = AWTreePanel.this.treeGraphView.getVisibleRect();
            this.dragging = true;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragging = false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.dragging) {
                return;
            }
            Point point = SwingUtilities.convertPoint(AWTreePanel.this.treeGraphView, mouseEvent.getPoint(), null);
            Rectangle rectangle = new Rectangle(this.r);
            rectangle.x -= point.x - this.origin.x;
            rectangle.y -= point.y - this.origin.y;
            AWTreePanel.this.treeGraphView.scrollRectToVisible(rectangle);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

