/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.awtree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.works.awtree.AWTreeModel;
import org.antlr.works.awtree.AWTreeNode;
import org.antlr.works.awtree.AWTreePanel;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GElementRect;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.shape.SLinkElbow;

public class AWTreeGraphView
extends GView {
    public static final boolean DRAGGABLE = false;
    public static final int HORIZONTAL_GAP = 20;
    public static final int VERTICAL_GAP = 20;
    public static final int MARGIN = 10;
    public static final Color HIGHLIGHTED_COLOR = new Color(0.0f, 0.5f, 1.0f, 0.4f);
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 11);
    protected TreeNode root;
    protected GElementNode highlightedNode;
    protected Map<TreeNode, GElement> treeNodeToGElementMap = new HashMap<TreeNode, GElement>();
    protected Map<GElement, TreeNode> gelementToTreeNodeMap = new HashMap<GElement, TreeNode>();
    protected AWTreePanel panel;
    protected AWTreeModel model;
    protected Graphics2D g2d;
    protected FontMetrics fontMetrics;
    protected boolean dirty = true;

    public AWTreeGraphView(AWTreePanel aWTreePanel) {
        this.panel = aWTreePanel;
        this.setPreferredSize(new Dimension(0, 0));
        this.setFocusable(true);
    }

    public void addDefaultEventManager() {
    }

    public void setModel(AWTreeModel aWTreeModel) {
        this.model = aWTreeModel;
    }

    public void setRoot(TreeNode treeNode) {
        this.root = treeNode;
    }

    public void clear() {
        if (this.model != null) {
            this.model.clear();
        }
        this.clearMaps();
    }

    public void refresh() {
        this.dirty = true;
        this.rebuild();
        this.repaint();
    }

    public void rebuild() {
        if (this.g2d == null || this.root == null) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
            if (this.model == null) {
                this.rebuildNoModel();
            } else {
                this.rebuildWithModel();
            }
        }
    }

    public void clearMaps() {
        this.treeNodeToGElementMap.clear();
        this.gelementToTreeNodeMap.clear();
    }

    public void mapNodeAndElement(TreeNode treeNode, GElement gElement) {
        this.treeNodeToGElementMap.put(treeNode, gElement);
        this.gelementToTreeNodeMap.put(gElement, treeNode);
    }

    public TreeNode getTreeNodeForElement(GElementNode gElementNode) {
        return this.gelementToTreeNodeMap.get(gElementNode);
    }

    public GElementNode getGElementForNode(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        return (GElementNode)this.treeNodeToGElementMap.get(treeNode);
    }

    public void rebuildNoModel() {
        this.clearMaps();
        GElementNode gElementNode = this.buildGraph(null);
        gElementNode.move(10.0, 10.0);
        this.setSizeMargin(10);
        this.setRootElement(gElementNode);
    }

    public GElementNode buildGraph(TreeNode treeNode) {
        GElementNode gElementNode;
        if (treeNode == null) {
            treeNode = this.root;
        }
        if ((gElementNode = this.getGElementForNode(treeNode)) == null) {
            gElementNode = this.createGElement(treeNode);
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            this.addChildElement(gElementNode, this.createGElement(treeNode2));
            this.buildGraph(treeNode2);
        }
        this.adjustElementPositionRelativeToItsChildren(treeNode, false);
        return gElementNode;
    }

    public void rebuildWithModel() {
        for (int i = 0; i < this.model.getNewNodesCount(); ++i) {
            AWTreeNode aWTreeNode = this.model.getNewNodeParentAtIndex(i);
            AWTreeNode aWTreeNode2 = this.model.getNewNodeAtIndex(i);
            GElementNode gElementNode = this.getGElementForNode(aWTreeNode);
            if (gElementNode == null) {
                gElementNode = this.createGElement(this.root);
                gElementNode.move(10.0, 10.0);
                this.setSizeMargin(10);
                this.setRootElement(gElementNode);
            }
            GElementNode gElementNode2 = this.createGElement(aWTreeNode2);
            this.addChildElement(gElementNode, gElementNode2);
            this.adjustElementPositionRelativeToItsChildren(aWTreeNode, true);
        }
        this.autoAdjustSize();
        this.model.clearNewNodes();
    }

    public void paintComponent(Graphics graphics) {
        if (this.g2d != graphics) {
            this.g2d = (Graphics2D)graphics;
            this.g2d.setFont(DEFAULT_FONT);
            this.fontMetrics = this.g2d.getFontMetrics();
        }
        this.rebuild();
        super.paintComponent(graphics);
    }

    public void addChildElement(GElementNode gElementNode, GElementNode gElementNode2) {
        double d = gElementNode.getLastChildRightSpan();
        d = d > 0.0 ? (d += 20.0) : gElementNode.getLeft();
        gElementNode2.setPositionOfUpperLeftCorner(d, gElementNode.getBottom() + 20.0);
        GLink gLink = new GLink(gElementNode, "BOTTOM", gElementNode2, "TOP", 1, "", 0.0);
        gLink.setDraggable(false);
        SLinkElbow sLinkElbow = (SLinkElbow)gLink.getLink();
        sLinkElbow.setOutOffsetLength(10);
        sLinkElbow.getArrow().setLength(6.0);
        gElementNode.addElement(gLink);
        gElementNode.addElement(gElementNode2);
    }

    public void adjustElementPositionRelativeToItsChildren(TreeNode treeNode, boolean bl) {
        GElementNode gElementNode = this.getGElementForNode(treeNode);
        if (gElementNode == null) {
            return;
        }
        double d = gElementNode.getWidth();
        double d2 = gElementNode.getLastChildRightSpan() - gElementNode.getFirstChildLeftSpan();
        if (d2 == 0.0) {
            return;
        }
        double d3 = Math.min(gElementNode.getLeft(), gElementNode.getFirstChildLeftSpan());
        double d4 = gElementNode.getTop();
        double d5 = Math.max(d, d2);
        double d6 = d5 * 0.5 - d2 * 0.5;
        double d7 = d3 + d6 - gElementNode.getFirstChildLeftSpan();
        gElementNode.move(d7, 0.0);
        gElementNode.setPositionOfUpperLeftCorner(d3 + d5 * 0.5 - d * 0.5, d4);
        gElementNode.setSpanWidth(d5);
        if (bl) {
            this.adjustElementPositionRelativeToItsChildren(treeNode.getParent(), bl);
        }
    }

    public String getNodeLabel(TreeNode treeNode) {
        if (treeNode instanceof ParseTree) {
            Object object = ((ParseTree)((Object)treeNode)).payload;
            if (object instanceof CommonToken) {
                CommonToken commonToken = (CommonToken)object;
                return commonToken.getText();
            }
            return object.toString();
        }
        return treeNode.toString();
    }

    public Color getNodeColor(TreeNode treeNode) {
        if (treeNode instanceof AWTreeNode) {
            return ((AWTreeNode)treeNode).getColor();
        }
        return Color.black;
    }

    public GElementNode createGElement(TreeNode treeNode) {
        Color color = this.getNodeColor(treeNode);
        String string = this.getNodeLabel(treeNode);
        double d = (string == null ? 0 : this.fontMetrics.stringWidth(string)) + 16;
        double d2 = this.fontMetrics.getHeight() + 8;
        GElementNode gElementNode = new GElementNode();
        gElementNode.setDraggable(false);
        gElementNode.setSize(d, d2);
        gElementNode.setPositionOfUpperLeftCorner(0.0, 0.0);
        gElementNode.setLabel(string);
        gElementNode.setColor(color);
        gElementNode.setLabelColor(color);
        this.mapNodeAndElement(treeNode, gElementNode);
        return gElementNode;
    }

    public void highlightNode(TreeNode treeNode) {
        GElementNode gElementNode;
        if (this.highlightedNode != null) {
            this.highlightedNode.setHighlighted(false);
            this.highlightedNode = null;
        }
        if ((gElementNode = this.getGElementForNode(treeNode)) == null) {
            return;
        }
        gElementNode.setHighlighted(true);
        this.highlightedNode = gElementNode;
        this.scrollNodeToVisible(treeNode);
        this.repaint();
    }

    public void repaintNode(TreeNode treeNode) {
        GElementNode gElementNode = this.getGElementForNode(treeNode);
        if (gElementNode == null) {
            return;
        }
        if (treeNode instanceof AWTreeNode) {
            Color color = ((AWTreeNode)treeNode).getColor();
            gElementNode.setColor(color);
            gElementNode.setLabelColor(color);
        }
    }

    public void scrollNodeToVisible(TreeNode treeNode) {
        GElementNode gElementNode = this.getGElementForNode(treeNode);
        if (gElementNode == null) {
            return;
        }
        this.scrollElementToVisible(gElementNode);
    }

    public JPopupMenu getContextualMenu(GElement gElement) {
        return this.panel.getContextualMenu();
    }

    public static class GElementNode
    extends GElementRect {
        public boolean highlighted = false;
        public double spanWidth = 0.0;

        public void setHighlighted(boolean bl) {
            this.highlighted = bl;
        }

        public void draw(Graphics2D graphics2D) {
            if (this.highlighted && this.isVisibleInClip(graphics2D)) {
                Rectangle rectangle = this.getFrame().rectangle();
                graphics2D.setColor(HIGHLIGHTED_COLOR);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            super.draw(graphics2D);
        }

        public void setSpanWidth(double d) {
            this.spanWidth = d;
        }

        public double getLeftSpan() {
            if (this.spanWidth <= this.getWidth()) {
                return this.getLeft();
            }
            return this.getLeft() - (this.spanWidth - this.getWidth()) * 0.5;
        }

        public double getRightSpan() {
            if (this.spanWidth <= this.getWidth()) {
                return this.getRight();
            }
            return this.getRight() + (this.spanWidth - this.getWidth()) * 0.5;
        }

        public double getLastChildRightSpan() {
            if (this.elements == null) {
                return 0.0;
            }
            for (int i = this.elements.size() - 1; i >= 0; --i) {
                GElement gElement = (GElement)this.elements.get(i);
                if (!(gElement instanceof GElementNode)) continue;
                GElementNode gElementNode = (GElementNode)gElement;
                return gElementNode.getRightSpan();
            }
            return 0.0;
        }

        public double getFirstChildLeftSpan() {
            if (this.elements == null) {
                return 0.0;
            }
            for (GElement gElement : this.elements) {
                if (!(gElement instanceof GElementNode)) continue;
                GElementNode gElementNode = (GElementNode)gElement;
                return gElementNode.getLeftSpan();
            }
            return 0.0;
        }

        public double getLeft() {
            return this.getFrame().r.x;
        }

        public double getTop() {
            return this.getFrame().r.y;
        }

        public double getRight() {
            Rect rect = this.getFrame();
            return rect.r.x + rect.r.width;
        }

        public double getBottom() {
            Rect rect = this.getFrame();
            return rect.r.y + rect.r.height;
        }

        public void setTop(double d) {
            this.position.y = d + this.getHeight() * 0.5;
        }
    }
}

