/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.syntax.misc;

public abstract class ATEThread
implements Runnable {
    protected int threadSleep = 100;
    protected int threshold = 0;
    protected int default_threshold = 250;
    protected boolean running = false;
    protected boolean run = false;
    protected Thread thread = null;
    protected boolean asleep = false;
    protected boolean skip = false;

    public void setDefaultThreshold(int n) {
        this.default_threshold = n;
    }

    public synchronized void setRunning(boolean bl) {
        this.running = bl;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    protected synchronized void start() {
        this.threadSleep = Integer.MAX_VALUE;
        this.start_();
    }

    protected synchronized void start(int n) {
        this.threadSleep = n;
        this.start_();
    }

    private void start_() {
        if (!this.run) {
            this.run = true;
            this.thread = new Thread(this);
            this.thread.setName(this.getClass().toString());
            this.thread.start();
        }
    }

    public synchronized void skip() {
        this.skip = true;
    }

    private synchronized void resetSkip() {
        this.skip = false;
    }

    public synchronized void stop() {
        this.threshold = 0;
        this.run = false;
        this.thread.interrupt();
    }

    public synchronized void awakeThread() {
        this.awakeThread(this.default_threshold);
    }

    public synchronized void awakeThread(int n) {
        this.resetSkip();
        this.threshold = n;
        if (this.asleep) {
            this.thread.interrupt();
        }
    }

    public boolean cancel() {
        return !this.run;
    }

    protected abstract void threadRun() throws Exception;

    public void threadReportException(Exception exception) {
        exception.printStackTrace();
    }

    public boolean threadSleep(int n) {
        boolean bl = false;
        this.asleep = true;
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            bl = true;
        }
        this.asleep = false;
        return bl;
    }

    public void run() {
        this.setRunning(true);
        while (this.run) {
            if (this.threadSleep(this.threadSleep) && this.threshold > 0) {
                while (this.threadSleep(this.threshold)) {
                }
            }
            if (!this.run) break;
            if (this.skip) {
                this.resetSkip();
                continue;
            }
            try {
                this.threadRun();
            }
            catch (Exception exception) {
                this.threadReportException(exception);
            }
        }
        this.setRunning(false);
    }
}

